/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;

public class MessageResourceBundle {
    private static FrameworkAdaptor adaptor;
    static final Object ASSIGNED;
    private static final String EXTENSION = ".properties";
    private static String[] nlSuffixes;
    static int SEVERITY_ERROR;
    static int SEVERITY_WARNING;

    private static String[] buildVariants(String root) {
        if (nlSuffixes == null) {
            String nl = Locale.getDefault().toString();
            ArrayList<String> result = new ArrayList<String>(4);
            while (true) {
                result.add('_' + nl + EXTENSION);
                int lastSeparator = nl.lastIndexOf(95);
                if (lastSeparator == -1) break;
                nl = nl.substring(0, lastSeparator);
            }
            result.add(EXTENSION);
            nlSuffixes = result.toArray(new String[result.size()]);
        }
        root = root.replace('.', '/');
        String[] variants = new String[nlSuffixes.length];
        for (int i2 = 0; i2 < variants.length; ++i2) {
            variants[i2] = root + nlSuffixes[i2];
        }
        return variants;
    }

    static void makeAccessible(final Field field) {
        if (System.getSecurityManager() == null) {
            field.setAccessible(true);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
        }
    }

    private static void computeMissingMessages(String bundleName, Class clazz, Map fieldMap, Field[] fieldArray, boolean isAccessible) {
        int MOD_EXPECTED = 9;
        int MOD_MASK = 25;
        int numFields = fieldArray.length;
        for (int i2 = 0; i2 < numFields; ++i2) {
            Field field = fieldArray[i2];
            if ((field.getModifiers() & 0x19) != 9 || fieldMap.get(field.getName()) == ASSIGNED) continue;
            try {
                String value = "NLS missing message: " + field.getName() + " in: " + bundleName;
                if (Debug.DEBUG_MESSAGE_BUNDLES) {
                    System.out.println(value);
                }
                MessageResourceBundle.log(SEVERITY_WARNING, value, null);
                if (!isAccessible) {
                    MessageResourceBundle.makeAccessible(field);
                }
                field.set(null, value);
                continue;
            }
            catch (Exception e2) {
                MessageResourceBundle.log(SEVERITY_ERROR, "Error setting the missing message value for: " + field.getName(), e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void load(String bundleName, Class clazz) {
        long start = System.currentTimeMillis();
        Field[] fieldArray = clazz.getDeclaredFields();
        ClassLoader loader = clazz.getClassLoader();
        boolean isAccessible = (clazz.getModifiers() & 1) != 0;
        int len = fieldArray.length;
        HashMap<String, Field> fields = new HashMap<String, Field>(len * 2);
        for (int i2 = 0; i2 < len; ++i2) {
            fields.put(fieldArray[i2].getName(), fieldArray[i2]);
        }
        String[] variants = MessageResourceBundle.buildVariants(bundleName);
        for (int i3 = 0; i3 < variants.length; ++i3) {
            InputStream input = loader.getResourceAsStream(variants[i3]);
            if (input == null) continue;
            MessagesProperties properties = new MessagesProperties(fields, bundleName, isAccessible);
            properties.load(input);
            Object var14_14 = null;
            if (input == null) continue;
            try {
                input.close();
            }
            catch (IOException e2) {}
            continue;
            {
                catch (IOException e3) {
                    MessageResourceBundle.log(SEVERITY_ERROR, "Error loading " + variants[i3], e3);
                    var14_14 = null;
                    if (input == null) continue;
                    try {
                        input.close();
                    }
                    catch (IOException e2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var14_14 = null;
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        MessageResourceBundle.computeMissingMessages(bundleName, clazz, fields, fieldArray, isAccessible);
        if (Debug.DEBUG_MESSAGE_BUNDLES) {
            System.out.println("Time to load message bundle: " + bundleName + " was " + (System.currentTimeMillis() - start) + "ms.");
        }
    }

    static void log(int severity, String msg, Exception e2) {
        if (adaptor != null) {
            adaptor.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi " + severity + ' ' + 1, msg, 0, e2, null));
        } else {
            System.out.println(msg);
            if (e2 != null) {
                e2.printStackTrace();
            }
        }
    }

    static void setAdaptor(FrameworkAdaptor adaptor) {
        MessageResourceBundle.adaptor = adaptor;
    }

    static {
        ASSIGNED = new Object();
        SEVERITY_ERROR = 4;
        SEVERITY_WARNING = 2;
    }

    private static class MessagesProperties
    extends Properties {
        private static final int MOD_EXPECTED = 9;
        private static final int MOD_MASK = 25;
        private static final long serialVersionUID = 1L;
        private final String bundleName;
        private final Map fields;
        private final boolean isAccessible;

        public MessagesProperties(Map fieldMap, String bundleName, boolean isAccessible) {
            this.fields = fieldMap;
            this.bundleName = bundleName;
            this.isAccessible = isAccessible;
        }

        public synchronized Object put(Object key, Object value) {
            Object fieldObject = this.fields.put(key, ASSIGNED);
            if (fieldObject == ASSIGNED) {
                return null;
            }
            if (fieldObject == null) {
                String msg = "NLS unused message: " + key + " in: " + this.bundleName;
                if (Debug.DEBUG_MESSAGE_BUNDLES) {
                    System.out.println(msg);
                }
                MessageResourceBundle.log(SEVERITY_WARNING, msg, null);
                return null;
            }
            Field field = (Field)fieldObject;
            if ((field.getModifiers() & 0x19) != 9) {
                return null;
            }
            try {
                if (!this.isAccessible) {
                    MessageResourceBundle.makeAccessible(field);
                }
                field.set(null, value);
            }
            catch (Exception e2) {
                MessageResourceBundle.log(SEVERITY_ERROR, "Exception setting field value.", e2);
            }
            return null;
        }
    }
}

