/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.osgi.framework.internal.core.KeyedElement;

public class KeyedHashSet {
    protected static final int MINIMUM_SIZE = 7;
    protected int elementCount = 0;
    protected KeyedElement[] elements;
    protected boolean replace;
    private int capacity;

    public KeyedHashSet() {
        this(7, true);
    }

    public KeyedHashSet(boolean replace) {
        this(7, replace);
    }

    public KeyedHashSet(int capacity) {
        this(capacity, true);
    }

    public KeyedHashSet(int capacity, boolean replace) {
        this.elements = new KeyedElement[Math.max(7, capacity * 2)];
        this.replace = replace;
        this.capacity = capacity;
    }

    public KeyedHashSet(KeyedHashSet original) {
        this.elements = new KeyedElement[original.elements.length];
        System.arraycopy(original.elements, 0, this.elements, 0, original.elements.length);
        this.elementCount = original.elementCount;
        this.replace = original.replace;
        this.capacity = original.capacity;
    }

    public boolean add(KeyedElement element) {
        int hash;
        int i2;
        for (i2 = hash = this.hash(element); i2 < this.elements.length; ++i2) {
            if (this.elements[i2] == null) {
                this.elements[i2] = element;
                ++this.elementCount;
                if (this.shouldGrow()) {
                    this.expand();
                }
                return true;
            }
            if (!this.elements[i2].compare(element)) continue;
            if (this.replace) {
                this.elements[i2] = element;
            }
            return this.replace;
        }
        for (i2 = 0; i2 < hash - 1; ++i2) {
            if (this.elements[i2] == null) {
                this.elements[i2] = element;
                ++this.elementCount;
                if (this.shouldGrow()) {
                    this.expand();
                }
                return true;
            }
            if (!this.elements[i2].compare(element)) continue;
            if (this.replace) {
                this.elements[i2] = element;
            }
            return this.replace;
        }
        this.expand();
        return this.add(element);
    }

    public void addAll(KeyedElement[] toAdd) {
        for (int i2 = 0; i2 < toAdd.length; ++i2) {
            this.add(toAdd[i2]);
        }
    }

    public boolean contains(KeyedElement element) {
        return this.get(element) != null;
    }

    public boolean containsKey(Object key) {
        return this.getByKey(key) != null;
    }

    public KeyedElement[] elements() {
        return (KeyedElement[])this.elements(new KeyedElement[this.elementCount]);
    }

    public Object[] elements(Object[] result) {
        int j2 = 0;
        for (int i2 = 0; i2 < this.elements.length; ++i2) {
            KeyedElement element = this.elements[i2];
            if (element == null) continue;
            result[j2++] = element;
        }
        return result;
    }

    protected void expand() {
        KeyedElement[] oldElements = this.elements;
        this.elements = new KeyedElement[this.elements.length * 2];
        int maxArrayIndex = this.elements.length - 1;
        for (int i2 = 0; i2 < oldElements.length; ++i2) {
            KeyedElement element = oldElements[i2];
            if (element == null) continue;
            int hash = this.hash(element);
            while (this.elements[hash] != null) {
                if (++hash <= maxArrayIndex) continue;
                hash = 0;
            }
            this.elements[hash] = element;
        }
    }

    public KeyedElement getByKey(Object key) {
        KeyedElement element;
        int hash;
        int i2;
        if (this.elementCount == 0) {
            return null;
        }
        for (i2 = hash = this.keyHash(key); i2 < this.elements.length; ++i2) {
            element = this.elements[i2];
            if (element == null) {
                return null;
            }
            if (!element.getKey().equals(key)) continue;
            return element;
        }
        for (i2 = 0; i2 < hash - 1; ++i2) {
            element = this.elements[i2];
            if (element == null) {
                return null;
            }
            if (!element.getKey().equals(key)) continue;
            return element;
        }
        return null;
    }

    public KeyedElement get(KeyedElement key) {
        KeyedElement element;
        int hash;
        int i2;
        if (this.elementCount == 0) {
            return null;
        }
        for (i2 = hash = this.hash(key); i2 < this.elements.length; ++i2) {
            element = this.elements[i2];
            if (element == null) {
                return null;
            }
            if (!element.compare(key)) continue;
            return element;
        }
        for (i2 = 0; i2 < hash - 1; ++i2) {
            element = this.elements[i2];
            if (element == null) {
                return null;
            }
            if (!element.compare(key)) continue;
            return element;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    protected void rehashTo(int anIndex) {
        int target = anIndex;
        int index = anIndex + 1;
        if (index >= this.elements.length) {
            index = 0;
        }
        KeyedElement element = this.elements[index];
        while (element != null) {
            boolean match;
            int hashIndex = this.hash(element);
            if (index < target) {
                match = hashIndex <= target && hashIndex > index;
            } else {
                boolean bl = match = hashIndex <= target || hashIndex > index;
            }
            if (match) {
                this.elements[target] = element;
                target = index;
            }
            if (++index >= this.elements.length) {
                index = 0;
            }
            element = this.elements[index];
        }
        this.elements[target] = null;
    }

    public boolean removeByKey(Object key) {
        KeyedElement element;
        int hash;
        int i2;
        if (this.elementCount == 0) {
            return false;
        }
        for (i2 = hash = this.keyHash(key); i2 < this.elements.length; ++i2) {
            element = this.elements[i2];
            if (element == null) {
                return false;
            }
            if (!element.getKey().equals(key)) continue;
            this.rehashTo(i2);
            --this.elementCount;
            return true;
        }
        for (i2 = 0; i2 < hash - 1; ++i2) {
            element = this.elements[i2];
            if (element == null) {
                return false;
            }
            if (!element.getKey().equals(key)) continue;
            this.rehashTo(i2);
            --this.elementCount;
            return true;
        }
        return true;
    }

    public boolean remove(KeyedElement toRemove) {
        KeyedElement element;
        int hash;
        int i2;
        if (this.elementCount == 0) {
            return false;
        }
        for (i2 = hash = this.hash(toRemove); i2 < this.elements.length; ++i2) {
            element = this.elements[i2];
            if (element == null) {
                return false;
            }
            if (!element.compare(toRemove)) continue;
            this.rehashTo(i2);
            --this.elementCount;
            return true;
        }
        for (i2 = 0; i2 < hash - 1; ++i2) {
            element = this.elements[i2];
            if (element == null) {
                return false;
            }
            if (!element.compare(toRemove)) continue;
            this.rehashTo(i2);
            --this.elementCount;
            return true;
        }
        return false;
    }

    private int hash(KeyedElement element) {
        return Math.abs(element.getKeyHashCode()) % this.elements.length;
    }

    private int keyHash(Object key) {
        return Math.abs(key.hashCode()) % this.elements.length;
    }

    public void removeAll(KeyedElement[] toRemove) {
        for (int i2 = 0; i2 < toRemove.length; ++i2) {
            this.remove(toRemove[i2]);
        }
    }

    private boolean shouldGrow() {
        return (double)this.elementCount > (double)this.elements.length * 0.75;
    }

    public int size() {
        return this.elementCount;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(100);
        result.append("{");
        boolean first = true;
        for (int i2 = 0; i2 < this.elements.length; ++i2) {
            if (this.elements[i2] == null) continue;
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(this.elements[i2]);
        }
        result.append("}");
        return result.toString();
    }

    public int countCollisions() {
        int result = 0;
        int lastHash = 0;
        boolean found = false;
        for (int i2 = 0; i2 < this.elements.length; ++i2) {
            KeyedElement element = this.elements[i2];
            if (element == null) {
                found = false;
                continue;
            }
            int hash = this.hash(element);
            if (found) {
                if (lastHash == hash) {
                    ++result;
                    continue;
                }
                found = false;
                continue;
            }
            lastHash = hash;
            found = true;
        }
        return result;
    }

    public Iterator iterator() {
        return new KeyedHashSetIterator();
    }

    public void clear() {
        this.elements = new KeyedElement[Math.max(7, this.capacity * 2)];
        this.elementCount = 0;
    }

    class KeyedHashSetIterator
    implements Iterator {
        private int currentIndex = -1;
        private int found;

        KeyedHashSetIterator() {
        }

        public boolean hasNext() {
            return this.found < KeyedHashSet.this.elementCount;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            while (++this.currentIndex < KeyedHashSet.this.elements.length) {
                if (KeyedHashSet.this.elements[this.currentIndex] == null) continue;
                ++this.found;
                return KeyedHashSet.this.elements[this.currentIndex];
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

