/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.SingleSourcePackage;
import org.eclipse.osgi.util.ManifestElement;

public class FilteredSourcePackage
extends SingleSourcePackage {
    private static final char ALL = '*';
    String[] includes;
    String[] excludes;
    String[] friends;

    public FilteredSourcePackage(String name, int expid, BundleLoaderProxy supplier, String includes, String excludes, String[] friends) {
        super(name, expid, supplier);
        if (includes != null) {
            this.includes = ManifestElement.getArrayFromList(includes);
        }
        if (excludes != null) {
            this.excludes = ManifestElement.getArrayFromList(excludes);
        }
        this.friends = friends;
    }

    public boolean isFriend(String symbolicName) {
        if (this.friends == null) {
            return true;
        }
        for (int i2 = 0; i2 < this.friends.length; ++i2) {
            if (!this.friends[i2].equals(symbolicName)) continue;
            return true;
        }
        return false;
    }

    public URL getResource(String name) {
        if (this.isFiltered(name, this.getId())) {
            return null;
        }
        return super.getResource(name);
    }

    public Enumeration getResources(String name) {
        if (this.isFiltered(name, this.getId())) {
            return null;
        }
        return super.getResources(name);
    }

    public Class loadClass(String name) {
        if (this.isFiltered(name, this.getId())) {
            return null;
        }
        return super.loadClass(name);
    }

    private boolean isFiltered(String name, String pkgName) {
        String lastName = this.getName(name, pkgName);
        return !this.isIncluded(lastName) || this.isExcluded(lastName);
    }

    private String getName(String name, String pkgName) {
        if (!".".equals(pkgName) && pkgName.length() + 1 <= name.length()) {
            return name.substring(pkgName.length() + 1);
        }
        return name;
    }

    private boolean isIncluded(String name) {
        if (this.includes == null) {
            return true;
        }
        return this.isInList(name, this.includes);
    }

    private boolean isExcluded(String name) {
        if (this.excludes == null) {
            return false;
        }
        return this.isInList(name, this.excludes);
    }

    private boolean isInList(String name, String[] list) {
        for (int i2 = 0; i2 < list.length; ++i2) {
            int len = list[i2].length();
            if (len == 0) continue;
            if (list[i2].charAt(0) == '*' && len == 1) {
                return true;
            }
            if (list[i2].charAt(len - 1) == '*' && name.startsWith(list[i2].substring(0, len - 1))) {
                return true;
            }
            if (!name.equals(list[i2])) continue;
            return true;
        }
        return false;
    }
}

