/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.IBuddyPolicy;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class DependentPolicy
implements IBuddyPolicy {
    BundleLoader buddyRequester;
    int lastDependentOfAdded = -1;
    List allDependents = null;

    public DependentPolicy(BundleLoader requester) {
        this.buddyRequester = requester;
        this.allDependents = new ArrayList();
        this.basicAddImmediateDependents(this.buddyRequester.getBundle().getBundleDescription());
        if (this.allDependents.size() == 0) {
            this.allDependents = null;
        }
    }

    public Class loadClass(String name) {
        if (this.allDependents == null) {
            return null;
        }
        Class result = null;
        for (int i2 = 0; i2 < this.allDependents.size() && result == null; ++i2) {
            BundleDescription searchedBundle = (BundleDescription)this.allDependents.get(i2);
            try {
                BundleLoaderProxy proxy = this.buddyRequester.getLoaderProxy(searchedBundle);
                if (proxy == null) continue;
                result = proxy.getBundleLoader().findClass(name, true);
                continue;
            }
            catch (ClassNotFoundException e2) {
                if (result != null) continue;
                this.addDependent(i2, searchedBundle);
            }
        }
        return result;
    }

    private synchronized void addDependent(int i2, BundleDescription searchedBundle) {
        if (i2 > this.lastDependentOfAdded) {
            this.lastDependentOfAdded = i2;
            this.basicAddImmediateDependents(searchedBundle);
        }
    }

    public URL loadResource(String name) {
        if (this.allDependents == null) {
            return null;
        }
        URL result = null;
        for (int i2 = 0; i2 < this.allDependents.size() && result == null; ++i2) {
            BundleDescription searchedBundle = (BundleDescription)this.allDependents.get(i2);
            BundleLoaderProxy proxy = this.buddyRequester.getLoaderProxy(searchedBundle);
            if (proxy == null || (result = proxy.getBundleLoader().findResource(name, true)) != null) continue;
            this.addDependent(i2, searchedBundle);
        }
        return result;
    }

    public Enumeration loadResources(String name) {
        if (this.allDependents == null) {
            return null;
        }
        Enumeration result = null;
        for (int i2 = 0; i2 < this.allDependents.size() && result == null; ++i2) {
            BundleDescription searchedBundle = (BundleDescription)this.allDependents.get(i2);
            try {
                BundleLoaderProxy proxy = this.buddyRequester.getLoaderProxy(searchedBundle);
                if (proxy == null) continue;
                result = proxy.getBundleLoader().findResources(name);
            }
            catch (IOException e2) {
                continue;
            }
            if (result != null) continue;
            this.addDependent(i2, searchedBundle);
        }
        return result;
    }

    private void basicAddImmediateDependents(BundleDescription root) {
        BundleDescription[] dependents = root.getDependents();
        for (int i2 = 0; i2 < dependents.length; ++i2) {
            BundleDescription toAdd = dependents[i2];
            if (toAdd.getHost() != null || this.allDependents.contains(toAdd)) continue;
            this.allDependents.add(toAdd);
        }
    }
}

