/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.HashMap;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionInfoImpl;
import org.eclipse.osgi.framework.internal.core.PermissionsHash;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.permissionadmin.PermissionInfo;

public class ConditionalPermissionSet
extends PermissionCollection {
    private static final long serialVersionUID = 3258411750729920566L;
    ConditionalPermissionInfoImpl[] cpis = new ConditionalPermissionInfoImpl[0];
    HashMap cachedPermissionCollections = new HashMap();
    private boolean hasAllPermission = false;
    Condition[] neededConditions;
    static /* synthetic */ Class class$java$security$AllPermission;

    public ConditionalPermissionSet(ConditionalPermissionInfoImpl[] cpis, Condition[] neededConditions) {
        this.cpis = cpis;
        this.neededConditions = neededConditions;
        this.checkForAllPermission();
    }

    void addConditionalPermissionInfo(ConditionalPermissionInfoImpl cpi) {
        if (this.neededConditions.length > 0) {
            throw new RuntimeException("Cannot add ConditionalPermissionInfoImpl to a non satisfied set");
        }
        ConditionalPermissionInfoImpl[] newcpis = new ConditionalPermissionInfoImpl[this.cpis.length + 1];
        System.arraycopy(this.cpis, 0, newcpis, 0, this.cpis.length);
        newcpis[this.cpis.length] = cpi;
        this.cpis = newcpis;
        this.cachedPermissionCollections.clear();
        this.checkForAllPermission();
    }

    private void checkForAllPermission() {
        if (this.hasAllPermission) {
            return;
        }
        block0: for (int i2 = 0; i2 < this.cpis.length; ++i2) {
            PermissionInfo[] perms = this.cpis[i2].perms;
            for (int j2 = 0; j2 < perms.length; ++j2) {
                if (!perms[j2].getType().equals((class$java$security$AllPermission == null ? ConditionalPermissionSet.class$("java.security.AllPermission") : class$java$security$AllPermission).getName())) continue;
                this.hasAllPermission = true;
                break block0;
            }
        }
    }

    boolean isNonEmpty() {
        boolean nonEmpty = false;
        for (int i2 = 0; i2 < this.cpis.length; ++i2) {
            if (this.cpis[i2] == null) continue;
            if (this.cpis[i2].isDeleted()) {
                this.cpis[i2] = null;
                this.cachedPermissionCollections.clear();
                continue;
            }
            nonEmpty = true;
        }
        if (!nonEmpty) {
            this.cpis = new ConditionalPermissionInfoImpl[0];
        }
        return nonEmpty;
    }

    Condition[] getNeededConditions() {
        if (this.neededConditions == null || this.neededConditions.length == 0) {
            return this.neededConditions;
        }
        boolean foundNonNullCondition = false;
        for (int i2 = 0; i2 < this.neededConditions.length; ++i2) {
            Condition cond = this.neededConditions[i2];
            if (cond == null) continue;
            if (!cond.isMutable()) {
                if (cond.isSatisfied()) {
                    this.neededConditions[i2] = null;
                    continue;
                }
                this.neededConditions = null;
                break;
            }
            foundNonNullCondition = true;
        }
        if (this.neededConditions != null && !foundNonNullCondition) {
            this.neededConditions = new Condition[0];
        }
        return this.neededConditions;
    }

    public void add(Permission perm) {
    }

    public boolean implies(Permission perm) {
        if (this.hasAllPermission) {
            return true;
        }
        Class<?> permClass = perm.getClass();
        PermissionCollection collection = (PermissionCollection)this.cachedPermissionCollections.get(permClass);
        if (collection == null) {
            collection = perm.newPermissionCollection();
            if (collection == null) {
                collection = new PermissionsHash();
            }
            for (int i2 = 0; i2 < this.cpis.length; ++i2) {
                try {
                    ConditionalPermissionInfoImpl cpi = this.cpis[i2];
                    if (cpi == null) continue;
                    cpi.addPermissions(collection, permClass);
                    continue;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            this.cachedPermissionCollections.put(permClass, collection);
        }
        return collection.implies(perm);
    }

    public Enumeration elements() {
        return null;
    }

    void unresolvePermissions(AbstractBundle[] refreshedBundles) {
        this.cachedPermissionCollections.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

