/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Permission;
import java.security.PermissionCollection;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionAdminImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.permissionadmin.PermissionInfo;

public class ConditionalPermissionInfoImpl
implements ConditionalPermissionInfo,
Serializable {
    private static final long serialVersionUID = 3258130245704825139L;
    PermissionInfo[] perms;
    ConditionInfo[] conds;
    boolean deleted = false;
    private static Class[] twoStringClassArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ConditionalPermissionInfoImpl.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ConditionalPermissionInfoImpl.class$("java.lang.String")) : class$java$lang$String};
    private static Class[] condClassArray = new Class[]{class$org$osgi$framework$Bundle == null ? (class$org$osgi$framework$Bundle = ConditionalPermissionInfoImpl.class$("org.osgi.framework.Bundle")) : class$org$osgi$framework$Bundle, class$org$osgi$service$condpermadmin$ConditionInfo == null ? (class$org$osgi$service$condpermadmin$ConditionInfo = ConditionalPermissionInfoImpl.class$("org.osgi.service.condpermadmin.ConditionInfo")) : class$org$osgi$service$condpermadmin$ConditionInfo};
    static ConditionalPermissionAdminImpl condAdmin;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$osgi$framework$Bundle;
    static /* synthetic */ Class class$org$osgi$service$condpermadmin$ConditionInfo;

    boolean isDeleted() {
        return this.deleted;
    }

    public ConditionalPermissionInfoImpl(ConditionInfo[] conds, PermissionInfo[] perms) {
        this.conds = conds;
        this.perms = perms;
    }

    public ConditionInfo[] getConditionInfos() {
        if (this.conds == null) {
            return null;
        }
        ConditionInfo[] results = new ConditionInfo[this.conds.length];
        System.arraycopy(this.conds, 0, results, 0, this.conds.length);
        return results;
    }

    int addPermissions(PermissionCollection collection, Class permClass) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String permClassName = permClass.getName();
        Constructor constructor = permClass.getConstructor(twoStringClassArray);
        int count = 0;
        for (int i2 = 0; i2 < this.perms.length; ++i2) {
            if (!this.perms[i2].getType().equals(permClassName)) continue;
            ++count;
            Object[] args = new String[]{this.perms[i2].getName(), this.perms[i2].getActions()};
            collection.add((Permission)constructor.newInstance(args));
        }
        return count;
    }

    Condition[] getConditions(Bundle bundle) {
        Condition[] conditions = new Condition[this.conds.length];
        for (int i2 = 0; i2 < this.conds.length; ++i2) {
            Class<?> clazz;
            try {
                clazz = Class.forName(this.conds[i2].getType());
            }
            catch (ClassNotFoundException e2) {
                return null;
            }
            Constructor<?> constructor = null;
            Method method = null;
            try {
                method = clazz.getMethod("getCondition", condClassArray);
                if ((method.getModifiers() & 8) == 0) {
                    method = null;
                }
            }
            catch (NoSuchMethodException e3) {
                // empty catch block
            }
            if (method == null) {
                try {
                    constructor = clazz.getConstructor(condClassArray);
                }
                catch (NoSuchMethodException e4) {
                    conditions[i2] = Condition.FALSE;
                    continue;
                }
            }
            Object[] args = new Object[]{bundle, this.conds[i2]};
            try {
                if (method != null) {
                    conditions[i2] = (Condition)method.invoke(null, args);
                    continue;
                }
                conditions[i2] = (Condition)constructor.newInstance(args);
                continue;
            }
            catch (Throwable t2) {
                conditions[i2] = Condition.FALSE;
            }
        }
        return conditions;
    }

    public PermissionInfo[] getPermissionInfos() {
        if (this.perms == null) {
            return null;
        }
        PermissionInfo[] results = new PermissionInfo[this.perms.length];
        System.arraycopy(this.perms, 0, results, 0, this.perms.length);
        return results;
    }

    public void delete() {
        this.deleted = true;
        condAdmin.deleteConditionalPermissionInfo(this);
    }

    static void setConditionalPermissionAdminImpl(ConditionalPermissionAdminImpl condAdmin) {
        ConditionalPermissionInfoImpl.condAdmin = condAdmin;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

