/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.AliasMapper;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class BundleNativeCode {
    private Attribute nativepaths;
    private Attribute processor;
    private Attribute osname;
    private Attribute language;
    private Attribute osversion;
    private String filterString;
    private AbstractBundle bundle;
    private static AliasMapper aliasMapper = Framework.aliasMapper;

    protected BundleNativeCode(ManifestElement element, AbstractBundle bundle) {
        this.bundle = bundle;
        String[] nativePaths = element.getValueComponents();
        for (int i2 = 0; i2 < nativePaths.length; ++i2) {
            this.addPath(nativePaths[i2]);
        }
        this.setAttribute(element, "osname");
        this.setAttribute(element, "processor");
        this.setAttribute(element, "osversion");
        this.setAttribute(element, "language");
        this.setAttribute(element, "selection-filter");
    }

    private void setAttribute(ManifestElement element, String attribute) {
        String[] attrValues = element.getAttributes(attribute);
        if (attrValues != null) {
            for (int i2 = 0; i2 < attrValues.length; ++i2) {
                this.addAttribute(attribute, attrValues[i2]);
            }
        }
    }

    public String[] getPaths() {
        if (this.nativepaths == null) {
            return null;
        }
        String[] paths = new String[this.nativepaths.size()];
        this.nativepaths.toArray(paths);
        return paths;
    }

    protected void addPath(String nativepath) {
        if (this.nativepaths == null) {
            this.nativepaths = new Attribute();
        }
        this.nativepaths.addElement(nativepath);
    }

    protected synchronized void addAttribute(String key, String value) {
        if (key.equals("processor")) {
            if (this.processor == null) {
                this.processor = new Attribute();
            }
            this.processor.addElement(aliasMapper.aliasProcessor(value));
            return;
        }
        if (key.equals("osname")) {
            if (this.osname == null) {
                this.osname = new Attribute();
            }
            this.osname.addElement(aliasMapper.aliasOSName(value));
            return;
        }
        if (key.equals("osversion")) {
            if (this.osversion == null) {
                this.osversion = new Attribute();
            }
            this.osversion.addElement(new VersionRange(value));
            return;
        }
        if (key.equals("selection-filter")) {
            if (this.filterString == null) {
                this.filterString = value;
            }
            return;
        }
        if (key.equals("language")) {
            if (this.language == null) {
                this.language = new Attribute();
            }
            this.language.addElement(value.toLowerCase());
            return;
        }
    }

    public String toString() {
        int i2;
        int size = this.nativepaths.size();
        StringBuffer sb = new StringBuffer(50 * size);
        for (i2 = 0; i2 < size; ++i2) {
            if (i2 > 0) {
                sb.append(';');
            }
            sb.append(this.nativepaths.elementAt(i2).toString());
        }
        if (this.processor != null) {
            size = this.processor.size();
            for (i2 = 0; i2 < size; ++i2) {
                sb.append(';');
                sb.append("processor");
                sb.append('=');
                sb.append(this.processor.elementAt(i2).toString());
            }
        }
        if (this.osname != null) {
            size = this.osname.size();
            for (i2 = 0; i2 < size; ++i2) {
                sb.append(';');
                sb.append("osname");
                sb.append('=');
                sb.append(this.osname.elementAt(i2).toString());
            }
        }
        if (this.osversion != null) {
            size = this.osversion.size();
            for (i2 = 0; i2 < size; ++i2) {
                sb.append(';');
                sb.append("osversion");
                sb.append('=');
                sb.append(this.osversion.elementAt(i2).toString());
            }
        }
        if (this.language != null) {
            size = this.language.size();
            for (i2 = 0; i2 < size; ++i2) {
                sb.append(';');
                sb.append("language");
                sb.append('=');
                sb.append(this.language.elementAt(i2).toString());
            }
        }
        return sb.toString();
    }

    public int matchProcessorOSNameFilter(String processor, String osname) {
        if (this.processor == null || this.osname == null) {
            return 0;
        }
        String otherProcessor = aliasMapper.aliasProcessor(processor);
        String otherOSName = (String)aliasMapper.aliasOSName(osname);
        if (this.processor.equals(otherProcessor) && this.osname.equals(otherOSName) && this.matchFilter()) {
            return 1;
        }
        return 0;
    }

    public Version matchOSVersion(Version version) {
        if (this.osversion == null) {
            return Version.emptyVersion;
        }
        Version result = null;
        int size = this.osversion.size();
        for (int i2 = 0; i2 < size; ++i2) {
            VersionRange range = (VersionRange)this.osversion.elementAt(i2);
            if (!range.isIncluded(version) || result != null && range.getMinimum().compareTo(result) <= 0) continue;
            result = range.getMinimum();
        }
        return result;
    }

    public int matchLanguage(String language) {
        if (this.language == null) {
            return 1;
        }
        if (this.language.equals(language.toLowerCase())) {
            return 2;
        }
        return 0;
    }

    public boolean matchFilter() {
        FilterImpl filter;
        if (this.filterString == null) {
            return true;
        }
        try {
            filter = new FilterImpl(this.filterString);
        }
        catch (InvalidSyntaxException e2) {
            BundleException be = new BundleException(Msg.BUNDLE_NATIVECODE_INVALID_FILTER, e2);
            this.bundle.framework.publishFrameworkEvent(2, this.bundle, be);
            return false;
        }
        return filter.match(System.getProperties());
    }

    static class Attribute
    extends Vector {
        private static final long serialVersionUID = 3257005440914174512L;

        Attribute() {
            super(10, 10);
        }

        public synchronized boolean equals(Object obj) {
            for (int i2 = 0; i2 < this.elementCount; ++i2) {
                Object data = this.elementData[i2];
                if (data instanceof String) {
                    if (!this.elementData[i2].equals(obj)) continue;
                    return true;
                }
                Enumeration e2 = ((Vector)data).elements();
                while (e2.hasMoreElements()) {
                    if (!((String)e2.nextElement()).equals(obj)) continue;
                    return true;
                }
            }
            return false;
        }

        public synchronized void addElement(Object obj) {
            if (!this.contains(obj)) {
                super.addElement(obj);
            }
        }
    }
}

