/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

import java.util.ArrayList;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;

public class ListenerQueue {
    protected final EventManager manager;
    private final ArrayList queue;
    private boolean readOnly;

    public ListenerQueue(EventManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException();
        }
        this.manager = manager;
        this.queue = new ArrayList();
        this.readOnly = false;
    }

    public synchronized void queueListeners(EventListeners listeners, EventDispatcher dispatcher) {
        EventListeners.ListElement[] list;
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        if (listeners != null && (list = listeners.getListeners()).length > 0) {
            this.queue.add(new EventListeners.ListElement(list, dispatcher));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEventAsynchronous(int eventAction, Object eventObject) {
        EventManager.EventThread eventThread;
        ListenerQueue listenerQueue = this;
        synchronized (listenerQueue) {
            this.readOnly = true;
        }
        EventManager.EventThread eventThread2 = eventThread = this.manager.getEventThread();
        synchronized (eventThread2) {
            int size = this.queue.size();
            for (int i2 = 0; i2 < size; ++i2) {
                EventListeners.ListElement list = (EventListeners.ListElement)this.queue.get(i2);
                eventThread.postEvent((EventListeners.ListElement[])list.primary, (EventDispatcher)list.companion, eventAction, eventObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEventSynchronous(int eventAction, Object eventObject) {
        ListenerQueue listenerQueue = this;
        synchronized (listenerQueue) {
            this.readOnly = true;
        }
        int size = this.queue.size();
        for (int i2 = 0; i2 < size; ++i2) {
            EventListeners.ListElement list = (EventListeners.ListElement)this.queue.get(i2);
            EventManager.dispatchEvent((EventListeners.ListElement[])list.primary, (EventDispatcher)list.companion, eventAction, eventObject);
        }
    }
}

