/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class InitializeCopyCommand
extends AbstractOverrideableCommand {
    protected static final String LABEL = EMFEditPlugin.INSTANCE.getString("_UI_InitializeCopyCommand_label");
    protected static final String DESCRIPTION = EMFEditPlugin.INSTANCE.getString("_UI_InitializeCopyCommand_description");
    protected EObject owner;
    protected EObject copy;
    protected CopyCommand.Helper copyHelper;
    static /* synthetic */ Class class$0;

    public static Command create(EditingDomain domain, Object owner, CopyCommand.Helper copyHelper) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.command.InitializeCopyCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return domain.createCommand(clazz, new CommandParameter(owner, null, copyHelper));
    }

    public InitializeCopyCommand(EditingDomain domain, EObject owner, CopyCommand.Helper copyHelper) {
        super(domain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.copy = copyHelper.getCopy(owner);
        this.copyHelper = copyHelper;
    }

    public EObject getOwner() {
        return this.owner;
    }

    public EObject getCopy() {
        return this.copy;
    }

    public CopyCommand.Helper getCopyHelper() {
        return this.copyHelper;
    }

    protected boolean prepare() {
        return this.owner.eClass().isInstance(this.copy);
    }

    public void doExecute() {
        this.copyAttributes();
        this.copyReferences();
    }

    protected Collection getAttributesToCopy() {
        return this.owner.eClass().getEAllAttributes();
    }

    protected void copyAttributes() {
        Iterator attributes = this.getAttributesToCopy().iterator();
        while (attributes.hasNext()) {
            EAttribute attribute = (EAttribute)attributes.next();
            if (!attribute.isChangeable() || attribute.isDerived() || !attribute.isMany() && !this.owner.eIsSet(attribute)) continue;
            Object value = this.owner.eGet(attribute);
            if (!attribute.isMany()) {
                this.copy.eSet(attribute, value);
                continue;
            }
            List list = (List)this.copy.eGet(attribute);
            if (FeatureMapUtil.isFeatureMap(attribute)) {
                FeatureMap featureMap = (FeatureMap)list;
                Iterator i2 = ((List)value).iterator();
                block1: while (i2.hasNext()) {
                    boolean copiedTargetRequired;
                    FeatureMap.Entry entry = (FeatureMap.Entry)i2.next();
                    EStructuralFeature entryFeature = entry.getEStructuralFeature();
                    if (entryFeature instanceof EAttribute) {
                        featureMap.add(entry);
                        continue;
                    }
                    EReference reference = (EReference)entryFeature;
                    EReference reverseReference = reference.getEOpposite();
                    Object entryValue = entry.getValue();
                    EObject target = this.copyHelper.getCopyTarget((EObject)entryValue, copiedTargetRequired = reverseReference != null || reference.isContainment());
                    if (target == null) continue;
                    if (reverseReference != null) {
                        Iterator j2 = featureMap.iterator();
                        while (j2.hasNext()) {
                            FeatureMap.Entry copyEntry = (FeatureMap.Entry)j2.next();
                            if (copyEntry.getEStructuralFeature() != reference || copyEntry.getValue() != target) continue;
                            featureMap.move(featureMap.size() - 1, copyEntry);
                            continue block1;
                        }
                    }
                    featureMap.add(reference, target);
                }
                continue;
            }
            list.addAll((List)value);
        }
    }

    protected Collection getReferencesToCopy() {
        return this.owner.eClass().getEAllReferences();
    }

    protected void copyReferences() {
        Iterator references = this.getReferencesToCopy().iterator();
        block0: while (references.hasNext()) {
            boolean copiedTargetRequired;
            EReference reference = (EReference)references.next();
            if (!reference.isChangeable() || reference.isDerived()) continue;
            EReference reverseReference = reference.getEOpposite();
            Object value = this.owner.eGet(reference);
            if (value == null) continue;
            boolean bl = copiedTargetRequired = reverseReference != null || reference.isContainment();
            if (reference.isMany()) {
                List valueList = (List)value;
                if (valueList.isEmpty()) continue;
                EList copyList = (EList)this.copy.eGet(reference);
                int index = 0;
                Iterator valueIter = valueList.iterator();
                while (valueIter.hasNext()) {
                    EObject target = this.copyHelper.getCopyTarget((EObject)valueIter.next(), copiedTargetRequired);
                    if (target == null) continue block0;
                    if (reverseReference != null) {
                        int position = copyList.indexOf(target);
                        if (position == -1) {
                            copyList.add(index, target);
                        } else {
                            copyList.move(index, target);
                        }
                    } else {
                        copyList.add(target);
                    }
                    ++index;
                }
                continue;
            }
            EObject target = this.copyHelper.getCopyTarget((EObject)value, copiedTargetRequired);
            if (target == null) continue;
            this.copy.eSet(reference, target);
        }
    }

    public void doUndo() {
    }

    public void doRedo() {
    }

    public Collection doGetResult() {
        return Collections.singleton(this.copy);
    }

    public Collection doGetAffectedObjects() {
        return Collections.singleton(this.copy);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(String.valueOf(super.toString()) + ")");
        result.append(" (domain: " + this.domain + ")");
        result.append(" (owner: " + this.owner + ")");
        result.append(" (copy: " + this.copy + ")");
        result.append(" (copyHelper: " + this.copyHelper + ")");
        return result.toString();
    }
}

