/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLParserPool;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXWrapper;
import org.eclipse.emf.ecore.xmi.impl.SAXXMLHandler;
import org.eclipse.emf.ecore.xmi.impl.XMLHandler;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class XMLLoadImpl
implements XMLLoad {
    protected static final String SAX_LEXICAL_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    protected static final int BUFFER_SIZE = 200;
    protected XMLResource resource;
    protected InputStream is;
    protected XMLHelper helper;
    protected Map options;

    public XMLLoadImpl(XMLHelper helper) {
        this.helper = helper;
    }

    public void load(XMLResource resource, InputStream inputStream, Map options) throws IOException {
        this.resource = resource;
        this.is = inputStream;
        this.options = options;
        XMLParserPool pool = (XMLParserPool)options.get("USE_PARSER_POOL");
        Map parserFeatures = (Map)options.get("PARSER_FEATURES");
        Map parserProperties = (Map)options.get("PARSER_PROPERTIES");
        parserFeatures = parserFeatures == null ? Collections.EMPTY_MAP : parserFeatures;
        parserProperties = parserProperties == null ? Collections.EMPTY_MAP : parserProperties;
        String encoding = this.getEncoding();
        resource.setEncoding(encoding);
        try {
            SAXParser parser;
            if (pool != null) {
                parser = pool.get(parserFeatures, parserProperties, Boolean.TRUE.equals(options.get("USE_LEXICAL_HANDLER")));
            } else {
                Iterator i2;
                parser = this.makeParser();
                if (parserFeatures != null) {
                    i2 = parserFeatures.keySet().iterator();
                    while (i2.hasNext()) {
                        String feature = (String)i2.next();
                        parser.getXMLReader().setFeature(feature, (Boolean)parserFeatures.get(feature));
                    }
                }
                if (parserProperties != null) {
                    i2 = parserProperties.keySet().iterator();
                    while (i2.hasNext()) {
                        String property = (String)i2.next();
                        parser.getXMLReader().setProperty(property, parserProperties.get(property));
                    }
                }
            }
            InputSource inputSource = new InputSource(this.is);
            if (resource.getURI() != null) {
                String resourceURI = resource.getURI().toString();
                inputSource.setPublicId(resourceURI);
                inputSource.setSystemId(resourceURI);
            }
            DefaultHandler defaultHandler = this.makeDefaultHandler();
            if (options != null && Boolean.TRUE.equals(options.get("USE_LEXICAL_HANDLER")) && (parserProperties == null || parserProperties.get(SAX_LEXICAL_PROPERTY) == null)) {
                parser.setProperty(SAX_LEXICAL_PROPERTY, defaultHandler);
            }
            parser.parse(inputSource, defaultHandler);
            if (defaultHandler instanceof SAXWrapper) {
                ((SAXWrapper)defaultHandler).handler = null;
            }
            if (pool != null) {
                pool.release(parser, parserFeatures, parserProperties, Boolean.TRUE.equals(options.get("USE_LEXICAL_HANDLER")));
            }
            this.helper = null;
            if (!resource.getErrors().isEmpty()) {
                XMIException exception;
                Exception error = (Exception)resource.getErrors().get(0);
                if (error instanceof XMIException && (exception = (XMIException)error).getWrappedException() != null) {
                    throw new Resource.IOWrappedException(exception.getWrappedException());
                }
                throw new Resource.IOWrappedException(error);
            }
        }
        catch (SAXException exception) {
            if (exception.getException() != null) {
                throw new Resource.IOWrappedException(exception.getException());
            }
            throw new Resource.IOWrappedException(exception);
        }
        catch (ParserConfigurationException exception) {
            throw new Resource.IOWrappedException(exception);
        }
    }

    protected SAXParser makeParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory f2 = SAXParserFactory.newInstance();
        return f2.newSAXParser();
    }

    protected DefaultHandler makeDefaultHandler() {
        return new SAXWrapper(new SAXXMLHandler(this.resource, this.helper, this.options));
    }

    protected String getEncoding() throws IOException {
        if (!this.is.markSupported()) {
            this.is = new BufferedInputStream(this.is);
        }
        byte[] buffer = this.readBuffer();
        return XMLHandler.getXMLEncoding(buffer);
    }

    protected byte[] readBuffer() throws IOException {
        int bytesRead;
        if (this.is.available() == 0) {
            return new byte[0];
        }
        byte[] buffer = new byte[200];
        this.is.mark(200);
        int totalBytesRead = bytesRead = this.is.read(buffer, 0, 200);
        while (bytesRead != -1 && totalBytesRead < 200) {
            bytesRead = this.is.read(buffer, totalBytesRead, 200 - totalBytesRead);
            if (bytesRead == -1) continue;
            totalBytesRead += bytesRead;
        }
        if (totalBytesRead < 200) {
            byte[] smallerBuffer = new byte[totalBytesRead];
            System.arraycopy(buffer, 0, smallerBuffer, 0, totalBytesRead);
            smallerBuffer = buffer;
        }
        this.is.reset();
        return buffer;
    }

    public void load(XMLResource resource, Node node, Map options) throws IOException {
        this.resource = resource;
        this.options = options;
        DefaultHandler handler = this.makeDefaultHandler();
        LexicalHandler lexicalHandler = null;
        if (options != null && Boolean.TRUE.equals(options.get("USE_LEXICAL_HANDLER"))) {
            lexicalHandler = (LexicalHandler)((Object)handler);
        }
        AttributesProxy attributesProxy = new AttributesProxy();
        try {
            short type = node.getNodeType();
            if (type == 1) {
                handler.startDocument();
                if (options != null && Boolean.TRUE.equals(options.get("DOM_USE_NAMESPACES_IN_SCOPE"))) {
                    this.traverseElement((Element)node, attributesProxy, handler, lexicalHandler);
                } else {
                    this.traverse(node, attributesProxy, handler, lexicalHandler);
                }
                handler.endDocument();
            } else {
                this.traverse(node, attributesProxy, handler, lexicalHandler);
            }
        }
        catch (SAXException sAXException) {}
        if (!resource.getErrors().isEmpty()) {
            XMIException exception;
            Exception error = (Exception)resource.getErrors().get(0);
            if (error instanceof XMIException && (exception = (XMIException)error).getWrappedException() != null) {
                throw new Resource.IOWrappedException(exception.getWrappedException());
            }
            throw new Resource.IOWrappedException(error);
        }
        if (handler instanceof SAXWrapper) {
            ((SAXWrapper)handler).handler = null;
        }
        attributesProxy = null;
        handler = null;
        lexicalHandler = null;
        this.helper = null;
    }

    protected void traverseElement(Element element, AttributesProxy attributesProxy, DefaultHandler handler, LexicalHandler lexicalHandler) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        if (element.hasAttributes()) {
            NamedNodeMap attributes = element.getAttributes();
            int i2 = 0;
            while (i2 < attributes.getLength()) {
                Node attr = attributes.item(i2);
                String namespaceURI = attr.getNamespaceURI();
                if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                    if (attrs.getIndex(attr.getNodeName()) < 0) {
                        attrs.addAttribute("", "", attr.getNodeName(), "CDATA", attr.getNodeValue());
                    }
                } else {
                    attrs.addAttribute(namespaceURI, attr.getLocalName(), attr.getNodeName(), "CDATA", attr.getNodeValue());
                }
                ++i2;
            }
        }
        Node parent = element.getParentNode();
        while (parent.getNodeType() != 9) {
            if (parent.hasAttributes()) {
                NamedNodeMap attributes = parent.getAttributes();
                int i3 = 0;
                while (i3 < attributes.getLength()) {
                    Node attr = attributes.item(i3);
                    if ("http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) && attrs.getIndex(attr.getNodeName()) < 0) {
                        attrs.addAttribute("", "", attr.getNodeName(), "CDATA", attr.getNodeValue());
                    }
                    ++i3;
                }
            }
            parent = parent.getParentNode();
        }
        String namespaceURI = element.getNamespaceURI();
        String localName = element.getLocalName();
        String qname = element.getNodeName();
        handler.startElement(namespaceURI, localName, qname, attrs);
        Node child = element.getFirstChild();
        while (child != null) {
            this.traverse(child, attributesProxy, handler, lexicalHandler);
            child = child.getNextSibling();
        }
        handler.endElement(namespaceURI, localName, qname);
    }

    protected void traverse(Node node, AttributesProxy attributesProxy, DefaultHandler handler, LexicalHandler lexicalHandler) throws SAXException {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                DocumentType doctype;
                Document document = (Document)node;
                handler.startDocument();
                Element root = document.getDocumentElement();
                if (lexicalHandler != null && (doctype = document.getDoctype()) != null) {
                    String publicId = doctype.getPublicId();
                    String systemId = doctype.getSystemId();
                    lexicalHandler.startDTD(root.getNodeName(), publicId, systemId);
                }
                this.traverse(root, attributesProxy, handler, lexicalHandler);
                handler.endDocument();
                break;
            }
            case 1: {
                attributesProxy.setAttributes(node.getAttributes());
                String namespaceURI = node.getNamespaceURI();
                String localName = node.getLocalName();
                String qname = node.getNodeName();
                handler.startElement(namespaceURI, localName, qname, attributesProxy);
                Node child = node.getFirstChild();
                while (child != null) {
                    this.traverse(child, attributesProxy, handler, lexicalHandler);
                    child = child.getNextSibling();
                }
                handler.endElement(namespaceURI, localName, qname);
                break;
            }
            case 4: {
                if (lexicalHandler != null) {
                    lexicalHandler.startCDATA();
                }
                char[] chars = ((CDATASection)node).getData().toCharArray();
                handler.characters(chars, 0, chars.length);
                if (lexicalHandler == null) break;
                lexicalHandler.endCDATA();
                break;
            }
            case 3: {
                char[] chars = node.getNodeValue().toCharArray();
                handler.characters(chars, 0, chars.length);
                break;
            }
            case 8: {
                if (lexicalHandler == null) break;
                char[] chars = ((Comment)node).getData().toCharArray();
                lexicalHandler.comment(chars, 0, chars.length);
            }
        }
    }

    protected static final class AttributesProxy
    implements Attributes {
        protected NamedNodeMap attributes;

        protected AttributesProxy() {
        }

        public void setAttributes(NamedNodeMap attributes) {
            this.attributes = attributes;
        }

        public int getLength() {
            return this.attributes.getLength();
        }

        public String getQName(int index) {
            Node node = this.attributes.item(index);
            return node != null ? node.getNodeName() : null;
        }

        public String getURI(int index) {
            Node node = this.attributes.item(index);
            if (node != null) {
                String namespaceURI = node.getNamespaceURI();
                if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                    return "";
                }
                return namespaceURI;
            }
            return null;
        }

        public String getLocalName(int index) {
            Node node = this.attributes.item(index);
            if (node != null) {
                String prefix = node.getPrefix();
                if ("xmlns".equals(prefix)) {
                    return "";
                }
                return node.getLocalName();
            }
            return null;
        }

        public String getType(int i2) {
            return "CDATA";
        }

        public String getType(String name) {
            return "CDATA";
        }

        public String getType(String uri, String localName) {
            return "CDATA";
        }

        public String getValue(int i2) {
            Node node = this.attributes.item(i2);
            return node != null ? node.getNodeValue() : null;
        }

        public String getValue(String name) {
            Node node = this.attributes.getNamedItem(name);
            return node != null ? node.getNodeValue() : null;
        }

        public String getValue(String uri, String localName) {
            Node node = this.attributes.getNamedItemNS(uri, localName);
            return node != null ? node.getNodeValue() : null;
        }

        public int getIndex(String qName) {
            Node node = this.attributes.getNamedItem(qName);
            if (node != null) {
                int i2 = 0;
                while (i2 < this.attributes.getLength()) {
                    Node item = this.attributes.item(i2);
                    if (item == node) {
                        return i2;
                    }
                    ++i2;
                }
            }
            return -1;
        }

        public int getIndex(String uri, String localPart) {
            Node node = this.attributes.getNamedItemNS(uri, localPart);
            if (node != null) {
                int i2 = 0;
                while (i2 < this.attributes.getLength()) {
                    Node item = this.attributes.item(i2);
                    if (item == node) {
                        return i2;
                    }
                    ++i2;
                }
            }
            return -1;
        }
    }
}

