/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class SAXXMLHandler
extends XMLHandler {
    protected Locator locator;
    protected Attributes attribs;

    public SAXXMLHandler(XMLResource xmiResource, XMLHelper helper, Map options) {
        super(xmiResource, helper, options);
    }

    protected Object setAttributes(Object attributes) {
        Attributes oldAttribs = this.attribs;
        this.attribs = (Attributes)attributes;
        return oldAttribs;
    }

    public void setLocator(Object locator) {
        this.locator = (Locator)locator;
    }

    protected int getLineNumber() {
        if (this.locator != null) {
            return this.locator.getLineNumber();
        }
        return super.getLineNumber();
    }

    protected int getColumnNumber() {
        if (this.locator != null) {
            return this.locator.getColumnNumber();
        }
        return super.getColumnNumber();
    }

    protected boolean isNull() {
        return this.attribs.getValue("xsi:nil") != null;
    }

    protected void handleNamespaceAttribs() {
        int i2 = 0;
        int size = this.attribs.getLength();
        while (i2 < size) {
            String attrib = this.attribs.getQName(i2);
            if (attrib.startsWith("xmlns")) {
                this.handleXMLNSAttribute(attrib, this.attribs.getValue(i2));
            } else if ("xsi:schemaLocation".equals(attrib)) {
                this.handleXSISchemaLocation(this.attribs.getValue(i2));
            } else if ("xsi:noNamespaceSchemaLocation".equals(attrib)) {
                this.handleXSINoNamespaceSchemaLocation(this.attribs.getValue(i2));
            }
            ++i2;
        }
    }

    protected String getXSIType() {
        return this.attribs.getValue("xsi:type");
    }

    protected void handleObjectAttribs(EObject obj) {
        if (this.attribs != null) {
            InternalEObject internalEObject = (InternalEObject)obj;
            int i2 = 0;
            int size = this.attribs.getLength();
            while (i2 < size) {
                String name = this.attribs.getQName(i2);
                if (name.equals(this.idAttribute)) {
                    this.xmlResource.setID(internalEObject, this.attribs.getValue(i2));
                } else if (name.equals(this.hrefAttribute) && (!this.recordUnknownFeature || this.types.peek() != "unknownFeature")) {
                    this.handleProxy(internalEObject, this.attribs.getValue(i2));
                } else if (!name.startsWith("xmlns") && !this.notFeatures.contains(name)) {
                    this.setAttribValue(obj, name, this.attribs.getValue(i2));
                }
                ++i2;
            }
        }
    }

    protected void processObject(EObject object) {
        EStructuralFeature valueFeature;
        if (object != null && (valueFeature = this.getContentFeature(object)) != null) {
            this.text = new StringBuffer();
            this.objects.push(object);
            this.types.push(valueFeature);
            return;
        }
        super.processObject(object);
    }

    protected EStructuralFeature getContentFeature(EObject object) {
        EAttribute eAttribute;
        XMLResource.XMLInfo info;
        EList eAttributes;
        if (this.xmlMap != null && (eAttributes = object.eClass().getEAllAttributes()).size() >= 1 && (info = this.xmlMap.getInfo(eAttribute = (EAttribute)eAttributes.get(0))) != null && info.getXMLRepresentation() == 2) {
            return eAttribute;
        }
        return null;
    }
}

