/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class EContentsEList
extends AbstractSequentialList
implements EList,
InternalEList {
    protected final EObject eObject;
    protected final EStructuralFeature[] eStructuralFeatures;

    public EContentsEList(EObject eObject) {
        this.eObject = eObject;
        this.eStructuralFeatures = ((EClassImpl.FeatureSubsetSupplier)((Object)eObject.eClass().getEAllStructuralFeatures())).containments();
    }

    public EContentsEList(EObject eObject, List eStructuralFeatures) {
        this.eObject = eObject;
        this.eStructuralFeatures = new EStructuralFeature[eStructuralFeatures.size()];
        eStructuralFeatures.toArray(this.eStructuralFeatures);
    }

    public EContentsEList(EObject eObject, EStructuralFeature[] eStructuralFeatures) {
        this.eObject = eObject;
        this.eStructuralFeatures = eStructuralFeatures;
    }

    protected ListIterator newListIterator() {
        return this.resolve() ? new ResolvingFeatureIteratorImpl(this.eObject, this.eStructuralFeatures) : new FeatureIteratorImpl(this.eObject, this.eStructuralFeatures);
    }

    protected Iterator newIterator() {
        return this.newListIterator();
    }

    protected boolean useIsSet() {
        return true;
    }

    protected boolean resolve() {
        return true;
    }

    protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
        return true;
    }

    protected boolean isIncludedEntry(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature instanceof EReference && ((EReference)eStructuralFeature).isContainment();
    }

    public ListIterator listIterator(int index) {
        if (this.eStructuralFeatures == null) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index=" + index + ", size=0");
            }
            return FeatureIteratorImpl.EMPTY_ITERATOR;
        }
        ListIterator result = this.newListIterator();
        for (int i2 = 0; i2 < index; ++i2) {
            result.next();
        }
        return result;
    }

    public Iterator iterator() {
        if (this.eStructuralFeatures == null) {
            return FeatureIteratorImpl.EMPTY_ITERATOR;
        }
        Iterator result = this.newIterator();
        return result;
    }

    public int size() {
        int result = 0;
        if (this.eStructuralFeatures != null) {
            for (int i2 = 0; i2 < this.eStructuralFeatures.length; ++i2) {
                EStructuralFeature feature = this.eStructuralFeatures[i2];
                if (!this.isIncluded(feature) || this.useIsSet() && !this.eObject.eIsSet(feature)) continue;
                Object value = this.eObject.eGet(feature, false);
                if (FeatureMapUtil.isFeatureMap(feature)) {
                    FeatureMap featureMap = (FeatureMap)value;
                    int size = featureMap.size();
                    for (int j2 = 0; j2 < size; ++j2) {
                        if (!this.isIncludedEntry(featureMap.getEStructuralFeature(j2)) || featureMap.getValue(j2) == null) continue;
                        ++result;
                    }
                    continue;
                }
                if (feature.isMany()) {
                    result += ((Collection)value).size();
                    continue;
                }
                if (value == null) continue;
                ++result;
            }
        }
        return result;
    }

    public boolean isEmpty() {
        if (this.eStructuralFeatures != null) {
            for (int i2 = 0; i2 < this.eStructuralFeatures.length; ++i2) {
                EStructuralFeature feature = this.eStructuralFeatures[i2];
                if (!this.isIncluded(feature) || this.useIsSet() && !this.eObject.eIsSet(feature)) continue;
                Object value = this.eObject.eGet(feature, false);
                if (FeatureMapUtil.isFeatureMap(feature)) {
                    FeatureMap featureMap = (FeatureMap)value;
                    int size = featureMap.size();
                    for (int j2 = 0; j2 < size; ++j2) {
                        if (!this.isIncludedEntry(featureMap.getEStructuralFeature(j2)) || featureMap.getValue(j2) == null) continue;
                        return false;
                    }
                    continue;
                }
                if (!(feature.isMany() ? !((Collection)value).isEmpty() : value != null)) continue;
                return false;
            }
        }
        return true;
    }

    public void move(int newPosition, Object o2) {
        throw new UnsupportedOperationException();
    }

    public Object move(int newPosition, int oldPosition) {
        throw new UnsupportedOperationException();
    }

    public Object basicGet(int index) {
        return this.basicList().get(index);
    }

    public List basicList() {
        return new EContentsEList(this.eObject, this.eStructuralFeatures){

            protected boolean resolve() {
                return false;
            }
        };
    }

    public Iterator basicIterator() {
        if (this.eStructuralFeatures == null) {
            return FeatureIteratorImpl.EMPTY_ITERATOR;
        }
        return new FeatureIteratorImpl(this.eObject, this.eStructuralFeatures);
    }

    public ListIterator basicListIterator() {
        if (this.eStructuralFeatures == null) {
            return FeatureIteratorImpl.EMPTY_ITERATOR;
        }
        return new FeatureIteratorImpl(this.eObject, this.eStructuralFeatures);
    }

    public ListIterator basicListIterator(int index) {
        if (this.eStructuralFeatures == null) {
            if (index < 0 || index > 1) {
                throw new IndexOutOfBoundsException("index=" + index + ", size=0");
            }
            return FeatureIteratorImpl.EMPTY_ITERATOR;
        }
        FeatureIteratorImpl result = new FeatureIteratorImpl(this.eObject, this.eStructuralFeatures);
        for (int i2 = 0; i2 < index; ++i2) {
            result.next();
        }
        return result;
    }

    public NotificationChain basicRemove(Object object, NotificationChain notifications) {
        throw new UnsupportedOperationException();
    }

    public NotificationChain basicAdd(Object object, NotificationChain notifications) {
        throw new UnsupportedOperationException();
    }

    public void addUnique(Object object) {
        throw new UnsupportedOperationException();
    }

    public void addUnique(int index, Object object) {
        throw new UnsupportedOperationException();
    }

    public Object setUnique(int index, Object object) {
        throw new UnsupportedOperationException();
    }

    public static class ResolvingFeatureIteratorImpl
    extends FeatureIteratorImpl {
        public ResolvingFeatureIteratorImpl(EObject eObject, List eStructuralFeatures) {
            super(eObject, eStructuralFeatures);
        }

        public ResolvingFeatureIteratorImpl(EObject eObject, EStructuralFeature[] eStructuralFeatures) {
            super(eObject, eStructuralFeatures);
        }

        protected boolean resolve() {
            return true;
        }
    }

    public static class FeatureIteratorImpl
    implements FeatureListIterator {
        protected final EObject eObject;
        protected final EStructuralFeature[] eStructuralFeatures;
        protected int featureCursor;
        protected int cursor;
        protected int prepared;
        protected Object preparedResult;
        protected EStructuralFeature preparedFeature;
        protected EStructuralFeature feature;
        protected boolean isHandlingFeatureMap;
        protected ListIterator values;
        public static final ListIterator EMPTY_ITERATOR = new FeatureIteratorImpl(null, (EStructuralFeature[])null){

            public boolean hasNext() {
                return false;
            }

            public boolean hasPrevious() {
                return false;
            }
        };

        public FeatureIteratorImpl(EObject eObject, List eStructuralFeatures) {
            this.eObject = eObject;
            this.eStructuralFeatures = new EStructuralFeature[eStructuralFeatures.size()];
            eStructuralFeatures.toArray(this.eStructuralFeatures);
        }

        public FeatureIteratorImpl(EObject eObject, EStructuralFeature[] eStructuralFeatures) {
            this.eObject = eObject;
            this.eStructuralFeatures = eStructuralFeatures;
        }

        protected boolean resolve() {
            return false;
        }

        protected boolean useIsSet() {
            return true;
        }

        protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
            return true;
        }

        protected boolean isIncludedEntry(EStructuralFeature eStructuralFeature) {
            return eStructuralFeature instanceof EReference && ((EReference)eStructuralFeature).isContainment();
        }

        public EStructuralFeature feature() {
            return this.feature;
        }

        public boolean hasNext() {
            switch (this.prepared) {
                case 2: 
                case 3: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case -3: {
                    this.values.next();
                }
            }
            if (this.values == null || !this.scanNext(this.values)) {
                while (this.featureCursor < this.eStructuralFeatures.length) {
                    EStructuralFeature feature;
                    if (!this.isIncluded(feature = this.eStructuralFeatures[this.featureCursor++]) || this.useIsSet() && !this.eObject.eIsSet(feature)) continue;
                    Object value = this.eObject.eGet(feature, this.resolve());
                    this.isHandlingFeatureMap = FeatureMapUtil.isFeatureMap(feature);
                    if (this.isHandlingFeatureMap || feature.isMany()) {
                        ListIterator listIterator = this.values = this.resolve() ? ((List)value).listIterator() : ((InternalEList)value).basicListIterator();
                        if (!this.scanNext(this.values)) continue;
                        this.preparedResult = this.values.next();
                        if (this.isHandlingFeatureMap) {
                            this.preparedResult = ((FeatureMap.Entry)this.preparedResult).getValue();
                        }
                        this.preparedFeature = feature;
                        this.prepared = 3;
                        return true;
                    }
                    if (value == null) continue;
                    this.values = null;
                    this.preparedResult = value;
                    this.preparedFeature = feature;
                    this.prepared = 2;
                    return true;
                }
                this.values = null;
                this.isHandlingFeatureMap = false;
                this.prepared = 1;
                return false;
            }
            this.preparedResult = this.values.next();
            if (this.isHandlingFeatureMap) {
                this.preparedResult = ((FeatureMap.Entry)this.preparedResult).getValue();
            }
            this.prepared = 3;
            return true;
        }

        protected boolean scanNext(ListIterator values) {
            if (this.isHandlingFeatureMap) {
                while (values.hasNext()) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)values.next();
                    EStructuralFeature entryFeature = entry.getEStructuralFeature();
                    if (!this.isIncludedEntry(entryFeature) || entry.getValue() == null) continue;
                    values.previous();
                    return true;
                }
                return false;
            }
            return values.hasNext();
        }

        public Object next() {
            if (this.hasNext()) {
                ++this.cursor;
                this.prepared = 0;
                this.feature = this.preparedFeature;
                return this.preparedResult;
            }
            throw new NoSuchElementException();
        }

        public int nextIndex() {
            return this.cursor;
        }

        public boolean hasPrevious() {
            switch (this.prepared) {
                case -3: 
                case -2: {
                    return true;
                }
                case -1: {
                    return false;
                }
                case 3: {
                    this.values.previous();
                }
            }
            if (this.values == null || !this.scanPrevious(this.values)) {
                while (this.featureCursor > 0) {
                    EStructuralFeature feature;
                    if (!this.isIncluded(feature = this.eStructuralFeatures[--this.featureCursor]) || this.useIsSet() && !this.eObject.eIsSet(feature)) continue;
                    Object value = this.eObject.eGet(feature, this.resolve());
                    this.isHandlingFeatureMap = FeatureMapUtil.isFeatureMap(feature);
                    if (this.isHandlingFeatureMap || feature.isMany()) {
                        List list = (List)value;
                        ListIterator listIterator = this.values = this.resolve() ? list.listIterator(list.size()) : ((InternalEList)list).basicListIterator(list.size());
                        if (!this.scanPrevious(this.values)) continue;
                        this.preparedResult = this.values.previous();
                        if (this.isHandlingFeatureMap) {
                            this.preparedResult = ((FeatureMap.Entry)this.preparedResult).getValue();
                        }
                        this.preparedFeature = feature;
                        this.prepared = -3;
                        return true;
                    }
                    if (value == null) continue;
                    this.values = null;
                    this.preparedResult = value;
                    this.preparedFeature = feature;
                    this.prepared = -2;
                    return true;
                }
                this.values = null;
                this.prepared = -1;
                return false;
            }
            this.preparedResult = this.values.previous();
            if (this.isHandlingFeatureMap) {
                this.preparedResult = ((FeatureMap.Entry)this.preparedResult).getValue();
            }
            this.prepared = -3;
            return true;
        }

        protected boolean scanPrevious(ListIterator values) {
            if (this.isHandlingFeatureMap) {
                while (values.hasPrevious()) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)values.previous();
                    EStructuralFeature entryFeature = entry.getEStructuralFeature();
                    if (!this.isIncludedEntry(entryFeature) || entry.getValue() == null) continue;
                    values.next();
                    return true;
                }
                return false;
            }
            return values.hasPrevious();
        }

        public Object previous() {
            if (this.hasPrevious()) {
                --this.cursor;
                this.prepared = 0;
                this.feature = this.preparedFeature;
                return this.preparedResult;
            }
            throw new NoSuchElementException();
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public void add(Object o2) {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object o2) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface FeatureListIterator
    extends FeatureIterator,
    ListIterator {
    }

    public static interface FeatureIterator
    extends Iterator {
        public EStructuralFeature feature();
    }
}

