/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.plugin;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;

public abstract class RegistryReader {
    protected static final String TAG_DESCRIPTION = "description";
    protected IExtensionRegistry pluginRegistry;
    String pluginID;
    String extensionPointID;

    public RegistryReader(IExtensionRegistry pluginRegistry, String pluginID, String extensionPointID) {
        this.pluginRegistry = pluginRegistry;
        this.pluginID = pluginID;
        this.extensionPointID = extensionPointID;
    }

    protected abstract boolean readElement(IConfigurationElement var1);

    public void readRegistry() {
        IExtensionPoint point = this.pluginRegistry.getExtensionPoint(this.pluginID, this.extensionPointID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            for (int i2 = 0; i2 < elements.length; ++i2) {
                this.internalReadElement(elements[i2]);
            }
        }
    }

    private void internalReadElement(IConfigurationElement element) {
        boolean recognized = this.readElement(element);
        if (recognized) {
            IConfigurationElement[] children = element.getChildren();
            for (int i2 = 0; i2 < children.length; ++i2) {
                this.internalReadElement(children[i2]);
            }
        } else {
            this.logError(element, "Error processing extension: " + element);
        }
    }

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        System.err.println("Plugin " + extension.getNamespace() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        System.err.println(text);
    }

    protected void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.logError(element, "The required attribute '" + attributeName + "' not defined");
    }

    static class EPackageDescriptor
    extends PluginClassDescriptor
    implements EPackage.Descriptor {
        public EPackageDescriptor(IConfigurationElement element, String attributeName) {
            super(element, attributeName);
        }

        public EPackage getEPackage() {
            try {
                Class javaClass = Platform.getBundle(this.element.getDeclaringExtension().getNamespace()).loadClass(this.element.getAttribute(this.attributeName));
                Field field = javaClass.getField("eINSTANCE");
                Object result = field.get(null);
                return (EPackage)result;
            }
            catch (ClassNotFoundException e2) {
                throw new WrappedException(e2);
            }
            catch (IllegalAccessException e3) {
                throw new WrappedException(e3);
            }
            catch (NoSuchFieldException e4) {
                throw new WrappedException(e4);
            }
        }
    }

    static class ResourceFactoryDescriptor
    extends PluginClassDescriptor
    implements Resource.Factory.Descriptor {
        protected Resource.Factory factoryInstance;

        public ResourceFactoryDescriptor(IConfigurationElement e2, String attrName) {
            super(e2, attrName);
        }

        public Resource.Factory createFactory() {
            if (this.factoryInstance == null) {
                this.factoryInstance = (Resource.Factory)this.createInstance();
            }
            return this.factoryInstance;
        }
    }

    public static class PluginClassDescriptor {
        protected IConfigurationElement element;
        protected String attributeName;

        public PluginClassDescriptor(IConfigurationElement element, String attributeName) {
            this.element = element;
            this.attributeName = attributeName;
        }

        public Object createInstance() {
            try {
                return this.element.createExecutableExtension(this.attributeName);
            }
            catch (CoreException e2) {
                throw new WrappedException(e2);
            }
        }
    }
}

