/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class ECollections {
    public static final EList EMPTY_ELIST = new EmptyUnmodifiableEList();

    private ECollections() {
    }

    public static void reverse(EList list) {
        int last = list.size() - 1;
        int i2 = 0;
        while (i2 < last) {
            list.move(i2, last);
            ++i2;
        }
    }

    public static int indexOf(List list, Object o2, int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int size = list.size();
        int i2 = fromIndex;
        while (i2 < size) {
            Object element = list.get(i2);
            if (o2 == null ? element == null : o2 == element || o2.equals(element)) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public static void sort(EList list) {
        Object[] listAsArray = list.toArray();
        Arrays.sort(listAsArray);
        int i2 = 0;
        while (i2 < listAsArray.length) {
            int oldIndex = ECollections.indexOf(list, listAsArray[i2], i2);
            if (i2 != oldIndex) {
                list.move(i2, oldIndex);
            }
            ++i2;
        }
    }

    public static void sort(EList list, Comparator comparator) {
        Object[] listAsArray = list.toArray();
        Arrays.sort(listAsArray, comparator);
        int i2 = 0;
        while (i2 < listAsArray.length) {
            int oldIndex = ECollections.indexOf(list, listAsArray[i2], i2);
            if (i2 != oldIndex) {
                list.move(i2, oldIndex);
            }
            ++i2;
        }
    }

    public static void setEList(EList eList, List prototypeList) {
        int index = 0;
        Iterator objects = prototypeList.iterator();
        while (objects.hasNext()) {
            Object prototypeObject = objects.next();
            if (eList.size() <= index) {
                eList.add(prototypeObject);
            } else {
                boolean done;
                do {
                    done = true;
                    Object targetObject = eList.get(index);
                    if (!(targetObject == null ? prototypeObject != null : !targetObject.equals(prototypeObject))) continue;
                    int position = ECollections.indexOf(eList, prototypeObject, index);
                    if (position != -1) {
                        int targetIndex = ECollections.indexOf(prototypeList, targetObject, index);
                        if (targetIndex == -1) {
                            eList.remove(index);
                            done = false;
                            continue;
                        }
                        if (targetIndex > position) {
                            if (eList.size() <= targetIndex) {
                                targetIndex = eList.size() - 1;
                            }
                            eList.move(targetIndex, index);
                            done = false;
                            continue;
                        }
                        eList.move(index, position);
                        continue;
                    }
                    eList.add(index, prototypeObject);
                } while (!done);
            }
            ++index;
        }
        int i2 = eList.size();
        while (i2 > index) {
            eList.remove(--i2);
        }
    }

    public static EList unmodifiableEList(EList list) {
        return new UnmodifiableEList(list);
    }

    private static class UnmodifiableEList
    implements EList {
        protected EList list;

        public UnmodifiableEList(EList list) {
            this.list = list;
        }

        public int size() {
            return this.list.size();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public boolean contains(Object o2) {
            return this.list.contains(o2);
        }

        public Object[] toArray() {
            return this.list.toArray();
        }

        public Object[] toArray(Object[] a2) {
            return this.list.toArray(a2);
        }

        public String toString() {
            return this.list.toString();
        }

        public Iterator iterator() {
            return new Iterator(this){
                Iterator i;
                final /* synthetic */ UnmodifiableEList this$1;
                {
                    this.this$1 = unmodifiableEList;
                    this.i = unmodifiableEList.list.iterator();
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    return this.i.next();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean add(Object o2) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o2) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection coll) {
            return this.list.containsAll(coll);
        }

        public boolean addAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o2) {
            return this.list.equals(o2);
        }

        public int hashCode() {
            return this.list.hashCode();
        }

        public Object get(int index) {
            return this.list.get(index);
        }

        public Object set(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public void add(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object o2) {
            return this.list.indexOf(o2);
        }

        public int lastIndexOf(Object o2) {
            return this.list.lastIndexOf(o2);
        }

        public boolean addAll(int index, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int index) {
            return new ListIterator(this, index){
                ListIterator i;
                final /* synthetic */ UnmodifiableEList this$1;
                {
                    this.this$1 = unmodifiableEList;
                    this.i = unmodifiableEList.list.listIterator(n2);
                }

                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    return this.i.next();
                }

                public boolean hasPrevious() {
                    return this.i.hasPrevious();
                }

                public Object previous() {
                    return this.i.previous();
                }

                public int nextIndex() {
                    return this.i.nextIndex();
                }

                public int previousIndex() {
                    return this.i.previousIndex();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public void set(Object o2) {
                    throw new UnsupportedOperationException();
                }

                public void add(Object o2) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public List subList(int fromIndex, int toIndex) {
            return new UnmodifiableEList(new BasicEList(this.list.subList(fromIndex, toIndex)));
        }

        public void move(int newPosition, Object o2) {
            throw new UnsupportedOperationException();
        }

        public Object move(int newPosition, int oldPosition) {
            throw new UnsupportedOperationException();
        }
    }

    private static class EmptyUnmodifiableEList
    implements EList {
        ListIterator listIterator = new ListIterator(this){
            final /* synthetic */ EmptyUnmodifiableEList this$1;
            {
                this.this$1 = emptyUnmodifiableEList;
            }

            public boolean hasNext() {
                return false;
            }

            public Object next() {
                throw new NoSuchElementException();
            }

            public boolean hasPrevious() {
                return false;
            }

            public Object previous() {
                throw new NoSuchElementException();
            }

            public int nextIndex() {
                return 0;
            }

            public int previousIndex() {
                return -1;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object o2) {
                throw new UnsupportedOperationException();
            }

            public void add(Object o2) {
                throw new UnsupportedOperationException();
            }
        };

        public int size() {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean equals(Object o2) {
            return Collections.EMPTY_LIST.equals(o2);
        }

        public int hashCode() {
            return Collections.EMPTY_LIST.hashCode();
        }

        public Object get(int index) {
            return Collections.EMPTY_LIST.get(index);
        }

        public boolean contains(Object o2) {
            return false;
        }

        public int indexOf(Object o2) {
            return -1;
        }

        public int lastIndexOf(Object o2) {
            return -1;
        }

        public Iterator iterator() {
            return this.listIterator;
        }

        public ListIterator listIterator() {
            return this.listIterator;
        }

        public ListIterator listIterator(int index) {
            return this.listIterator;
        }

        public List subList(int fromIndex, int toIndex) {
            return Collections.EMPTY_LIST.subList(fromIndex, toIndex);
        }

        public Object[] toArray() {
            return Collections.EMPTY_LIST.toArray();
        }

        public Object[] toArray(Object[] a2) {
            return Collections.EMPTY_LIST.toArray(a2);
        }

        public String toString() {
            return Collections.EMPTY_LIST.toString();
        }

        public boolean add(Object o2) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o2) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection coll) {
            return false;
        }

        public boolean addAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Object set(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public void add(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void move(int newPosition, Object o2) {
            throw new UnsupportedOperationException();
        }

        public Object move(int newPosition, int oldPosition) {
            throw new UnsupportedOperationException();
        }
    }
}

