/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;

public abstract class DelegatingEList
extends AbstractList
implements EList,
Cloneable,
Serializable {
    public DelegatingEList() {
    }

    public DelegatingEList(Collection collection) {
        this.addAll(collection);
    }

    protected boolean useEquals() {
        return true;
    }

    protected boolean equalObjects(Object firstObject, Object secondObject) {
        return this.useEquals() && firstObject != null ? firstObject.equals(secondObject) : firstObject == secondObject;
    }

    protected boolean canContainNull() {
        return true;
    }

    protected boolean isUnique() {
        return false;
    }

    protected Object validate(int index, Object object) {
        if (!this.canContainNull() && object == null) {
            throw new IllegalArgumentException("The 'no null' constraint is violated");
        }
        return object;
    }

    protected Object resolve(int index, Object object) {
        return object;
    }

    protected void didSet(int index, Object newObject, Object oldObject) {
    }

    protected void didAdd(int index, Object newObject) {
    }

    protected void didRemove(int index, Object oldObject) {
    }

    protected void didClear(int size, Object[] oldObjects) {
        if (oldObjects != null) {
            int i2 = 0;
            while (i2 < size) {
                this.didRemove(i2, oldObjects[i2]);
                ++i2;
            }
        }
    }

    protected void didMove(int index, Object movedObject, int oldIndex) {
    }

    protected void didChange() {
    }

    protected abstract List delegateList();

    public int size() {
        return this.delegateSize();
    }

    protected int delegateSize() {
        return this.delegateList().size();
    }

    public boolean isEmpty() {
        return this.delegateIsEmpty();
    }

    protected boolean delegateIsEmpty() {
        return this.delegateList().isEmpty();
    }

    public boolean contains(Object object) {
        return this.delegateContains(object);
    }

    protected boolean delegateContains(Object object) {
        return this.delegateList().contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.delegateContainsAll(collection);
    }

    protected boolean delegateContainsAll(Collection collection) {
        return this.delegateList().containsAll(collection);
    }

    public int indexOf(Object object) {
        return this.delegateIndexOf(object);
    }

    protected int delegateIndexOf(Object object) {
        return this.delegateList().indexOf(object);
    }

    public int lastIndexOf(Object object) {
        return this.delegateLastIndexOf(object);
    }

    protected int delegateLastIndexOf(Object object) {
        return this.delegateList().lastIndexOf(object);
    }

    public Object[] toArray() {
        return this.delegateToArray();
    }

    protected Object[] delegateToArray() {
        return this.delegateList().toArray();
    }

    public Object[] toArray(Object[] array) {
        return this.delegateToArray(array);
    }

    protected Object[] delegateToArray(Object[] array) {
        return this.delegateList().toArray(array);
    }

    public Object get(int index) {
        return this.resolve(index, this.delegateGet(index));
    }

    protected Object delegateGet(int index) {
        return this.delegateList().get(index);
    }

    protected Object basicGet(int index) {
        return this.delegateGet(index);
    }

    public Object set(int index, Object object) {
        int currentIndex;
        if (this.isUnique() && (currentIndex = this.indexOf(object)) >= 0 && currentIndex != index) {
            throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
        }
        return this.setUnique(index, object);
    }

    public Object setUnique(int index, Object object) {
        Object oldObject = this.delegateSet(index, this.validate(index, object));
        this.didSet(index, object, oldObject);
        this.didChange();
        return oldObject;
    }

    protected Object delegateSet(int index, Object object) {
        return this.delegateList().set(index, object);
    }

    public boolean add(Object object) {
        if (this.isUnique() && this.contains(object)) {
            return false;
        }
        this.addUnique(object);
        return true;
    }

    public void addUnique(Object object) {
        ++this.modCount;
        int size = this.size();
        this.delegateAdd(this.validate(size, object));
        this.didAdd(size, object);
        this.didChange();
    }

    protected void delegateAdd(Object object) {
        this.delegateList().add(object);
    }

    public void add(int index, Object object) {
        if (this.isUnique() && this.contains(object)) {
            throw new IllegalArgumentException("The 'no duplicates' constraint is violated");
        }
        this.addUnique(index, object);
    }

    public void addUnique(int index, Object object) {
        ++this.modCount;
        this.delegateAdd(index, this.validate(index, object));
        this.didAdd(index, object);
        this.didChange();
    }

    protected void delegateAdd(int index, Object object) {
        this.delegateList().add(index, object);
    }

    public boolean addAll(Collection collection) {
        if (this.isUnique()) {
            collection = this.getNonDuplicates(collection);
        }
        return this.addAllUnique(collection);
    }

    public boolean addAllUnique(Collection collection) {
        ++this.modCount;
        if (collection.isEmpty()) {
            return false;
        }
        int i2 = this.size();
        Iterator objects = collection.iterator();
        while (objects.hasNext()) {
            Object object = objects.next();
            this.delegateAdd(this.validate(i2, object));
            this.didAdd(i2, object);
            this.didChange();
            ++i2;
        }
        return true;
    }

    public boolean addAll(int index, Collection collection) {
        if (this.isUnique()) {
            collection = this.getNonDuplicates(collection);
        }
        return this.addAllUnique(index, collection);
    }

    public boolean addAllUnique(int index, Collection collection) {
        ++this.modCount;
        if (collection.isEmpty()) {
            return false;
        }
        Iterator objects = collection.iterator();
        while (objects.hasNext()) {
            Object object = objects.next();
            this.delegateAdd(index, this.validate(index, object));
            this.didAdd(index, object);
            this.didChange();
            ++index;
        }
        return true;
    }

    public boolean remove(Object object) {
        int index = this.indexOf(object);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        boolean modified = false;
        ListIterator i2 = this.delegateListIterator();
        while (i2.hasNext()) {
            if (!collection.contains(i2.next())) continue;
            this.remove(i2.previousIndex());
            modified = true;
        }
        return modified;
    }

    public Object remove(int index) {
        ++this.modCount;
        Object oldObject = this.delegateRemove(index);
        this.didRemove(index, oldObject);
        this.didChange();
        return oldObject;
    }

    protected Object delegateRemove(int index) {
        return this.delegateList().remove(index);
    }

    public boolean retainAll(Collection collection) {
        boolean modified = false;
        ListIterator i2 = this.delegateListIterator();
        while (i2.hasNext()) {
            if (collection.contains(i2.next())) continue;
            this.remove(i2.previousIndex());
            modified = true;
        }
        return modified;
    }

    public void clear() {
        this.doClear(this.size(), this.delegateToArray());
    }

    protected void doClear(int oldSize, Object[] oldData) {
        ++this.modCount;
        this.delegateClear();
        this.didClear(oldSize, oldData);
        this.didChange();
    }

    protected void delegateClear() {
        this.delegateList().clear();
    }

    public void move(int index, Object object) {
        this.move(index, this.indexOf(object));
    }

    public Object move(int targetIndex, int sourceIndex) {
        ++this.modCount;
        int size = this.size();
        if (targetIndex >= size || targetIndex < 0) {
            throw new IndexOutOfBoundsException("targetIndex=" + targetIndex + ", size=" + size);
        }
        if (sourceIndex >= size || sourceIndex < 0) {
            throw new IndexOutOfBoundsException("sourceIndex=" + sourceIndex + ", size=" + size);
        }
        Object object = this.delegateGet(sourceIndex);
        if (targetIndex != sourceIndex) {
            this.delegateAdd(targetIndex, this.delegateRemove(sourceIndex));
            this.didMove(targetIndex, object, sourceIndex);
            this.didChange();
        }
        return object;
    }

    public boolean equals(Object object) {
        return this.delegateEquals(object);
    }

    protected boolean delegateEquals(Object object) {
        return this.delegateList().equals(object);
    }

    public int hashCode() {
        return this.delegateHashCode();
    }

    protected int delegateHashCode() {
        return this.delegateList().hashCode();
    }

    public String toString() {
        return this.delegateToString();
    }

    protected String delegateToString() {
        return this.delegateList().toString();
    }

    public Iterator iterator() {
        return new EIterator();
    }

    protected Iterator delegateIterator() {
        return this.delegateList().iterator();
    }

    protected Iterator basicIterator() {
        return new NonResolvingEIterator();
    }

    public ListIterator listIterator() {
        return new EListIterator();
    }

    protected ListIterator delegateListIterator() {
        return this.delegateList().listIterator();
    }

    public ListIterator listIterator(int index) {
        int size = this.size();
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("index=" + index + ", size=" + size);
        }
        return new EListIterator(index);
    }

    protected ListIterator basicListIterator() {
        return new NonResolvingEListIterator();
    }

    protected ListIterator basicListIterator(int index) {
        int size = this.size();
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("index=" + index + ", size=" + size);
        }
        return new NonResolvingEListIterator(index);
    }

    protected List basicList() {
        return this.delegateBasicList();
    }

    protected List delegateBasicList() {
        return this.delegateList();
    }

    protected Collection getDuplicates(Collection collection) {
        Collection result = collection;
        Collection filteredResult = null;
        Iterator i2 = collection.iterator();
        while (i2.hasNext()) {
            Object object = i2.next();
            if (this.contains(object)) continue;
            if (filteredResult == null) {
                result = filteredResult = new BasicEList(collection);
            }
            filteredResult.remove(object);
        }
        return result;
    }

    protected Collection getNonDuplicates(Collection collection) {
        UniqueEList result = new UniqueEList(collection.size());
        Iterator i2 = collection.iterator();
        while (i2.hasNext()) {
            Object object = i2.next();
            if (this.contains(object)) continue;
            result.add(object);
        }
        return result;
    }

    protected class EIterator
    implements Iterator {
        protected int cursor = 0;
        protected int lastCursor = -1;
        protected int expectedModCount;

        protected EIterator() {
            this.expectedModCount = DelegatingEList.this.modCount;
        }

        public boolean hasNext() {
            return this.cursor != DelegatingEList.this.size();
        }

        public Object next() {
            try {
                Object next = DelegatingEList.this.get(this.cursor);
                this.checkModCount();
                this.lastCursor = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            if (this.lastCursor == -1) {
                throw new IllegalStateException();
            }
            this.checkModCount();
            try {
                DelegatingEList.this.remove(this.lastCursor);
                this.expectedModCount = DelegatingEList.this.modCount;
                if (this.lastCursor < this.cursor) {
                    --this.cursor;
                }
                this.lastCursor = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        protected void checkModCount() {
            if (DelegatingEList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    protected class NonResolvingEIterator
    extends EIterator {
        protected NonResolvingEIterator() {
        }

        public Object next() {
            try {
                Object next = DelegatingEList.this.delegateGet(this.cursor);
                this.checkModCount();
                this.lastCursor = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class EListIterator
    extends EIterator
    implements ListIterator {
        public EListIterator() {
        }

        public EListIterator(int index) {
            this.cursor = index;
        }

        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        public Object previous() {
            try {
                Object previous = DelegatingEList.this.get(--this.cursor);
                this.checkModCount();
                this.lastCursor = this.cursor;
                return previous;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public int nextIndex() {
            return this.cursor;
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public void set(Object object) {
            if (this.lastCursor == -1) {
                throw new IllegalStateException();
            }
            this.checkModCount();
            try {
                DelegatingEList.this.set(this.lastCursor, object);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object object) {
            this.checkModCount();
            try {
                DelegatingEList.this.add(this.cursor++, object);
                this.expectedModCount = DelegatingEList.this.modCount;
                this.lastCursor = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    protected class NonResolvingEListIterator
    extends EListIterator {
        public NonResolvingEListIterator() {
        }

        public NonResolvingEListIterator(int index) {
            super(index);
        }

        public Object next() {
            try {
                Object next = DelegatingEList.this.delegateGet(this.cursor);
                this.checkModCount();
                this.lastCursor = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public Object previous() {
            try {
                Object previous = DelegatingEList.this.delegateGet(--this.cursor);
                this.checkModCount();
                this.lastCursor = this.cursor;
                return previous;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModCount();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    public static class UnmodifiableEList
    extends DelegatingEList {
        protected List underlyingList;

        public UnmodifiableEList(List underlyingList) {
            this.underlyingList = underlyingList;
        }

        protected List delegateList() {
            return this.underlyingList;
        }

        public Object set(int index, Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(int index, Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public void move(int index, Object object) {
            throw new UnsupportedOperationException();
        }

        public Object move(int targetIndex, int sourceIndex) {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return this.basicIterator();
        }

        public ListIterator listIterator() {
            return this.basicListIterator();
        }

        public ListIterator listIterator(int index) {
            return this.basicListIterator(index);
        }
    }
}

