/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.notify.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.NotifyingList;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.DelegatingEList;

public abstract class DelegatingNotifyingListImpl
extends DelegatingEList
implements NotifyingList {
    public DelegatingNotifyingListImpl() {
    }

    public DelegatingNotifyingListImpl(Collection collection) {
        super(collection);
    }

    public Object getNotifier() {
        return null;
    }

    public Object getFeature() {
        return null;
    }

    public int getFeatureID() {
        return -1;
    }

    protected int getFeatureID(Class expectedClass) {
        return this.getFeatureID();
    }

    protected boolean isSet() {
        return !this.isEmpty();
    }

    protected boolean hasInverse() {
        return false;
    }

    protected boolean canContainNull() {
        return !this.hasInverse();
    }

    protected boolean isNotificationRequired() {
        return false;
    }

    protected boolean hasShadow() {
        return false;
    }

    protected NotificationChain shadowAdd(Object object, NotificationChain notifications) {
        return notifications;
    }

    protected NotificationChain shadowRemove(Object object, NotificationChain notifications) {
        return notifications;
    }

    protected NotificationChain shadowSet(Object oldObject, Object newObject, NotificationChain notifications) {
        return notifications;
    }

    protected NotificationChain inverseAdd(Object object, NotificationChain notifications) {
        return notifications;
    }

    protected NotificationChain inverseRemove(Object object, NotificationChain notifications) {
        return notifications;
    }

    protected NotificationImpl createNotification(int eventType, Object oldObject, Object newObject, int index) {
        throw new UnsupportedOperationException("Please change your code to call new five argument version of this method");
    }

    protected NotificationImpl createNotification(int eventType, Object oldObject, Object newObject, int index, boolean wasSet) {
        return new NotificationImpl(eventType, oldObject, newObject, index, wasSet){

            public Object getNotifier() {
                return DelegatingNotifyingListImpl.this.getNotifier();
            }

            public Object getFeature() {
                return DelegatingNotifyingListImpl.this.getFeature();
            }

            public int getFeatureID(Class expectedClass) {
                return DelegatingNotifyingListImpl.this.getFeatureID(expectedClass);
            }
        };
    }

    protected void dispatchNotification(Notification notification) {
        ((Notifier)this.getNotifier()).eNotify(notification);
    }

    public void addUnique(Object object) {
        if (this.isNotificationRequired()) {
            int index = this.size();
            boolean oldIsSet = this.isSet();
            super.addUnique(index, object);
            NotificationImpl notification = this.createNotification(3, null, object, index, oldIsSet);
            if (this.hasInverse()) {
                NotificationChain notifications = this.inverseAdd(object, null);
                if (this.hasShadow()) {
                    notifications = this.shadowAdd(object, notifications);
                }
                if (notifications == null) {
                    this.dispatchNotification(notification);
                } else {
                    notifications.add(notification);
                    notifications.dispatch();
                }
            } else {
                this.dispatchNotification(notification);
            }
        } else {
            NotificationChain notifications;
            super.addUnique(object);
            if (this.hasInverse() && (notifications = this.inverseAdd(object, null)) != null) {
                notifications.dispatch();
            }
        }
    }

    public void addUnique(int index, Object object) {
        if (this.isNotificationRequired()) {
            boolean oldIsSet = this.isSet();
            super.addUnique(index, object);
            NotificationImpl notification = this.createNotification(3, null, object, index, oldIsSet);
            if (this.hasInverse()) {
                NotificationChain notifications = this.inverseAdd(object, null);
                if (this.hasShadow()) {
                    notifications = this.shadowAdd(object, notifications);
                }
                if (notifications == null) {
                    this.dispatchNotification(notification);
                } else {
                    notifications.add(notification);
                    notifications.dispatch();
                }
            } else {
                this.dispatchNotification(notification);
            }
        } else {
            NotificationChain notifications;
            super.addUnique(index, object);
            if (this.hasInverse() && (notifications = this.inverseAdd(object, null)) != null) {
                notifications.dispatch();
            }
        }
    }

    public boolean addAllUnique(Collection collection) {
        return this.addAllUnique(this.size(), collection);
    }

    public boolean addAllUnique(int index, Collection collection) {
        int collectionSize = collection.size();
        if (collectionSize == 0) {
            return false;
        }
        if (this.isNotificationRequired()) {
            NotificationImpl notification;
            boolean oldIsSet = this.isSet();
            super.addAllUnique(index, collection);
            NotificationImpl notificationImpl = notification = collectionSize == 1 ? this.createNotification(3, null, collection.iterator().next(), index, oldIsSet) : this.createNotification(5, null, collection, index, oldIsSet);
            if (this.hasInverse()) {
                NotificationChain notifications = null;
                int lastIndex = index + collectionSize;
                int i2 = index;
                while (i2 < lastIndex) {
                    Object value = this.delegateGet(i2);
                    notifications = this.inverseAdd(value, notifications);
                    notifications = this.shadowAdd(value, notifications);
                    ++i2;
                }
                if (notifications == null) {
                    this.dispatchNotification(notification);
                } else {
                    notifications.add(notification);
                    notifications.dispatch();
                }
            } else {
                this.dispatchNotification(notification);
            }
        } else {
            super.addAllUnique(index, collection);
            if (this.hasInverse()) {
                NotificationChain notifications = null;
                int lastIndex = index + collectionSize;
                int i3 = index;
                while (i3 < lastIndex) {
                    notifications = this.inverseAdd(this.delegateGet(i3), notifications);
                    ++i3;
                }
                if (notifications != null) {
                    notifications.dispatch();
                }
            }
        }
        return true;
    }

    public NotificationChain basicAdd(Object object, NotificationChain notifications) {
        if (this.isNotificationRequired()) {
            int index = this.size();
            boolean oldIsSet = this.isSet();
            super.addUnique(index, object);
            NotificationImpl notification = this.createNotification(3, null, object, index, oldIsSet);
            if (notifications == null) {
                notifications = notification;
            } else {
                notifications.add(this.createNotification(3, null, object, index, oldIsSet));
            }
        } else {
            super.addUnique(this.size(), object);
        }
        return notifications;
    }

    public Object remove(int index) {
        NotificationChain notifications;
        if (this.isNotificationRequired()) {
            NotificationChain notifications2 = null;
            boolean oldIsSet = this.isSet();
            if (this.hasShadow()) {
                notifications2 = this.shadowRemove(this.basicGet(index), null);
            }
            NotificationImpl notification = this.createNotification(4, super.remove(index), null, index, oldIsSet);
            Object oldObject = notification.getOldValue();
            if (this.hasInverse() && oldObject != null) {
                if ((notifications2 = this.inverseRemove(oldObject, notifications2)) == null) {
                    this.dispatchNotification(notification);
                } else {
                    notifications2.add(notification);
                    notifications2.dispatch();
                }
            } else if (notifications2 == null) {
                this.dispatchNotification(notification);
            } else {
                notifications2.add(notification);
                notifications2.dispatch();
            }
            return oldObject;
        }
        Object oldObject = super.remove(index);
        if (this.hasInverse() && oldObject != null && (notifications = this.inverseRemove(oldObject, null)) != null) {
            notifications.dispatch();
        }
        return oldObject;
    }

    public boolean removeAll(Collection collection) {
        int[] positions;
        boolean result;
        NotificationChain notifications;
        boolean oldIsSet;
        block29: {
            block28: {
                oldIsSet = this.isSet();
                notifications = null;
                result = false;
                positions = null;
                if (!this.isNotificationRequired()) break block28;
                int listSize = collection.size();
                if (listSize <= 0) break block29;
                BasicEList list = new BasicEList(collection);
                Object[] objects = list.data();
                positions = new int[listSize];
                int count = 0;
                if (this.isUnique()) {
                    ListIterator i2 = this.delegateListIterator();
                    block0: while (i2.hasNext()) {
                        Object object = i2.next();
                        int j2 = listSize;
                        while (--j2 >= 0) {
                            if (!this.equalObjects(object, objects[j2])) continue;
                            if (count != j2) {
                                Object x2 = objects[count];
                                objects[count] = objects[j2];
                                objects[j2] = x2;
                            }
                            positions[count++] = i2.previousIndex();
                            continue block0;
                        }
                    }
                } else {
                    BasicEList resultList = new BasicEList(listSize);
                    ListIterator i3 = this.delegateListIterator();
                    while (i3.hasNext()) {
                        Object object = i3.next();
                        int j3 = listSize;
                        while (--j3 >= 0) {
                            if (!this.equalObjects(object, objects[j3])) continue;
                            if (positions.length <= count) {
                                int[] oldPositions = positions;
                                positions = new int[2 * positions.length];
                                System.arraycopy(oldPositions, 0, positions, 0, count);
                            }
                            positions[count++] = i3.previousIndex();
                            resultList.add(objects[j3]);
                        }
                    }
                    list = resultList;
                    objects = resultList.data();
                    listSize = count;
                    if (count > positions.length) {
                        int[] oldPositions = positions;
                        positions = new int[count];
                        System.arraycopy(oldPositions, 0, positions, 0, count);
                    }
                }
                if (count <= 0) break block29;
                result = true;
                if (this.hasShadow()) {
                    int i4 = 0;
                    while (i4 < count) {
                        notifications = this.shadowRemove(objects[i4], notifications);
                        ++i4;
                    }
                }
                int i5 = count;
                while (--i5 >= 0) {
                    super.remove(positions[i5]);
                }
                if (count != listSize) {
                    i5 = listSize;
                    while (--i5 >= count) {
                        list.remove(i5);
                    }
                    int[] oldPositions = positions;
                    positions = new int[count];
                    System.arraycopy(oldPositions, 0, positions, 0, count);
                }
                collection = list;
                break block29;
            }
            collection = this.getDuplicates(collection);
            int i6 = this.delegateSize();
            while (--i6 >= 0) {
                if (!collection.contains(this.delegateGet(i6))) continue;
                super.remove(i6);
                result = true;
            }
        }
        if (result) {
            if (this.isNotificationRequired()) {
                NotificationImpl notification;
                int collectionSize = collection.size();
                NotificationImpl notificationImpl = notification = collectionSize == 1 ? this.createNotification(4, collection.iterator().next(), null, positions[0], oldIsSet) : this.createNotification(6, collection, positions, positions[0], oldIsSet);
                if (this.hasInverse()) {
                    Iterator i7 = collection.iterator();
                    while (i7.hasNext()) {
                        notifications = this.inverseRemove(i7.next(), notifications);
                    }
                    if (notifications == null) {
                        this.dispatchNotification(notification);
                    } else {
                        notifications.add(notification);
                        notifications.dispatch();
                    }
                } else if (notifications == null) {
                    this.dispatchNotification(notification);
                } else {
                    notifications.add(notification);
                    notifications.dispatch();
                }
            } else if (this.hasInverse()) {
                Iterator i8 = collection.iterator();
                while (i8.hasNext()) {
                    notifications = this.inverseRemove(i8.next(), notifications);
                }
                if (notifications != null) {
                    notifications.dispatch();
                }
            }
            return true;
        }
        return false;
    }

    public NotificationChain basicRemove(Object object, NotificationChain notifications) {
        int index = this.indexOf(object);
        if (index != -1) {
            if (this.isNotificationRequired()) {
                boolean oldIsSet = this.isSet();
                Object oldObject = super.remove(index);
                NotificationImpl notification = this.createNotification(4, oldObject, null, index, oldIsSet);
                if (notifications == null) {
                    notifications = notification;
                } else {
                    notifications.add(notification);
                }
            } else {
                super.remove(index);
            }
        }
        return notifications;
    }

    public void clear() {
        if (this.isNotificationRequired()) {
            int size = this.size();
            boolean oldIsSet = this.isSet();
            if (size > 0) {
                NotificationImpl notification;
                BasicEList collection = new BasicEList(this.basicList());
                int collectionSize = size;
                NotificationChain notifications = null;
                if (this.hasShadow()) {
                    int i2 = 0;
                    while (i2 < size) {
                        notifications = this.shadowRemove(collection.get(i2), notifications);
                        ++i2;
                    }
                }
                this.doClear(collectionSize, collection.data());
                NotificationImpl notificationImpl = notification = collectionSize == 1 ? this.createNotification(4, collection.get(0), null, -1, oldIsSet) : this.createNotification(6, collection, null, -1, oldIsSet);
                if (this.hasInverse()) {
                    Iterator i3 = collection.iterator();
                    while (i3.hasNext()) {
                        notifications = this.inverseRemove(i3.next(), notifications);
                    }
                    if (notifications == null) {
                        this.dispatchNotification(notification);
                    } else {
                        notifications.add(notification);
                        notifications.dispatch();
                    }
                } else if (notifications == null) {
                    this.dispatchNotification(notification);
                } else {
                    notifications.add(notification);
                    notifications.dispatch();
                }
            } else {
                super.clear();
                this.dispatchNotification(this.createNotification(6, Collections.EMPTY_LIST, null, -1, oldIsSet));
            }
        } else if (this.hasInverse()) {
            int size = this.size();
            if (size > 0) {
                Object[] oldData = this.delegateToArray();
                int oldSize = size;
                this.doClear(size, oldData);
                NotificationChain notifications = null;
                int i4 = 0;
                while (i4 < oldSize) {
                    notifications = this.inverseRemove(oldData[i4], notifications);
                    ++i4;
                }
                if (notifications != null) {
                    notifications.dispatch();
                }
            } else {
                super.clear();
            }
        } else {
            super.clear();
        }
    }

    public Object setUnique(int index, Object object) {
        if (this.isNotificationRequired()) {
            NotificationChain notifications = null;
            boolean oldIsSet = this.isSet();
            NotificationImpl notification = this.createNotification(1, super.setUnique(index, object), object, index, oldIsSet);
            Object oldObject = notification.getOldValue();
            if (this.hasInverse() && !this.equalObjects(oldObject, object)) {
                if (oldObject != null) {
                    notifications = this.inverseRemove(oldObject, notifications);
                }
                notifications = this.inverseAdd(object, notifications);
                if (this.hasShadow()) {
                    notifications = this.shadowSet(oldObject, object, notifications);
                }
                if (notifications == null) {
                    this.dispatchNotification(notification);
                } else {
                    notifications.add(notification);
                    notifications.dispatch();
                }
            } else {
                if (this.hasShadow()) {
                    notifications = this.shadowSet(oldObject, object, notifications);
                }
                if (notifications == null) {
                    this.dispatchNotification(notification);
                } else {
                    notifications.add(notification);
                    notifications.dispatch();
                }
            }
            return oldObject;
        }
        Object oldObject = super.setUnique(index, object);
        if (this.hasInverse() && !this.equalObjects(oldObject, object)) {
            NotificationChain notifications = null;
            if (oldObject != null) {
                notifications = this.inverseRemove(oldObject, null);
            }
            if ((notifications = this.inverseAdd(object, notifications)) != null) {
                notifications.dispatch();
            }
        }
        return oldObject;
    }

    public NotificationChain basicSet(int index, Object object, NotificationChain notifications) {
        if (this.isNotificationRequired()) {
            boolean oldIsSet = this.isSet();
            NotificationImpl notification = this.createNotification(1, super.setUnique(index, object), object, index, oldIsSet);
            if (notifications == null) {
                notifications = notification;
            } else {
                notifications.add(notification);
            }
        } else {
            super.setUnique(index, object);
        }
        return notifications;
    }

    public Object move(int targetIndex, int sourceIndex) {
        if (this.isNotificationRequired()) {
            boolean oldIsSet = this.isSet();
            Object object = super.move(targetIndex, sourceIndex);
            this.dispatchNotification(this.createNotification(7, new Integer(sourceIndex), object, targetIndex, oldIsSet));
            return object;
        }
        return super.move(targetIndex, sourceIndex);
    }
}

