/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import org.eclipse.core.runtime.adaptor.EclipseAdaptor;
import org.eclipse.core.runtime.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.BasicLocation;
import org.eclipse.core.runtime.internal.adaptor.Locker;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.util.NLS;

public class Locker_JavaNio
implements Locker {
    private File lockFile;
    private FileLock fileLock;
    private FileOutputStream fileStream;

    public Locker_JavaNio(File lockFile) {
        this.lockFile = lockFile;
    }

    public synchronized boolean lock() throws IOException {
        this.fileStream = new FileOutputStream(this.lockFile, true);
        try {
            this.fileLock = this.fileStream.getChannel().tryLock();
        }
        catch (IOException ioe) {
            if (BasicLocation.DEBUG) {
                String basicMessage = NLS.bind(EclipseAdaptorMsg.location_cannotLock, this.lockFile);
                FrameworkLogEntry basicEntry = new FrameworkLogEntry("org.eclipse.osgi", basicMessage, 0, ioe, null);
                EclipseAdaptor.getDefault().getFrameworkLog().log(basicEntry);
            }
            String specificMessage = NLS.bind(EclipseAdaptorMsg.location_cannotLockNIO, new Object[]{this.lockFile, ioe.getMessage(), "\"-Dosgi.locking=none\""});
            throw new IOException(specificMessage);
        }
        if (this.fileLock != null) {
            return true;
        }
        this.fileStream.close();
        this.fileStream = null;
        return false;
    }

    public synchronized void release() {
        if (this.fileLock != null) {
            try {
                this.fileLock.release();
            }
            catch (IOException e2) {
                // empty catch block
            }
            this.fileLock = null;
        }
        if (this.fileStream != null) {
            try {
                this.fileStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fileStream = null;
        }
    }
}

