/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.adaptor.EclipseAdaptor;
import org.eclipse.core.runtime.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.adaptor.EclipseLog;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.core.runtime.internal.adaptor.ContextFinder;
import org.eclipse.core.runtime.internal.adaptor.EclipseEnvironmentInfo;
import org.eclipse.core.runtime.internal.adaptor.Semaphore;
import org.eclipse.core.runtime.internal.stats.StatsManager;
import org.eclipse.osgi.framework.adaptor.FilePath;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.internal.core.OSGi;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.runnable.ParameterizedRunnable;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class EclipseStarter {
    private static FrameworkAdaptor adaptor;
    private static BundleContext context;
    private static ServiceTracker applicationTracker;
    private static boolean initialize;
    public static boolean debug;
    private static boolean running;
    private static final String CLEAN = "-clean";
    private static final String CONSOLE = "-console";
    private static final String CONSOLE_LOG = "-consoleLog";
    private static final String DEBUG = "-debug";
    private static final String INITIALIZE = "-initialize";
    private static final String DEV = "-dev";
    private static final String WS = "-ws";
    private static final String OS = "-os";
    private static final String ARCH = "-arch";
    private static final String NL = "-nl";
    private static final String CONFIGURATION = "-configuration";
    private static final String USER = "-user";
    private static final String NOEXIT = "-noExit";
    private static final String DATA = "-data";
    public static final String PROP_BUNDLES = "osgi.bundles";
    public static final String PROP_BUNDLES_STARTLEVEL = "osgi.bundles.defaultStartLevel";
    public static final String PROP_EXTENSIONS = "osgi.framework.extensions";
    public static final String PROP_INITIAL_STARTLEVEL = "osgi.startLevel";
    public static final String PROP_DEBUG = "osgi.debug";
    public static final String PROP_DEV = "osgi.dev";
    public static final String PROP_CLEAN = "osgi.clean";
    public static final String PROP_CONSOLE = "osgi.console";
    public static final String PROP_CONSOLE_CLASS = "osgi.consoleClass";
    public static final String PROP_CHECK_CONFIG = "osgi.checkConfiguration";
    public static final String PROP_OS = "osgi.os";
    public static final String PROP_WS = "osgi.ws";
    public static final String PROP_NL = "osgi.nl";
    public static final String PROP_ARCH = "osgi.arch";
    public static final String PROP_ADAPTOR = "osgi.adaptor";
    public static final String PROP_SYSPATH = "osgi.syspath";
    public static final String PROP_LOGFILE = "osgi.logfile";
    public static final String PROP_FRAMEWORK = "osgi.framework";
    public static final String PROP_INSTALL_AREA = "osgi.install.area";
    public static final String PROP_FRAMEWORK_SHAPE = "osgi.framework.shape";
    public static final String PROP_NOSHUTDOWN = "osgi.noShutdown";
    public static final String PROP_EXITCODE = "eclipse.exitcode";
    public static final String PROP_EXITDATA = "eclipse.exitdata";
    public static final String PROP_CONSOLE_LOG = "eclipse.consoleLog";
    private static final String PROP_VM = "eclipse.vm";
    private static final String PROP_VMARGS = "eclipse.vmargs";
    private static final String PROP_COMMANDS = "eclipse.commands";
    public static final String PROP_IGNOREAPP = "eclipse.ignoreApp";
    public static final String PROP_REFRESH_BUNDLES = "eclipse.refreshBundles";
    private static final String FILE_SCHEME = "file:";
    private static final String FILE_PROTOCOL = "file";
    private static final String REFERENCE_SCHEME = "reference:";
    private static final String REFERENCE_PROTOCOL = "reference";
    private static final String INITIAL_LOCATION = "initial@";
    protected static final String DEFAULT_ADAPTOR_CLASS = "org.eclipse.core.runtime.adaptor.EclipseAdaptor";
    private static final int DEFAULT_INITIAL_STARTLEVEL = 6;
    private static final String DEFAULT_BUNDLES_STARTLEVEL = "4";
    protected static final String DEFAULT_CONSOLE_CLASS = "org.eclipse.osgi.framework.internal.core.FrameworkConsole";
    private static final String CONSOLE_NAME = "OSGi Console";
    private static FrameworkLog log;
    static /* synthetic */ Class class$org$eclipse$core$runtime$adaptor$EclipseStarter;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;
    static /* synthetic */ Class class$org$eclipse$osgi$framework$internal$core$OSGi;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$osgi$service$startlevel$StartLevel;
    static /* synthetic */ Class class$org$eclipse$osgi$service$runnable$ParameterizedRunnable;
    static /* synthetic */ Class class$java$lang$Runnable;
    static /* synthetic */ Class class$java$io$OutputStream;

    public static void main(String[] args) throws Exception {
        URL url = (class$org$eclipse$core$runtime$adaptor$EclipseStarter == null ? (class$org$eclipse$core$runtime$adaptor$EclipseStarter = EclipseStarter.class$("org.eclipse.core.runtime.adaptor.EclipseStarter")) : class$org$eclipse$core$runtime$adaptor$EclipseStarter).getProtectionDomain().getCodeSource().getLocation();
        System.getProperties().put(PROP_FRAMEWORK, url.toExternalForm());
        String filePart = url.getFile();
        System.getProperties().put(PROP_INSTALL_AREA, filePart.substring(0, filePart.lastIndexOf(47)));
        System.getProperties().put(PROP_NOSHUTDOWN, "true");
        EclipseStarter.run(args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Object run(String[] args, Runnable endSplashHandler) throws Exception {
        String report222;
        Object object;
        boolean startupFailed;
        block34: {
            block32: {
                String report222;
                Object var3_3;
                block33: {
                    if (Profile.STARTUP) {
                        Profile.logEnter("EclipseStarter.run()", null);
                    }
                    if (running) {
                        throw new IllegalStateException(EclipseAdaptorMsg.ECLIPSE_STARTUP_ALREADY_RUNNING);
                    }
                    startupFailed = true;
                    EclipseStarter.startup(args, endSplashHandler);
                    startupFailed = false;
                    if (!Boolean.getBoolean(PROP_IGNOREAPP)) break block32;
                    var3_3 = null;
                    Object var6_6 = null;
                    try {
                        if (!Boolean.getBoolean(PROP_NOSHUTDOWN)) {
                            EclipseStarter.shutdown();
                        }
                    }
                    catch (Throwable e2) {
                        FrameworkLogEntry logEntry = new FrameworkLogEntry("org.eclipse.osgi", EclipseAdaptorMsg.ECLIPSE_STARTUP_SHUTDOWN_ERROR, 1, e2, null);
                        if (log != null) {
                            log.log(logEntry);
                            break block33;
                        }
                        e2.printStackTrace();
                    }
                }
                if (Profile.STARTUP) {
                    Profile.logExit("EclipseStarter.run()");
                }
                if ((report222 = Profile.getProfileLog()) != null && report222.length() > 0) {
                    System.out.println(report222);
                }
                return var3_3;
            }
            object = EclipseStarter.run(null);
            Object var6_7 = null;
            try {
                if (!Boolean.getBoolean(PROP_NOSHUTDOWN)) {
                    EclipseStarter.shutdown();
                }
            }
            catch (Throwable e2) {
                FrameworkLogEntry logEntry = new FrameworkLogEntry("org.eclipse.osgi", EclipseAdaptorMsg.ECLIPSE_STARTUP_SHUTDOWN_ERROR, 1, e2, null);
                if (log != null) {
                    log.log(logEntry);
                    break block34;
                }
                e2.printStackTrace();
            }
        }
        if (Profile.STARTUP) {
            Profile.logExit("EclipseStarter.run()");
        }
        if ((report222 = Profile.getProfileLog()) != null && report222.length() > 0) {
            System.out.println(report222);
        }
        return object;
        catch (Throwable e3) {
            block35: {
                try {
                    if (endSplashHandler != null) {
                        endSplashHandler.run();
                    }
                    FrameworkLogEntry logEntry = new FrameworkLogEntry("org.eclipse.osgi", startupFailed ? EclipseAdaptorMsg.ECLIPSE_STARTUP_STARTUP_ERROR : EclipseAdaptorMsg.ECLIPSE_STARTUP_APP_ERROR, 1, e3, null);
                    if (log != null) {
                        log.log(logEntry);
                        EclipseStarter.logUnresolvedBundles(context.getBundles());
                    } else {
                        e3.printStackTrace();
                    }
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    block37: {
                        Object var6_9 = null;
                        try {
                            if (!Boolean.getBoolean(PROP_NOSHUTDOWN)) {
                                EclipseStarter.shutdown();
                            }
                        }
                        catch (Throwable e2) {
                            FrameworkLogEntry logEntry = new FrameworkLogEntry("org.eclipse.osgi", EclipseAdaptorMsg.ECLIPSE_STARTUP_SHUTDOWN_ERROR, 1, e2, null);
                            if (log != null) {
                                log.log(logEntry);
                                break block37;
                            }
                            e2.printStackTrace();
                        }
                    }
                    if (Profile.STARTUP) {
                        Profile.logExit("EclipseStarter.run()");
                    }
                    if ((report222 = Profile.getProfileLog()) != null && report222.length() > 0) {
                        System.out.println(report222);
                    }
                    throw throwable;
                }
                try {
                    if (!Boolean.getBoolean(PROP_NOSHUTDOWN)) {
                        EclipseStarter.shutdown();
                    }
                }
                catch (Throwable e2) {
                    FrameworkLogEntry logEntry = new FrameworkLogEntry("org.eclipse.osgi", EclipseAdaptorMsg.ECLIPSE_STARTUP_SHUTDOWN_ERROR, 1, e2, null);
                    if (log != null) {
                        log.log(logEntry);
                        break block35;
                    }
                    e2.printStackTrace();
                }
            }
            if (Profile.STARTUP) {
                Profile.logExit("EclipseStarter.run()");
            }
            if ((report222 = Profile.getProfileLog()) != null && report222.length() > 0) {
                System.out.println(report222);
            }
        }
        if (Boolean.getBoolean("osgi.forcedRestart")) {
            System.getProperties().put(PROP_EXITCODE, "23");
            return null;
        }
        System.getProperties().put(PROP_EXITCODE, "13");
        System.getProperties().put(PROP_EXITDATA, NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_ERROR_CHECK_LOG, log.getFile().getPath()));
        return null;
    }

    public static boolean isRunning() {
        return running;
    }

    protected static FrameworkLog createFrameworkLog() {
        EclipseLog frameworkLog;
        String logFileProp = System.getProperty(PROP_LOGFILE);
        if (logFileProp != null) {
            frameworkLog = new EclipseLog(new File(logFileProp));
        } else {
            Location location = LocationManager.getConfigurationLocation();
            File configAreaDirectory = null;
            if (location != null) {
                configAreaDirectory = new File(location.getURL().getFile());
            }
            if (configAreaDirectory != null) {
                String logFileName = Long.toString(System.currentTimeMillis()) + ".log";
                File logFile = new File(configAreaDirectory, logFileName);
                System.getProperties().put(PROP_LOGFILE, logFile.getAbsolutePath());
                frameworkLog = new EclipseLog(logFile);
            } else {
                frameworkLog = new EclipseLog();
            }
        }
        if ("true".equals(System.getProperty(PROP_CONSOLE_LOG))) {
            frameworkLog.setConsoleLog(true);
        }
        return frameworkLog;
    }

    public static void startup(String[] args, Runnable endSplashHandler) throws Exception {
        String console;
        if (Profile.STARTUP) {
            Profile.logEnter("EclipseStarter.startup()", null);
        }
        if (running) {
            throw new IllegalStateException(EclipseAdaptorMsg.ECLIPSE_STARTUP_ALREADY_RUNNING);
        }
        EclipseStarter.processCommandLine(args);
        LocationManager.initializeLocations();
        log = EclipseStarter.createFrameworkLog();
        EclipseStarter.initializeContextFinder();
        EclipseStarter.loadConfigurationInfo();
        EclipseStarter.finalizeProperties();
        Profile.initProps();
        if (Profile.STARTUP) {
            Profile.logTime("EclipseStarter.startup()", "props inited");
        }
        adaptor = EclipseStarter.createAdaptor();
        if (Profile.STARTUP) {
            Profile.logTime("EclipseStarter.startup()", "adapter created");
        }
        ((EclipseAdaptor)adaptor).setLog(log);
        if (Profile.STARTUP) {
            Profile.logTime("EclipseStarter.startup()", "adapter log set");
        }
        OSGi osgi = new OSGi(adaptor);
        if (Profile.STARTUP) {
            Profile.logTime("EclipseStarter.startup()", "OSGi created");
        }
        osgi.launch();
        if (Profile.STARTUP) {
            Profile.logTime("EclipseStarter.startup()", "osgi launched");
        }
        if ((console = System.getProperty(PROP_CONSOLE)) != null) {
            EclipseStarter.startConsole(osgi, new String[0], console);
            if (Profile.STARTUP) {
                Profile.logTime("EclipseStarter.startup()", "console started");
            }
        }
        context = osgi.getBundleContext();
        EclipseStarter.publishSplashScreen(endSplashHandler);
        if (Profile.STARTUP) {
            Profile.logTime("EclipseStarter.startup()", "loading basic bundles");
        }
        Bundle[] startBundles = EclipseStarter.loadBasicBundles();
        EclipseStarter.setStartLevel(EclipseStarter.getStartLevel());
        if ("true".equals(System.getProperty(PROP_REFRESH_BUNDLES))) {
            EclipseStarter.refreshPackages(EclipseStarter.getCurrentBundles(false));
        }
        if (Profile.STARTUP) {
            Profile.logTime("EclipseStarter.startup()", "StartLevel set");
        }
        EclipseStarter.ensureBundlesActive(startBundles);
        if (debug || System.getProperty(PROP_DEV) != null) {
            EclipseStarter.logUnresolvedBundles(context.getBundles());
        }
        running = true;
        if (Profile.STARTUP) {
            Profile.logExit("EclipseStarter.startup()");
        }
    }

    private static void initializeContextFinder() {
        Thread current = Thread.currentThread();
        try {
            Method getContextClassLoader = (class$java$lang$Thread == null ? (class$java$lang$Thread = EclipseStarter.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
            Method setContextClassLoader = (class$java$lang$Thread == null ? (class$java$lang$Thread = EclipseStarter.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("setContextClassLoader", class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = EclipseStarter.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            Object[] params = new Object[]{new ContextFinder((ClassLoader)getContextClassLoader.invoke((Object)current, null))};
            setContextClassLoader.invoke((Object)current, params);
            return;
        }
        catch (SecurityException e2) {
        }
        catch (NoSuchMethodException e3) {
        }
        catch (IllegalArgumentException e4) {
        }
        catch (IllegalAccessException e5) {
        }
        catch (InvocationTargetException e6) {
            // empty catch block
        }
        FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_CANNOT_SET_CONTEXTFINDER, null), 0, null, null);
        log.log(entry);
    }

    private static int getStartLevel() {
        block3: {
            String level = System.getProperty(PROP_INITIAL_STARTLEVEL);
            if (level != null) {
                try {
                    return Integer.parseInt(level);
                }
                catch (NumberFormatException e2) {
                    if (!debug) break block3;
                    System.out.println("Start level = " + level + "  parsed. Using hardcoded default: 6");
                }
            }
        }
        return 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object run(Object argument) throws Exception {
        if (Profile.STARTUP) {
            Profile.logEnter("EclipseStarter.run(Object)()", null);
        }
        if (!running) {
            throw new IllegalStateException(EclipseAdaptorMsg.ECLIPSE_STARTUP_NOT_RUNNING);
        }
        if (initialize) {
            return new Integer(0);
        }
        EclipseStarter.initializeApplicationTracker();
        if (Profile.STARTUP) {
            Profile.logTime("EclipseStarter.run(Object)()", "applicaton tracker initialized");
        }
        ParameterizedRunnable application = (ParameterizedRunnable)applicationTracker.getService();
        applicationTracker.close();
        if (application == null) {
            throw new IllegalStateException(EclipseAdaptorMsg.ECLIPSE_STARTUP_ERROR_NO_APPLICATION);
        }
        if (debug) {
            String timeString = System.getProperty("eclipse.startTime");
            long time = timeString == null ? 0L : Long.parseLong(timeString);
            System.out.println("Starting application: " + (System.currentTimeMillis() - time));
        }
        if (Profile.STARTUP || Profile.BENCHMARK) {
            Profile.logTime("EclipseStarter.run(Object)()", "framework initialized! starting application...");
        }
        try {
            Object object = application.run(argument);
            return object;
        }
        finally {
            if (Profile.STARTUP) {
                Profile.logExit("EclipseStarter.run(Object)()");
            }
        }
    }

    public static void shutdown() throws Exception {
        if (!running) {
            return;
        }
        EclipseStarter.stopSystemBundle();
    }

    private static void ensureBundlesActive(Bundle[] bundles) {
        for (int i2 = 0; i2 < bundles.length; ++i2) {
            if (bundles[i2].getState() == 32) continue;
            String message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_ERROR_BUNDLE_NOT_ACTIVE, bundles[i2]);
            throw new IllegalStateException(message);
        }
    }

    private static void logUnresolvedBundles(Bundle[] bundles) {
        State state = adaptor.getState();
        FrameworkLog logService = adaptor.getFrameworkLog();
        StateHelper stateHelper = adaptor.getPlatformAdmin().getStateHelper();
        for (int i2 = 0; i2 < bundles.length; ++i2) {
            if (bundles[i2].getState() != 2) continue;
            String generalMessage = NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_ERROR_BUNDLE_NOT_RESOLVED, bundles[i2]);
            BundleDescription description = state.getBundle(bundles[i2].getBundleId());
            if (description == null) continue;
            FrameworkLogEntry[] logChildren = null;
            VersionConstraint[] unsatisfied = stateHelper.getUnsatisfiedConstraints(description);
            if (unsatisfied.length > 0) {
                logChildren = new FrameworkLogEntry[unsatisfied.length];
                for (int j2 = 0; j2 < unsatisfied.length; ++j2) {
                    logChildren[j2] = new FrameworkLogEntry("org.eclipse.osgi", EclipseAdaptorMsg.getResolutionFailureMessage(unsatisfied[j2]), 0, null, null);
                }
            } else if (description.getSymbolicName() != null) {
                BundleDescription[] homonyms = state.getBundles(description.getSymbolicName());
                for (int j3 = 0; j3 < homonyms.length; ++j3) {
                    if (!homonyms[j3].isResolved()) continue;
                    logChildren = new FrameworkLogEntry[]{new FrameworkLogEntry("org.eclipse.osgi", NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_OTHER_VERSION, homonyms[j3].getLocation()), 0, null, null)};
                }
            }
            logService.log(new FrameworkLogEntry("org.eclipse.osgi", generalMessage, 0, null, logChildren));
        }
    }

    private static URL searchForBundle(String name, String parent) throws MalformedURLException {
        Object result;
        URL url = null;
        File fileLocation = null;
        boolean reference = false;
        try {
            URL child = new URL(name);
            url = new URL(new File(parent).toURL(), name);
        }
        catch (MalformedURLException e2) {
            File child = new File(name);
            fileLocation = child.isAbsolute() ? child : new File(parent, name);
            url = new URL(REFERENCE_PROTOCOL, null, fileLocation.toURL().toExternalForm());
            reference = true;
        }
        if (!reference) {
            URL baseURL = url;
            if (url.getProtocol().equals(REFERENCE_PROTOCOL)) {
                File child;
                reference = true;
                String baseSpec = url.getFile();
                baseURL = baseSpec.startsWith(FILE_SCHEME) ? ((child = new File(baseSpec.substring(5))).isAbsolute() ? child.toURL() : new File(parent, child.getPath()).toURL()) : new URL(baseSpec);
            }
            if (!(fileLocation = new File(baseURL.getFile())).isAbsolute()) {
                fileLocation = new File(parent, fileLocation.toString());
            }
        }
        if (reference) {
            result = EclipseStarter.searchFor(fileLocation.getName(), new File(fileLocation.getParent()).getAbsolutePath());
            if (result != null) {
                url = new URL(REFERENCE_PROTOCOL, null, FILE_SCHEME + (String)result);
            } else {
                return null;
            }
        }
        try {
            result = url.openConnection();
            ((URLConnection)result).connect();
            return url;
        }
        catch (IOException e3) {
            return null;
        }
    }

    private static Bundle[] loadBasicBundles() throws IOException {
        long startTime = System.currentTimeMillis();
        String osgiBundles = System.getProperty(PROP_BUNDLES);
        String osgiExtensions = System.getProperty(PROP_EXTENSIONS);
        if (osgiExtensions != null && osgiExtensions.length() > 0) {
            osgiBundles = osgiExtensions + ',' + osgiBundles;
            System.getProperties().put(PROP_BUNDLES, osgiBundles);
        }
        String[] installEntries = EclipseStarter.getArrayFromList(osgiBundles, ",");
        InitialBundle[] initialBundles = EclipseStarter.getInitialBundles(installEntries);
        Bundle[] curInitBundles = EclipseStarter.getCurrentBundles(true);
        ArrayList toRefresh = new ArrayList(curInitBundles.length);
        EclipseStarter.uninstallBundles(curInitBundles, initialBundles, toRefresh);
        ArrayList startBundles = new ArrayList(installEntries.length);
        EclipseStarter.installBundles(initialBundles, curInitBundles, startBundles, toRefresh);
        if (!toRefresh.isEmpty()) {
            EclipseStarter.refreshPackages(toRefresh.toArray(new Bundle[toRefresh.size()]));
        }
        Bundle[] startInitBundles = startBundles.toArray(new Bundle[startBundles.size()]);
        EclipseStarter.startBundles(startInitBundles);
        if (debug) {
            System.out.println("Time to load bundles: " + (System.currentTimeMillis() - startTime));
        }
        return startInitBundles;
    }

    private static InitialBundle[] getInitialBundles(String[] installEntries) throws MalformedURLException {
        ArrayList<InitialBundle> result = new ArrayList<InitialBundle>(installEntries.length);
        int defaultStartLevel = Integer.parseInt(System.getProperty(PROP_BUNDLES_STARTLEVEL, DEFAULT_BUNDLES_STARTLEVEL));
        String syspath = EclipseStarter.getSysPath();
        for (int i2 = 0; i2 < installEntries.length; ++i2) {
            URL location;
            String name = installEntries[i2];
            int level = defaultStartLevel;
            boolean start = false;
            int index = name.indexOf(64);
            if (index >= 0) {
                String[] attributes = EclipseStarter.getArrayFromList(name.substring(index + 1, name.length()), ":");
                name = name.substring(0, index);
                for (int j2 = 0; j2 < attributes.length; ++j2) {
                    String attribute = attributes[j2];
                    if (attribute.equals("start")) {
                        start = true;
                        continue;
                    }
                    level = Integer.parseInt(attribute);
                }
            }
            if ((location = EclipseStarter.searchForBundle(name, syspath)) == null) {
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_BUNDLE_NOT_FOUND, installEntries[i2]), 0, null, null);
                log.log(entry);
                continue;
            }
            location = EclipseStarter.makeRelative(LocationManager.getInstallLocation().getURL(), location);
            String locationString = INITIAL_LOCATION + location.toExternalForm();
            result.add(new InitialBundle(locationString, location, level, start));
        }
        return result.toArray(new InitialBundle[result.size()]);
    }

    private static void refreshPackages(Bundle[] bundles) {
        ServiceReference packageAdminRef = context.getServiceReference((class$org$osgi$service$packageadmin$PackageAdmin == null ? (class$org$osgi$service$packageadmin$PackageAdmin = EclipseStarter.class$("org.osgi.service.packageadmin.PackageAdmin")) : class$org$osgi$service$packageadmin$PackageAdmin).getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminRef != null && (packageAdmin = (PackageAdmin)context.getService(packageAdminRef)) == null) {
            return;
        }
        final Semaphore semaphore = new Semaphore(0);
        FrameworkListener listener = new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 4) {
                    semaphore.release();
                }
            }
        };
        context.addFrameworkListener(listener);
        packageAdmin.refreshPackages(bundles);
        semaphore.acquire();
        context.removeFrameworkListener(listener);
        context.ungetService(packageAdminRef);
    }

    private static void startConsole(OSGi osgi, String[] consoleArgs, String consolePort) {
        try {
            Object[] parameters;
            Class[] parameterTypes;
            String consoleClassName = System.getProperty(PROP_CONSOLE_CLASS, DEFAULT_CONSOLE_CLASS);
            Class<?> consoleClass = Class.forName(consoleClassName);
            if (consolePort.length() == 0) {
                parameterTypes = new Class[]{class$org$eclipse$osgi$framework$internal$core$OSGi == null ? (class$org$eclipse$osgi$framework$internal$core$OSGi = EclipseStarter.class$("org.eclipse.osgi.framework.internal.core.OSGi")) : class$org$eclipse$osgi$framework$internal$core$OSGi, array$Ljava$lang$String == null ? (array$Ljava$lang$String = EclipseStarter.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
                parameters = new Object[]{osgi, consoleArgs};
            } else {
                parameterTypes = new Class[]{class$org$eclipse$osgi$framework$internal$core$OSGi == null ? (class$org$eclipse$osgi$framework$internal$core$OSGi = EclipseStarter.class$("org.eclipse.osgi.framework.internal.core.OSGi")) : class$org$eclipse$osgi$framework$internal$core$OSGi, Integer.TYPE, array$Ljava$lang$String == null ? (array$Ljava$lang$String = EclipseStarter.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
                parameters = new Object[]{osgi, new Integer(consolePort), consoleArgs};
            }
            Constructor<?> constructor = consoleClass.getConstructor(parameterTypes);
            Object console = constructor.newInstance(parameters);
            Thread t2 = new Thread((Runnable)console, CONSOLE_NAME);
            t2.start();
        }
        catch (NumberFormatException nfe) {
            System.err.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_INVALID_PORT, consolePort));
        }
        catch (Exception ex) {
            System.out.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FAILED_FIND, CONSOLE_NAME));
        }
    }

    private static FrameworkAdaptor createAdaptor() throws Exception {
        String adaptorClassName = System.getProperty(PROP_ADAPTOR, DEFAULT_ADAPTOR_CLASS);
        Class<?> adaptorClass = Class.forName(adaptorClassName);
        Class[] constructorArgs = new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = EclipseStarter.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
        Constructor<?> constructor = adaptorClass.getConstructor(constructorArgs);
        return (FrameworkAdaptor)constructor.newInstance(new Object[]{new String[0]});
    }

    private static String[] processCommandLine(String[] args) throws Exception {
        EclipseEnvironmentInfo.setAllArgs(args);
        if (args.length == 0) {
            EclipseEnvironmentInfo.setFrameworkArgs(args);
            EclipseEnvironmentInfo.setAllArgs(args);
            return args;
        }
        int[] configArgs = new int[args.length];
        configArgs[0] = -1;
        int configArgIndex = 0;
        for (int i2 = 0; i2 < args.length; ++i2) {
            boolean found = false;
            if (args[i2].equalsIgnoreCase(DEBUG) && (i2 + 1 == args.length || i2 + 1 < args.length && args[i2 + 1].startsWith("-"))) {
                System.getProperties().put(PROP_DEBUG, "");
                debug = true;
                found = true;
            }
            if (args[i2].equalsIgnoreCase(DEV) && (i2 + 1 == args.length || i2 + 1 < args.length && args[i2 + 1].startsWith("-"))) {
                System.getProperties().put(PROP_DEV, "");
                found = true;
            }
            if (args[i2].equalsIgnoreCase(INITIALIZE)) {
                initialize = true;
                found = true;
            }
            if (args[i2].equalsIgnoreCase(CLEAN)) {
                System.getProperties().put(PROP_CLEAN, "true");
                found = true;
            }
            if (args[i2].equalsIgnoreCase(CONSOLE_LOG)) {
                System.getProperties().put(PROP_CONSOLE_LOG, "true");
                found = true;
            }
            if (args[i2].equalsIgnoreCase(CONSOLE) && (i2 + 1 == args.length || i2 + 1 < args.length && args[i2 + 1].startsWith("-"))) {
                System.getProperties().put(PROP_CONSOLE, "");
                found = true;
            }
            if (args[i2].equalsIgnoreCase(NOEXIT)) {
                System.getProperties().put(PROP_NOSHUTDOWN, "true");
                found = true;
            }
            if (found) {
                configArgs[configArgIndex++] = i2;
                continue;
            }
            if (i2 == args.length - 1 || args[i2 + 1].startsWith("-")) continue;
            String arg = args[++i2];
            if (args[i2 - 1].equalsIgnoreCase(CONSOLE)) {
                System.getProperties().put(PROP_CONSOLE, arg);
                found = true;
            }
            if (args[i2 - 1].equalsIgnoreCase(CONFIGURATION)) {
                System.getProperties().put("osgi.configuration.area", arg);
                found = true;
            }
            if (args[i2 - 1].equalsIgnoreCase(DATA)) {
                System.getProperties().put("osgi.instance.area", arg);
                found = true;
            }
            if (args[i2 - 1].equalsIgnoreCase(USER)) {
                System.getProperties().put("osgi.user.area", arg);
                found = true;
            }
            if (args[i2 - 1].equalsIgnoreCase(DEV)) {
                System.getProperties().put(PROP_DEV, arg);
                found = true;
            }
            if (args[i2 - 1].equalsIgnoreCase(DEBUG)) {
                System.getProperties().put(PROP_DEBUG, arg);
                debug = true;
                found = true;
            }
            if (args[i2 - 1].equalsIgnoreCase(WS)) {
                System.getProperties().put(PROP_WS, arg);
                found = true;
            }
            if (args[i2 - 1].equalsIgnoreCase(OS)) {
                System.getProperties().put(PROP_OS, arg);
                found = true;
            }
            if (args[i2 - 1].equalsIgnoreCase(ARCH)) {
                System.getProperties().put(PROP_ARCH, arg);
                found = true;
            }
            if (args[i2 - 1].equalsIgnoreCase(NL)) {
                System.getProperties().put(PROP_NL, arg);
                found = true;
            }
            if (!found) continue;
            configArgs[configArgIndex++] = i2 - 1;
            configArgs[configArgIndex++] = i2;
        }
        if (configArgIndex == 0) {
            EclipseEnvironmentInfo.setFrameworkArgs(new String[0]);
            EclipseEnvironmentInfo.setAppArgs(args);
            return args;
        }
        String[] appArgs = new String[args.length - configArgIndex];
        String[] frameworkArgs = new String[configArgIndex];
        configArgIndex = 0;
        int j2 = 0;
        int k2 = 0;
        for (int i3 = 0; i3 < args.length; ++i3) {
            if (i3 == configArgs[configArgIndex]) {
                frameworkArgs[k2++] = args[i3];
                ++configArgIndex;
                continue;
            }
            appArgs[j2++] = args[i3];
        }
        EclipseEnvironmentInfo.setFrameworkArgs(frameworkArgs);
        EclipseEnvironmentInfo.setAppArgs(appArgs);
        return appArgs;
    }

    private static String[] getArrayFromList(String prop, String separator) {
        if (prop == null || prop.trim().equals("")) {
            return new String[0];
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(prop, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[list.size()]);
    }

    protected static String getSysPath() {
        String result = System.getProperty(PROP_SYSPATH);
        if (result != null) {
            return result;
        }
        result = EclipseStarter.getSysPathFromURL(System.getProperty(PROP_FRAMEWORK));
        if (result == null) {
            result = EclipseStarter.getSysPathFromCodeSource();
        }
        if (result == null) {
            throw new IllegalStateException("Can not find the system path.");
        }
        if (Character.isUpperCase(result.charAt(0))) {
            char[] chars = result.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            result = new String(chars);
        }
        System.getProperties().put(PROP_SYSPATH, result);
        return result;
    }

    private static String getSysPathFromURL(String urlSpec) {
        if (urlSpec == null) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(urlSpec);
        }
        catch (MalformedURLException e2) {
            return null;
        }
        File fwkFile = new File(url.getFile());
        fwkFile = new File(fwkFile.getAbsolutePath());
        fwkFile = new File(fwkFile.getParent());
        return fwkFile.getAbsolutePath();
    }

    private static String getSysPathFromCodeSource() {
        ProtectionDomain pd = (class$org$eclipse$core$runtime$adaptor$EclipseStarter == null ? (class$org$eclipse$core$runtime$adaptor$EclipseStarter = EclipseStarter.class$("org.eclipse.core.runtime.adaptor.EclipseStarter")) : class$org$eclipse$core$runtime$adaptor$EclipseStarter).getProtectionDomain();
        if (pd == null) {
            return null;
        }
        CodeSource cs = pd.getCodeSource();
        if (cs == null) {
            return null;
        }
        URL url = cs.getLocation();
        if (url == null) {
            return null;
        }
        String result = url.getFile();
        if (result.endsWith(".jar")) {
            result = result.substring(0, result.lastIndexOf(47));
            if ("folder".equals(System.getProperty(PROP_FRAMEWORK_SHAPE))) {
                result = result.substring(0, result.lastIndexOf(47));
            }
        } else {
            if (result.endsWith("/")) {
                result = result.substring(0, result.length() - 1);
            }
            result = result.substring(0, result.lastIndexOf(47));
            result = result.substring(0, result.lastIndexOf(47));
        }
        return result;
    }

    private static Bundle[] getCurrentBundles(boolean includeInitial) {
        Bundle[] installed = context.getBundles();
        ArrayList<Bundle> initial = new ArrayList<Bundle>();
        for (int i2 = 0; i2 < installed.length; ++i2) {
            Bundle bundle = installed[i2];
            if (bundle.getLocation().startsWith(INITIAL_LOCATION)) {
                if (!includeInitial) continue;
                initial.add(bundle);
                continue;
            }
            if (includeInitial || bundle.getBundleId() == 0L) continue;
            initial.add(bundle);
        }
        return initial.toArray(new Bundle[initial.size()]);
    }

    private static Bundle getBundleByLocation(String location, Bundle[] bundles) {
        for (int i2 = 0; i2 < bundles.length; ++i2) {
            Bundle bundle = bundles[i2];
            if (!location.equalsIgnoreCase(bundle.getLocation())) continue;
            return bundle;
        }
        return null;
    }

    private static void uninstallBundles(Bundle[] curInitBundles, InitialBundle[] newInitBundles, List toRefresh) {
        for (int i2 = 0; i2 < curInitBundles.length; ++i2) {
            boolean found = false;
            for (int j2 = 0; j2 < newInitBundles.length; ++j2) {
                if (!curInitBundles[i2].getLocation().equalsIgnoreCase(newInitBundles[j2].locationString)) continue;
                found = true;
                break;
            }
            if (found) continue;
            try {
                curInitBundles[i2].uninstall();
                toRefresh.add(curInitBundles[i2]);
                continue;
            }
            catch (BundleException e2) {
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FAILED_UNINSTALL, curInitBundles[i2].getLocation()), 0, e2, null);
                log.log(entry);
            }
        }
    }

    private static void installBundles(InitialBundle[] initialBundles, Bundle[] curInitBundles, ArrayList startBundles, List toRefresh) {
        ServiceReference reference = context.getServiceReference((class$org$osgi$service$startlevel$StartLevel == null ? (class$org$osgi$service$startlevel$StartLevel = EclipseStarter.class$("org.osgi.service.startlevel.StartLevel")) : class$org$osgi$service$startlevel$StartLevel).getName());
        StartLevel startService = null;
        if (reference != null) {
            startService = (StartLevel)context.getService(reference);
        }
        for (int i2 = 0; i2 < initialBundles.length; ++i2) {
            FrameworkLogEntry entry;
            Bundle osgiBundle = EclipseStarter.getBundleByLocation(initialBundles[i2].locationString, curInitBundles);
            try {
                if (osgiBundle == null) {
                    InputStream in = initialBundles[i2].location.openStream();
                    osgiBundle = context.installBundle(initialBundles[i2].locationString, in);
                    if (initialBundles[i2].level >= 0 && startService != null) {
                        startService.setBundleStartLevel(osgiBundle, initialBundles[i2].level);
                    }
                }
                if (initialBundles[i2].start) {
                    startBundles.add(osgiBundle);
                }
                if ((osgiBundle.getState() & 2) == 0) continue;
                toRefresh.add(osgiBundle);
                continue;
            }
            catch (BundleException e2) {
                entry = new FrameworkLogEntry("org.eclipse.osgi", NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FAILED_INSTALL, initialBundles[i2].location), 0, e2, null);
                log.log(entry);
                continue;
            }
            catch (IOException e3) {
                entry = new FrameworkLogEntry("org.eclipse.osgi", NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FAILED_INSTALL, initialBundles[i2].location), 0, e3, null);
                log.log(entry);
            }
        }
        context.ungetService(reference);
    }

    private static void startBundles(Bundle[] bundles) {
        for (int i2 = 0; i2 < bundles.length; ++i2) {
            Bundle bundle = bundles[i2];
            if (bundle.getState() == 2) {
                throw new IllegalStateException(NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_ERROR_BUNDLE_NOT_RESOLVED, bundle.getLocation()));
            }
            try {
                bundle.start();
                continue;
            }
            catch (BundleException e2) {
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FAILED_START, bundle.getLocation()), 0, e2, null);
                log.log(entry);
            }
        }
    }

    private static void initializeApplicationTracker() {
        Filter filter = null;
        try {
            String appClass = (class$org$eclipse$osgi$service$runnable$ParameterizedRunnable == null ? (class$org$eclipse$osgi$service$runnable$ParameterizedRunnable = EclipseStarter.class$("org.eclipse.osgi.service.runnable.ParameterizedRunnable")) : class$org$eclipse$osgi$service$runnable$ParameterizedRunnable).getName();
            filter = context.createFilter("(&(objectClass=" + appClass + ")(eclipse.application=*))");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        applicationTracker = new ServiceTracker(context, filter, null);
        applicationTracker.open();
    }

    private static void loadConfigurationInfo() {
        Location configArea = LocationManager.getConfigurationLocation();
        if (configArea == null) {
            return;
        }
        URL location = null;
        try {
            location = new URL(configArea.getURL().toExternalForm() + "config.ini");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        EclipseStarter.mergeProperties(System.getProperties(), EclipseStarter.loadProperties(location));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(URL location) {
        Properties result = new Properties();
        if (location == null) {
            return result;
        }
        try {
            InputStream in = location.openStream();
            try {
                result.load(in);
            }
            finally {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static URL makeRelative(URL base, URL location) throws MalformedURLException {
        if (base == null) {
            return location;
        }
        if (!FILE_PROTOCOL.equals(base.getProtocol())) {
            return location;
        }
        boolean reference = location.getProtocol().equals(REFERENCE_PROTOCOL);
        URL nonReferenceLocation = location;
        if (reference) {
            nonReferenceLocation = new URL(location.getPath());
        }
        if (!base.getProtocol().equals(nonReferenceLocation.getProtocol())) {
            return location;
        }
        File locationPath = new File(nonReferenceLocation.getPath());
        if (!locationPath.isAbsolute()) {
            return location;
        }
        File relativePath = EclipseStarter.makeRelative(new File(base.getPath()), locationPath);
        String urlPath = relativePath.getPath();
        if (File.separatorChar != '/') {
            urlPath = urlPath.replace(File.separatorChar, '/');
        }
        if (nonReferenceLocation.getPath().endsWith("/")) {
            urlPath = urlPath + '/';
        }
        URL relativeURL = new URL(base.getProtocol(), base.getHost(), base.getPort(), urlPath);
        if (reference) {
            relativeURL = new URL(REFERENCE_SCHEME + relativeURL.toExternalForm());
        }
        return relativeURL;
    }

    private static File makeRelative(File base, File location) {
        if (!location.isAbsolute()) {
            return location;
        }
        File relative = new File(new FilePath(base).makeRelative(new FilePath(location)));
        return relative;
    }

    private static void mergeProperties(Properties destination, Properties source) {
        Enumeration<Object> e2 = source.keys();
        while (e2.hasMoreElements()) {
            String key = (String)e2.nextElement();
            String value = source.getProperty(key);
            if (destination.getProperty(key) != null) continue;
            destination.put(key, value);
        }
    }

    private static void stopSystemBundle() throws BundleException {
        if (context == null || !running) {
            return;
        }
        Bundle systemBundle = context.getBundle(0L);
        if (systemBundle.getState() == 32) {
            final Semaphore semaphore = new Semaphore(0);
            FrameworkListener listener = new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    if (event.getType() == 8) {
                        semaphore.release();
                    }
                }
            };
            context.addFrameworkListener(listener);
            systemBundle.stop();
            semaphore.acquire();
            context.removeFrameworkListener(listener);
        }
        context = null;
        applicationTracker = null;
        running = false;
    }

    private static void setStartLevel(final int value) {
        ServiceTracker tracker = new ServiceTracker(context, (class$org$osgi$service$startlevel$StartLevel == null ? (class$org$osgi$service$startlevel$StartLevel = EclipseStarter.class$("org.osgi.service.startlevel.StartLevel")) : class$org$osgi$service$startlevel$StartLevel).getName(), null);
        tracker.open();
        final StartLevel startLevel = (StartLevel)tracker.getService();
        final Semaphore semaphore = new Semaphore(0);
        FrameworkListener listener = new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 8 && startLevel.getStartLevel() == value) {
                    semaphore.release();
                }
            }
        };
        context.addFrameworkListener(listener);
        startLevel.setStartLevel(value);
        semaphore.acquire();
        context.removeFrameworkListener(listener);
        tracker.close();
    }

    private static String searchFor(String target, String start) {
        String[] candidates = new File(start).list();
        if (candidates == null) {
            return null;
        }
        String result = null;
        Object[] maxVersion = null;
        for (int i2 = 0; i2 < candidates.length; ++i2) {
            File candidate = new File(start, candidates[i2]);
            if (!candidate.getName().equals(target) && !candidate.getName().startsWith(target + "_")) continue;
            String name = candidate.getName();
            String version = "";
            int index = name.indexOf(95);
            if (index != -1) {
                version = name.substring(index + 1);
            }
            Object[] currentVersion = EclipseStarter.getVersionElements(version);
            if (maxVersion == null) {
                result = candidate.getAbsolutePath();
                maxVersion = currentVersion;
                continue;
            }
            if (EclipseStarter.compareVersion(maxVersion, currentVersion) >= 0) continue;
            result = candidate.getAbsolutePath();
            maxVersion = currentVersion;
        }
        if (result == null) {
            return null;
        }
        return result.replace(File.separatorChar, '/') + "/";
    }

    private static Object[] getVersionElements(String version) {
        Object[] result = new Object[]{new Integer(0), new Integer(0), new Integer(0), ""};
        StringTokenizer t2 = new StringTokenizer(version, ".");
        int i2 = 0;
        while (t2.hasMoreTokens() && i2 < 4) {
            String token = t2.nextToken();
            if (i2 < 3) {
                try {
                    result[i2++] = new Integer(token);
                    continue;
                }
                catch (Exception e2) {
                    break;
                }
            }
            result[i2++] = token;
        }
        return result;
    }

    private static int compareVersion(Object[] left, Object[] right) {
        int result = ((Integer)left[0]).compareTo((Integer)right[0]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[1]).compareTo((Integer)right[1]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[2]).compareTo((Integer)right[2]);
        if (result != 0) {
            return result;
        }
        return ((String)left[3]).compareTo((String)right[3]);
    }

    private static String buildCommandLine(String arg, String value) {
        String commandLine;
        int i2;
        StringBuffer result = new StringBuffer(300);
        String entry = System.getProperty(PROP_VM);
        if (entry == null) {
            return null;
        }
        result.append(entry);
        result.append('\n');
        entry = System.getProperty(PROP_VMARGS);
        if (entry != null) {
            result.append(entry);
        }
        if ((entry = System.getProperty(PROP_COMMANDS)) != null) {
            result.append(entry);
        }
        if ((i2 = (commandLine = result.toString()).indexOf(arg + "\n")) == 0) {
            commandLine = commandLine + arg + "\n" + value + "\n";
        } else {
            String left = commandLine.substring(0, i2 += arg.length() + 1);
            int j2 = commandLine.indexOf(10, i2);
            String right = commandLine.substring(j2);
            commandLine = left + value + right;
        }
        return commandLine;
    }

    private static void finalizeProperties() {
        if (System.getProperty(PROP_DEV) != null && System.getProperty(PROP_CHECK_CONFIG) == null) {
            System.getProperties().put(PROP_CHECK_CONFIG, "true");
        }
    }

    private static void publishSplashScreen(final Runnable endSplashHandler) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("name", "splashscreen");
        Runnable handler = new Runnable(){

            public void run() {
                StatsManager.doneBooting();
                endSplashHandler.run();
            }
        };
        context.registerService((class$java$lang$Runnable == null ? (class$java$lang$Runnable = EclipseStarter.class$("java.lang.Runnable")) : class$java$lang$Runnable).getName(), (Object)handler, properties);
        try {
            Method method = endSplashHandler.getClass().getMethod("getOutputStream", new Class[0]);
            Object outputStream = method.invoke((Object)endSplashHandler, new Object[0]);
            if (outputStream instanceof OutputStream) {
                Hashtable<String, String> osProperties = new Hashtable<String, String>();
                ((Dictionary)osProperties).put("name", "splashstream");
                context.registerService((class$java$io$OutputStream == null ? (class$java$io$OutputStream = EclipseStarter.class$("java.io.OutputStream")) : class$java$io$OutputStream).getName(), outputStream, osProperties);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        initialize = false;
        debug = false;
        running = false;
    }

    private static class InitialBundle {
        public final String locationString;
        public final URL location;
        public final int level;
        public final boolean start;

        InitialBundle(String locationString, URL location, int level, boolean start) {
            this.locationString = locationString;
            this.location = location;
            this.level = level;
            this.start = start;
        }
    }
}

