/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.adaptor.EclipseAdaptor;
import org.eclipse.core.runtime.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.adaptor.EclipseBundleData;
import org.eclipse.core.runtime.internal.adaptor.BundleStopper;
import org.eclipse.core.runtime.internal.adaptor.EclipseEnvironmentInfo;
import org.eclipse.core.runtime.internal.stats.ClassloaderStats;
import org.eclipse.core.runtime.internal.stats.ResourceBundleStats;
import org.eclipse.core.runtime.internal.stats.StatsManager;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.adaptor.core.AbstractBundleData;
import org.eclipse.osgi.framework.adaptor.core.BundleEntry;
import org.eclipse.osgi.framework.adaptor.core.BundleFile;
import org.eclipse.osgi.framework.adaptor.core.DefaultClassLoader;
import org.eclipse.osgi.framework.adaptor.core.DevClassPathHelper;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;

public class EclipseClassLoader
extends DefaultClassLoader {
    private static String[] NL_JAR_VARIANTS = EclipseClassLoader.buildNLJarVariants(EclipseEnvironmentInfo.getDefault().getNL());
    private static boolean DEFINE_PACKAGES;
    private static final String VARIABLE_DELIM_STRING = "$";
    private static final char VARIABLE_DELIM_CHAR = '$';
    private static final String EXTERNAL_LIB_PREFIX = "external:";

    public EclipseClassLoader(ClassLoaderDelegate delegate, ProtectionDomain domain, String[] classpath, ClassLoader parent, BundleData bundleData) {
        super(delegate, domain, classpath, parent, (EclipseBundleData)bundleData);
    }

    public Class findLocalClass(String className) throws ClassNotFoundException {
        if (StatsManager.MONITOR_CLASSES) {
            ClassloaderStats.startLoadingClass(this.getClassloaderId(), className);
        }
        boolean found = true;
        try {
            AbstractBundle bundle = (AbstractBundle)this.hostdata.getBundle();
            if ((bundle.getState() & 0x31) != 0) {
                Class clazz = this.basicFindLocalClass(className);
                return clazz;
            }
            if (!this.shouldActivateFor(className)) {
                Class clazz = this.basicFindLocalClass(className);
                return clazz;
            }
            if (bundle.getState() == 8) {
                if (bundle.testStateChanging(Thread.currentThread()) || bundle.testStateChanging(null)) {
                    Class clazz = this.basicFindLocalClass(className);
                    return clazz;
                }
                if (!bundle.testStateChanging(Thread.currentThread())) {
                    long delay;
                    Thread threadChangingState = bundle.getStateChanging();
                    if (StatsManager.TRACE_BUNDLES && threadChangingState != null) {
                        System.out.println("Concurrent startup of bundle " + bundle.getSymbolicName() + " by " + Thread.currentThread() + " and " + threadChangingState.getName() + ". Waiting up to 5000ms for " + threadChangingState + " to finish the initialization.");
                    }
                    long start = System.currentTimeMillis();
                    long timeLeft = delay = 5000L;
                    while (true) {
                        try {
                            Thread.sleep(100L);
                            if (bundle.testStateChanging(null) || timeLeft <= 0L) {
                                break;
                            }
                        }
                        catch (InterruptedException e2) {
                            // empty catch block
                        }
                        timeLeft = start + delay - System.currentTimeMillis();
                    }
                    if (timeLeft <= 0L || bundle.getState() != 32) {
                        String bundleName = bundle.getSymbolicName() == null ? Long.toString(bundle.getBundleId()) : bundle.getSymbolicName();
                        String message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_CONCURRENT_STARTUP, new Object[]{Thread.currentThread().getName(), className, threadChangingState.getName(), bundleName, Long.toString(delay)});
                        EclipseAdaptor.getDefault().getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", message, 0, new Exception(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_GENERATED_EXCEPTION), null));
                    }
                    Class clazz = this.basicFindLocalClass(className);
                    return clazz;
                }
            }
            try {
                this.hostdata.getBundle().start();
            }
            catch (BundleException e3) {
                String message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_ACTIVATION, bundle.getSymbolicName(), Long.toString(bundle.getBundleId()));
                EclipseAdaptor.getDefault().getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", message, 0, e3, null));
                throw new ClassNotFoundException(className, e3);
            }
            Class clazz = this.basicFindLocalClass(className);
            return clazz;
        }
        catch (ClassNotFoundException e4) {
            found = false;
            throw e4;
        }
        finally {
            if (StatsManager.MONITOR_CLASSES) {
                ClassloaderStats.endLoadingClass(this.getClassloaderId(), className, found);
            }
        }
    }

    protected Class basicFindLocalClass(String name) throws ClassNotFoundException {
        return super.findLocalClass(name);
    }

    private boolean shouldActivateFor(String className) throws ClassNotFoundException {
        BundleStopper stopper;
        if (this.hostdata.getAdaptor().isStopping() && (stopper = EclipseAdaptor.getDefault().getBundleStopper()) != null && stopper.isStopped(this.hostdata.getBundle())) {
            String message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_ALREADY_STOPPED, className, this.hostdata.getSymbolicName());
            throw new ClassNotFoundException(message);
        }
        boolean autoStart = ((EclipseBundleData)this.hostdata).isAutoStart();
        String[] autoStartExceptions = ((EclipseBundleData)this.hostdata).getAutoStartExceptions();
        if (autoStartExceptions == null) {
            return autoStart;
        }
        int dotPosition = className.lastIndexOf(46);
        if (dotPosition == -1) {
            return autoStart;
        }
        String packageName = className.substring(0, dotPosition);
        return autoStart ^ this.contains(autoStartExceptions, packageName);
    }

    private boolean contains(String[] array, String element) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (!array[i2].equals(element)) continue;
            return true;
        }
        return false;
    }

    protected Class defineClass(String name, byte[] classbytes, int off, int len, DefaultClassLoader.ClasspathEntry classpathEntry) throws ClassFormatError {
        String packageName;
        Package pkg;
        if (!DEFINE_PACKAGES) {
            return super.defineClass(name, classbytes, off, len, classpathEntry);
        }
        int lastIndex = name.lastIndexOf(46);
        if (lastIndex != -1 && (pkg = this.getPackage(packageName = name.substring(0, lastIndex))) == null) {
            String specTitle = null;
            String specVersion = null;
            String specVendor = null;
            String implTitle = null;
            String implVersion = null;
            String implVendor = null;
            Manifest mf = ((EclipseClasspathEntry)classpathEntry).getManifest();
            if (mf != null) {
                Attributes mainAttributes = mf.getMainAttributes();
                String dirName = packageName.replace('.', '/') + '/';
                Attributes packageAttributes = mf.getAttributes(dirName);
                boolean noEntry = false;
                if (packageAttributes == null) {
                    noEntry = true;
                    packageAttributes = mainAttributes;
                }
                if ((specTitle = packageAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE)) == null && !noEntry) {
                    specTitle = mainAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
                }
                if ((specVersion = packageAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION)) == null && !noEntry) {
                    specVersion = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                }
                if ((specVendor = packageAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR)) == null && !noEntry) {
                    specVendor = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                }
                if ((implTitle = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE)) == null && !noEntry) {
                    implTitle = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                }
                if ((implVersion = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION)) == null && !noEntry) {
                    implVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                }
                if ((implVendor = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR)) == null && !noEntry) {
                    implVendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                }
            }
            this.definePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, null);
        }
        return super.defineClass(name, classbytes, off, len, classpathEntry);
    }

    private String getClassloaderId() {
        return this.hostdata.getBundle().getSymbolicName();
    }

    public URL getResource(String name) {
        URL result = super.getResource(name);
        if (StatsManager.MONITOR_RESOURCES && result != null && name.endsWith(".properties")) {
            ClassloaderStats.loadedBundle(this.getClassloaderId(), new ResourceBundleStats(this.getClassloaderId(), name, result));
        }
        return result;
    }

    protected void findClassPathEntry(ArrayList result, String entry, AbstractBundleData bundledata, ProtectionDomain domain) {
        String var = this.hasPrefix(entry);
        if (var != null) {
            this.findInternalClassPath(var, result, entry, bundledata, domain);
            return;
        }
        if (entry.startsWith(EXTERNAL_LIB_PREFIX)) {
            DefaultClassLoader.ClasspathEntry cpEntry = this.getExternalClassPath(this.substituteVars(entry = entry.substring(EXTERNAL_LIB_PREFIX.length())), bundledata, domain);
            if (cpEntry != null) {
                result.add(cpEntry);
            }
            return;
        }
        super.findClassPathEntry(result, entry, bundledata, domain);
    }

    private void findInternalClassPath(String var, ArrayList result, String entry, AbstractBundleData bundledata, ProtectionDomain domain) {
        if (var.equals("ws")) {
            super.findClassPathEntry(result, "ws/" + EclipseEnvironmentInfo.getDefault().getWS() + entry.substring(4), bundledata, domain);
            return;
        }
        if (var.equals("os")) {
            super.findClassPathEntry(result, "os/" + EclipseEnvironmentInfo.getDefault().getOS() + entry.substring(4), bundledata, domain);
            return;
        }
        if (var.equals("nl")) {
            entry = entry.substring(4);
            for (int i2 = 0; i2 < NL_JAR_VARIANTS.length; ++i2) {
                if (!this.addClassPathEntry(result, "nl/" + NL_JAR_VARIANTS[i2] + entry, bundledata, domain)) continue;
                return;
            }
            if (!DevClassPathHelper.inDevelopmentMode()) {
                BundleException be = new BundleException(NLS.bind(Msg.BUNDLE_CLASSPATH_ENTRY_NOT_FOUND_EXCEPTION, entry));
                bundledata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, bundledata.getBundle(), be);
            }
        }
    }

    private static String[] buildNLJarVariants(String nl) {
        ArrayList<String> result = new ArrayList<String>();
        nl = nl.replace('_', '/');
        while (nl.length() > 0) {
            result.add("nl/" + nl + "/");
            int i2 = nl.lastIndexOf(47);
            nl = i2 < 0 ? "" : nl.substring(0, i2);
        }
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    private String hasPrefix(String libPath) {
        if (libPath.startsWith("$ws$")) {
            return "ws";
        }
        if (libPath.startsWith("$os$")) {
            return "os";
        }
        if (libPath.startsWith("$nl$")) {
            return "nl";
        }
        return null;
    }

    private String substituteVars(String cp) {
        StringBuffer buf = new StringBuffer(cp.length());
        StringTokenizer st = new StringTokenizer(cp, VARIABLE_DELIM_STRING, true);
        boolean varStarted = false;
        String var = null;
        while (st.hasMoreElements()) {
            String tok = st.nextToken();
            if (VARIABLE_DELIM_STRING.equals(tok)) {
                if (!varStarted) {
                    varStarted = true;
                    var = "";
                    continue;
                }
                String prop = null;
                if (var != null && var.length() > 0) {
                    prop = System.getProperty(var);
                }
                if (prop != null) {
                    buf.append(prop);
                } else {
                    buf.append(var == null ? "" : var);
                }
                varStarted = false;
                var = null;
                continue;
            }
            if (!varStarted) {
                buf.append(tok);
                continue;
            }
            var = tok;
        }
        if (var != null) {
            buf.append('$').append(var);
        }
        return buf.toString();
    }

    protected DefaultClassLoader.ClasspathEntry createClassPathEntry(BundleFile bundlefile, ProtectionDomain domain) {
        return new EclipseClasspathEntry(bundlefile, domain);
    }

    static {
        try {
            Class.forName("java.lang.Package");
            DEFINE_PACKAGES = true;
        }
        catch (ClassNotFoundException e2) {
            DEFINE_PACKAGES = false;
        }
    }

    protected class EclipseClasspathEntry
    extends DefaultClassLoader.ClasspathEntry {
        Manifest mf;
        boolean initMF = false;

        protected EclipseClasspathEntry(BundleFile bundlefile, ProtectionDomain domain) {
            super(EclipseClassLoader.this, bundlefile, domain);
        }

        public Manifest getManifest() {
            if (this.initMF) {
                return this.mf;
            }
            if (!this.hasPackageInfo()) {
                this.initMF = true;
                this.mf = null;
                return this.mf;
            }
            BundleEntry mfEntry = this.getBundleFile().getEntry("META-INF/MANIFEST.MF");
            if (mfEntry != null) {
                try {
                    InputStream manIn = mfEntry.getInputStream();
                    this.mf = new Manifest(manIn);
                    manIn.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.initMF = true;
            return this.mf;
        }

        private boolean hasPackageInfo() {
            if (this.getBundleFile() == EclipseClassLoader.this.getHostData().getBaseBundleFile()) {
                return ((EclipseBundleData)EclipseClassLoader.this.getHostData()).hasPackageInfo;
            }
            DefaultClassLoader.FragmentClasspath[] fragCPs = EclipseClassLoader.this.getFragClasspaths();
            if (fragCPs != null) {
                for (int i2 = 0; i2 < fragCPs.length; ++i2) {
                    if (this.getBundleFile() != fragCPs[i2].getBundleData().getBaseBundleFile()) continue;
                    return ((EclipseBundleData)fragCPs[i2].getBundleData()).hasPackageInfo;
                }
            }
            return true;
        }
    }
}

