/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.watson;

import java.io.DataInput;
import java.io.IOException;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeReader;
import org.eclipse.core.internal.watson.IElementInfoFlattener;
import org.eclipse.core.internal.watson.IElementTreeData;

class ElementTreeReaderImpl_1
extends ElementTreeReader {
    ElementTreeReaderImpl_1(IElementInfoFlattener factory) {
        super(factory);
    }

    public ElementTree readDelta(ElementTree parentTree, DataInput input) throws IOException {
        DeltaDataTree complete = parentTree.getDataTree();
        DeltaDataTree delta = this.dataTreeReader.readTree(complete, input);
        if (delta.isEmptyDelta()) {
            return parentTree;
        }
        ElementTree tree = new ElementTree(delta);
        IElementTreeData data = parentTree.getTreeData();
        if (data != null) {
            tree.setTreeData((IElementTreeData)data.clone());
        }
        delta.immutable();
        return tree;
    }

    public ElementTree[] readDeltaChain(DataInput input) throws IOException {
        int treeCount = ElementTreeReaderImpl_1.readNumber(input);
        ElementTree[] results = new ElementTree[treeCount];
        if (treeCount <= 0) {
            return results;
        }
        int[] order = new int[treeCount];
        int i2 = 0;
        while (i2 < treeCount) {
            order[i2] = ElementTreeReaderImpl_1.readNumber(input);
            ++i2;
        }
        results[order[0]] = super.readTree(input);
        i2 = 1;
        while (i2 < treeCount) {
            results[order[i2]] = super.readDelta(results[order[i2 - 1]], input);
            ++i2;
        }
        return results;
    }

    public ElementTree readTree(DataInput input) throws IOException {
        ElementTree result = new ElementTree(this.dataTreeReader.readTree(null, input));
        return result;
    }
}

