/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.utils.IStringPoolParticipant;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.utils.StringPool;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;

public class StringPoolJob
extends Job {
    private static final long INITIAL_DELAY = 10000L;
    private static final long RESCHEDULE_DELAY = 300000L;
    private long lastDuration;
    private Map participants = Collections.synchronizedMap(new HashMap(10));

    public StringPoolJob() {
        super(Messages.utils_stringJobName);
        this.setSystem(true);
        this.setPriority(50);
    }

    public void addStringPoolParticipant(IStringPoolParticipant participant, ISchedulingRule rule) {
        this.participants.put(participant, rule);
        if (this.getState() == 1) {
            this.wakeUp(10000L);
        } else {
            this.schedule(10000L);
        }
    }

    public void removeStringPoolParticipant(IStringPoolParticipant participant) {
        this.participants.remove(participant);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        block6: {
            Map.Entry[] entries = this.participants.entrySet().toArray(new Map.Entry[0]);
            ISchedulingRule[] rules = new ISchedulingRule[entries.length];
            IStringPoolParticipant[] toRun = new IStringPoolParticipant[entries.length];
            int i2 = 0;
            while (i2 < toRun.length) {
                toRun[i2] = (IStringPoolParticipant)entries[i2].getKey();
                rules[i2] = (ISchedulingRule)entries[i2].getValue();
                ++i2;
            }
            ISchedulingRule rule = MultiRule.combine(rules);
            long start = -1L;
            int savings = 0;
            try {
                Platform.getJobManager().beginRule(rule, monitor);
                start = System.currentTimeMillis();
                savings = this.shareStrings(toRun, monitor);
                Object var9_11 = null;
                Platform.getJobManager().endRule(rule);
                if (start <= 0L) break block6;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                Platform.getJobManager().endRule(rule);
                throw throwable;
            }
            this.lastDuration = System.currentTimeMillis() - start;
            if (Policy.DEBUG_STRINGS) {
                Policy.debug("String sharing saved " + savings + " bytes in: " + this.lastDuration);
            }
        }
        long scheduleDelay = Math.max(300000L, this.lastDuration * 100L);
        if (Policy.DEBUG_STRINGS) {
            Policy.debug("Rescheduling string sharing job in: " + scheduleDelay);
        }
        this.schedule(scheduleDelay);
        return Status.OK_STATUS;
    }

    private int shareStrings(IStringPoolParticipant[] toRun, IProgressMonitor monitor) {
        final StringPool pool = new StringPool();
        int i2 = 0;
        while (i2 < toRun.length) {
            if (monitor.isCanceled()) break;
            final IStringPoolParticipant current = toRun[i2];
            Platform.run(new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() {
                    current.shareStrings(pool);
                }
            });
            ++i2;
        }
        return pool.getSavedStringCount();
    }
}

