/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.utils;

import java.util.Enumeration;
import org.eclipse.core.internal.utils.ArrayEnumeration;
import org.eclipse.core.internal.utils.EmptyEnumeration;

public class Queue {
    protected Object[] elements;
    protected int head;
    protected int tail;
    protected boolean reuse;

    public Queue() {
        this(20, false);
    }

    public Queue(int size, boolean reuse) {
        this.elements = new Object[size];
        this.tail = 0;
        this.head = 0;
        this.reuse = reuse;
    }

    public void add(Object element) {
        int newTail = this.increment(this.tail);
        if (newTail == this.head) {
            this.grow();
            newTail = this.tail + 1;
        }
        this.elements[this.tail] = element;
        this.tail = newTail;
    }

    public void clear() {
        if (this.tail >= this.head) {
            int i2 = this.head;
            while (i2 < this.tail) {
                this.elements[i2] = null;
                ++i2;
            }
        } else {
            int i3 = this.head;
            while (i3 < this.elements.length) {
                this.elements[i3] = null;
                ++i3;
            }
            i3 = 0;
            while (i3 < this.tail) {
                this.elements[i3] = null;
                ++i3;
            }
        }
        this.head = 0;
        this.tail = 0;
    }

    public int decrement(int index) {
        return index == 0 ? this.elements.length - 1 : index - 1;
    }

    public Object elementAt(int index) {
        return this.elements[index];
    }

    public Enumeration elements() {
        if (this.isEmpty()) {
            return EmptyEnumeration.getEnumeration();
        }
        if (this.head <= this.tail) {
            return new ArrayEnumeration(this.elements, this.head, this.tail - 1);
        }
        Object[] newElements = new Object[this.size()];
        int end = this.elements.length - this.head;
        System.arraycopy(this.elements, this.head, newElements, 0, end);
        System.arraycopy(this.elements, 0, newElements, end, this.tail);
        return new ArrayEnumeration(newElements);
    }

    public Object get(Object o2) {
        int index = this.head;
        while (index != this.tail) {
            if (this.elements[index].equals(o2)) {
                return this.elements[index];
            }
            index = this.increment(index);
        }
        return null;
    }

    public Object getNextAvailableObject() {
        int index = this.tail;
        while (index != this.head) {
            if (this.elements[index] != null) {
                Object result = this.elements[index];
                this.elements[index] = null;
                return result;
            }
            index = this.increment(index);
        }
        return null;
    }

    protected void grow() {
        int newSize = (int)((double)this.elements.length * 1.5);
        Object[] newElements = new Object[newSize];
        if (this.tail >= this.head) {
            System.arraycopy(this.elements, this.head, newElements, this.head, this.size());
        } else {
            int newHead = newSize - (this.elements.length - this.head);
            System.arraycopy(this.elements, 0, newElements, 0, this.tail + 1);
            System.arraycopy(this.elements, this.head, newElements, newHead, newSize - newHead);
            this.head = newHead;
        }
        this.elements = newElements;
    }

    public int increment(int index) {
        return index == this.elements.length - 1 ? 0 : index + 1;
    }

    public int indexOf(Object target) {
        if (this.tail >= this.head) {
            int i2 = this.head;
            while (i2 < this.tail) {
                if (target.equals(this.elements[i2])) {
                    return i2;
                }
                ++i2;
            }
        } else {
            int i3 = this.head;
            while (i3 < this.elements.length) {
                if (target.equals(this.elements[i3])) {
                    return i3;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < this.tail) {
                if (target.equals(this.elements[i3])) {
                    return i3;
                }
                ++i3;
            }
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.tail == this.head;
    }

    public Object peek() {
        return this.elements[this.head];
    }

    public Object peekTail() {
        return this.elements[this.decrement(this.tail)];
    }

    public Object remove() {
        if (this.isEmpty()) {
            return null;
        }
        Object result = this.peek();
        if (!this.reuse) {
            this.elements[this.head] = null;
        }
        this.head = this.increment(this.head);
        return result;
    }

    public Object removeTail() {
        Object result = this.peekTail();
        this.tail = this.decrement(this.tail);
        if (!this.reuse) {
            this.elements[this.tail] = null;
        }
        return result;
    }

    public void reset() {
        this.head = 0;
        this.tail = 0;
    }

    public int size() {
        return this.tail > this.head ? this.tail - this.head : this.elements.length - this.head + this.tail;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        int count = 0;
        if (!this.isEmpty()) {
            Enumeration it = this.elements();
            while (count < 100) {
                sb.append(it.nextElement());
                if (!it.hasMoreElements()) break;
                sb.append(',').append(' ');
            }
        }
        if (count < this.size()) {
            sb.append('.').append('.').append('.');
        }
        sb.append(']');
        return sb.toString();
    }
}

