/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import org.eclipse.core.internal.preferences.StringPool;

public final class HashMapOfString {
    private int elementSize = 0;
    private String[] keyTable;
    private int threshold;
    private String[] valueTable;
    private static final float LOAD_FACTOR = 0.45f;

    public HashMapOfString() {
        this(16);
    }

    public HashMapOfString(int size) {
        int tableLen = 1;
        while (tableLen < size) {
            tableLen *= 2;
        }
        this.keyTable = new String[tableLen];
        this.valueTable = new String[tableLen];
        this.threshold = (int)((float)tableLen * 0.45f);
    }

    public String get(String key) {
        String currentKey;
        int lengthMask = this.keyTable.length - 1;
        int index = key.hashCode() & lengthMask;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey.equals(key)) {
                return this.valueTable[index];
            }
            index = index + 1 & lengthMask;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.elementSize == 0;
    }

    public String[] keys() {
        String[] result = new String[this.elementSize];
        int next = 0;
        int i2 = 0;
        while (i2 < this.keyTable.length) {
            if (this.keyTable[i2] != null) {
                result[next++] = this.keyTable[i2];
            }
            ++i2;
        }
        return result;
    }

    public String put(String key, String value) {
        String currentKey;
        int lengthMask = this.keyTable.length - 1;
        int index = key.hashCode() & lengthMask;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey.equals(key)) {
                this.valueTable[index] = value;
                return this.valueTable[index];
            }
            index = index + 1 & lengthMask;
        }
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash(this.keyTable.length * 2);
        }
        return value;
    }

    private void rehash(int newLen) {
        int oldLen;
        HashMapOfString newHashtable = new HashMapOfString(newLen);
        int i2 = oldLen = this.keyTable.length;
        while (--i2 >= 0) {
            String currentKey = this.keyTable[i2];
            if (currentKey == null) continue;
            newHashtable.put(currentKey, this.valueTable[i2]);
        }
        this.keyTable = newHashtable.keyTable;
        this.valueTable = newHashtable.valueTable;
        this.threshold = newHashtable.threshold;
    }

    public String removeKey(String key) {
        String currentKey;
        int lengthMask = this.keyTable.length - 1;
        int index = key.hashCode() & lengthMask;
        while ((currentKey = this.keyTable[index]) != null) {
            if (currentKey.equals(key)) {
                String value = this.valueTable[index];
                --this.elementSize;
                this.keyTable[index] = null;
                this.valueTable[index] = null;
                this.rehash((int)((float)this.elementSize / 0.45f));
                return value;
            }
            index = index + 1 & lengthMask;
        }
        return null;
    }

    public void shareStrings(StringPool set) {
        String o2;
        String[] array = this.keyTable;
        if (array == null) {
            return;
        }
        int i2 = 0;
        while (i2 < array.length) {
            o2 = array[i2];
            if (o2 != null) {
                array[i2] = set.add(o2);
            }
            ++i2;
        }
        array = this.valueTable;
        if (array == null) {
            return;
        }
        i2 = 0;
        while (i2 < array.length) {
            o2 = array[i2];
            if (o2 != null) {
                array[i2] = set.add(o2);
            }
            ++i2;
        }
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String s2 = "";
        int i2 = 0;
        int length = this.valueTable.length;
        while (i2 < length) {
            String value = this.valueTable[i2];
            if (value != null) {
                s2 = String.valueOf(s2) + this.keyTable[i2] + " -> " + value.toString() + "\n";
            }
            ++i2;
        }
        return s2;
    }
}

