/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class DataArea {
    static final String F_META_AREA = ".metadata";
    static final String F_PLUGIN_DATA = ".plugins";
    static final String F_LOG = ".log";
    static final String PREFERENCES_FILE_NAME = "pref_store.ini";
    private IPath location;
    private boolean initialized = false;

    protected void assertLocationInitialized() throws IllegalStateException {
        if (this.location != null && this.initialized) {
            return;
        }
        Location service = InternalPlatform.getDefault().getInstanceLocation();
        if (service == null) {
            throw new IllegalStateException(Messages.meta_noDataModeSpecified);
        }
        try {
            URL url = service.getURL();
            if (url == null) {
                throw new IllegalStateException(Messages.meta_instanceDataUnspecified);
            }
            this.location = new Path(new File(url.getFile()).toString());
            this.initializeLocation();
        }
        catch (CoreException e2) {
            throw new IllegalStateException(e2.getMessage());
        }
    }

    public IPath getMetadataLocation() throws IllegalStateException {
        this.assertLocationInitialized();
        return this.location.append(F_META_AREA);
    }

    public IPath getInstanceDataLocation() throws IllegalStateException {
        this.assertLocationInitialized();
        return this.location;
    }

    public IPath getLogLocation() throws IllegalStateException {
        return new Path(InternalPlatform.getDefault().getFrameworkLog().getFile().getAbsolutePath());
    }

    public IPath getStateLocation(Bundle bundle) throws IllegalStateException {
        this.assertLocationInitialized();
        return this.getStateLocation(bundle.getSymbolicName());
    }

    public IPath getStateLocation(String bundleName) throws IllegalStateException {
        this.assertLocationInitialized();
        return this.getMetadataLocation().append(F_PLUGIN_DATA).append(bundleName);
    }

    public IPath getPreferenceLocation(String bundleName, boolean create) throws IllegalStateException {
        IPath result = this.getStateLocation(bundleName);
        if (create) {
            result.toFile().mkdirs();
        }
        return result.append(PREFERENCES_FILE_NAME);
    }

    private void initializeLocation() throws CoreException {
        if (this.location.toFile().exists() && !this.location.toFile().isDirectory()) {
            String message = NLS.bind(Messages.meta_notDir, this.location);
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 5, message, null));
        }
        if (this.location.getDevice() == null) {
            this.location = new Path(this.location.toFile().getAbsolutePath());
        }
        this.createLocation();
        this.initialized = true;
    }

    private void createLocation() throws CoreException {
        File file = this.location.append(F_META_AREA).toFile();
        try {
            file.mkdirs();
        }
        catch (Exception e2) {
            String message = NLS.bind(Messages.meta_couldNotCreate, file.getAbsolutePath());
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 5, message, e2));
        }
        if (!file.canWrite()) {
            String message = NLS.bind(Messages.meta_readonly, file.getAbsolutePath());
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 5, message, null));
        }
        IPath path = this.location.append(F_META_AREA).append(F_LOG);
        try {
            InternalPlatform.getDefault().getFrameworkLog().setFile(path.toFile(), true);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }
}

