/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.internal.runtime.Cipher;

public class CipherInputStream
extends FilterInputStream {
    private static final int SKIP_BUFFER_SIZE = 2048;
    private Cipher cipher;

    public CipherInputStream(InputStream is, String password) {
        super(is);
        this.cipher = new Cipher(-1, password);
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int b2 = super.read();
        if (b2 == -1) {
            return -1;
        }
        try {
            return this.cipher.cipher((byte)b2) & 0xFF;
        }
        catch (Exception e2) {
            throw new IOException(e2.getMessage());
        }
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int bytesRead = this.in.read(b2, off, len);
        if (bytesRead == -1) {
            return -1;
        }
        try {
            byte[] result = this.cipher.cipher(b2, off, bytesRead);
            int i2 = 0;
            while (i2 < result.length) {
                b2[i2 + off] = result[i2];
                ++i2;
            }
            return bytesRead;
        }
        catch (Exception e2) {
            throw new IOException(e2.getMessage());
        }
    }

    public long skip(long n2) throws IOException {
        byte[] buffer = new byte[2048];
        int bytesRead = 0;
        long bytesRemaining = n2;
        while (bytesRead != -1 && bytesRemaining > 0L) {
            bytesRead = this.read(buffer, 0, (int)Math.min(2048L, bytesRemaining));
            if (bytesRead <= 0) continue;
            bytesRemaining -= (long)bytesRead;
        }
        return n2 - bytesRemaining;
    }
}

