/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.ProjectNatureDescriptor;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Cache;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProjectContentTypes {
    private static final String CONTENT_TYPE_PREF_NODE = "content-types";
    static final InstanceScope INSTANCE_SCOPE = new InstanceScope();
    private static final String PREF_LOCAL_CONTENT_TYPE_SETTINGS = "enabled";
    private static final Preferences PROJECT_SCOPE = Platform.getPreferencesService().getRootNode().node("project");
    private Cache contentTypesPerProject;
    private Workspace workspace;

    static boolean usesContentTypePreferences(String projectName) {
        try {
            Preferences node = PROJECT_SCOPE;
            if (!node.nodeExists(projectName)) {
                return false;
            }
            if (!(node = node.node(projectName)).nodeExists("org.eclipse.core.runtime")) {
                return false;
            }
            if (!(node = node.node("org.eclipse.core.runtime")).nodeExists(CONTENT_TYPE_PREF_NODE)) {
                return false;
            }
            node = node.node(CONTENT_TYPE_PREF_NODE);
            return node.getBoolean(PREF_LOCAL_CONTENT_TYPE_SETTINGS, false);
        }
        catch (BackingStoreException backingStoreException) {
            return false;
        }
    }

    public ProjectContentTypes(Workspace workspace) {
        this.workspace = workspace;
        this.contentTypesPerProject = new Cache(5, 30, 0.4);
    }

    private Set collectAssociatedContentTypes(Project project) {
        String[] enabledNatures = this.workspace.getNatureManager().getEnabledNatures(project);
        if (enabledNatures.length == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> related = new HashSet<String>(enabledNatures.length);
        int i2 = 0;
        while (i2 < enabledNatures.length) {
            ProjectNatureDescriptor descriptor = (ProjectNatureDescriptor)this.workspace.getNatureDescriptor(enabledNatures[i2]);
            if (descriptor != null) {
                String[] natureContentTypes = descriptor.getContentTypeIds();
                int j2 = 0;
                while (j2 < natureContentTypes.length) {
                    related.add(natureContentTypes[j2]);
                    ++j2;
                }
            }
            ++i2;
        }
        return related;
    }

    public void contentTypePreferencesChanged(IProject project) {
        ProjectInfo info = (ProjectInfo)((Project)project).getResourceInfo(false, false);
        if (info != null) {
            info.setMatcher(null);
        }
    }

    private IContentTypeMatcher createMatcher(Project project) {
        ProjectContentTypeSelectionPolicy projectContentTypeSelectionPolicy = new ProjectContentTypeSelectionPolicy(project);
        return Platform.getContentTypeManager().getMatcher(projectContentTypeSelectionPolicy, projectContentTypeSelectionPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getAssociatedContentTypes(Project project) {
        ResourceInfo info = project.getResourceInfo(false, false);
        if (info == null) {
            return null;
        }
        String projectName = project.getName();
        Cache cache = this.contentTypesPerProject;
        synchronized (cache) {
            Cache.Entry entry = this.contentTypesPerProject.getEntry(projectName);
            if (entry != null && entry.getTimestamp() == (long)info.getContentId()) {
                return (Set)entry.getCached();
            }
            Set result = this.collectAssociatedContentTypes(project);
            if (entry == null) {
                entry = this.contentTypesPerProject.addEntry(projectName, result, info.getContentId());
            } else {
                entry.setTimestamp(info.getContentId());
                entry.setCached(result);
            }
            return result;
        }
    }

    public IContentTypeMatcher getMatcherFor(Project project) throws CoreException {
        IContentTypeMatcher matcher;
        ProjectInfo info = (ProjectInfo)project.getResourceInfo(false, false);
        if (info == null) {
            project.checkAccessible(project.getFlags(info));
        }
        if ((matcher = info.getMatcher()) != null) {
            return matcher;
        }
        matcher = this.createMatcher(project);
        info.setMatcher(matcher);
        return matcher;
    }

    final IContentType[] select(Project project, IContentType[] candidates, boolean fileName, boolean content) {
        if (candidates.length < 2) {
            return candidates;
        }
        Set associated = this.getAssociatedContentTypes(project);
        if (associated == null || associated.isEmpty()) {
            return candidates;
        }
        int associatedCount = 0;
        int i2 = 0;
        while (i2 < candidates.length) {
            if (associated.contains(candidates[i2].getId())) {
                if (associatedCount < i2) {
                    IContentType promoted = candidates[i2];
                    int j2 = i2;
                    while (j2 > associatedCount) {
                        candidates[j2] = candidates[j2 - 1];
                        --j2;
                    }
                    candidates[associatedCount] = promoted;
                }
                ++associatedCount;
            }
            ++i2;
        }
        return candidates;
    }

    private class ProjectContentTypeSelectionPolicy
    implements IContentTypeManager.ISelectionPolicy,
    IScopeContext {
        private Project project;
        private IScopeContext projectScope;

        public ProjectContentTypeSelectionPolicy(Project project) {
            this.project = project;
            this.projectScope = new ProjectScope(project);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IScopeContext)) {
                return false;
            }
            IScopeContext other = (IScopeContext)obj;
            if (!this.getName().equals(other.getName())) {
                return false;
            }
            IPath location = this.getLocation();
            return location == null ? other.getLocation() == null : location.equals(other.getLocation());
        }

        private IScopeContext getDelegate() {
            if (!ProjectContentTypes.usesContentTypePreferences(this.project.getName())) {
                return INSTANCE_SCOPE;
            }
            return this.projectScope;
        }

        public IPath getLocation() {
            return this.getDelegate().getLocation();
        }

        public String getName() {
            return this.getDelegate().getName();
        }

        public IEclipsePreferences getNode(String qualifier) {
            return this.getDelegate().getNode(qualifier);
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public IContentType[] select(IContentType[] candidates, boolean fileName, boolean content) {
            return ProjectContentTypes.this.select(this.project, candidates, fileName, content);
        }
    }
}

