/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.osgi.util.NLS;

public class FileState
extends PlatformObject
implements IFileState {
    protected long lastModified;
    protected UniversalUniqueIdentifier uuid;
    protected IHistoryStore store;
    protected IPath fullPath;

    public FileState(IHistoryStore store, IPath fullPath, long lastModified, UniversalUniqueIdentifier uuid) {
        this.store = store;
        this.lastModified = lastModified;
        this.uuid = uuid;
        this.fullPath = fullPath;
    }

    public boolean exists() {
        return this.store.exists(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCharset() throws CoreException {
        String string;
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        BufferedInputStream contents = new BufferedInputStream(this.getContents());
        boolean failed = false;
        try {
            try {
                IContentDescription description = contentTypeManager.getDescriptionFor(contents, this.getName(), new QualifiedName[]{IContentDescription.CHARSET});
                string = description == null ? null : description.getCharset();
                Object var6_7 = null;
            }
            catch (IOException e3) {
                failed = true;
                String message = NLS.bind(Messages.history_errorContentDescription, this.getFullPath());
                throw new ResourceException(381, this.getFullPath(), message, e3);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                ((InputStream)contents).close();
                throw throwable;
            }
            catch (IOException e2) {
                if (failed) throw throwable;
                String message2 = NLS.bind(Messages.history_errorContentDescription, this.getFullPath());
                throw new ResourceException(381, this.getFullPath(), message2, e2);
            }
        }
        try {}
        catch (IOException e2) {
            if (failed) return string;
            String message2 = NLS.bind(Messages.history_errorContentDescription, this.getFullPath());
            throw new ResourceException(381, this.getFullPath(), message2, e2);
        }
        ((InputStream)contents).close();
        return string;
    }

    public InputStream getContents() throws CoreException {
        return this.store.getContents(this);
    }

    public IPath getFullPath() {
        return this.fullPath;
    }

    public long getModificationTime() {
        return this.lastModified;
    }

    public String getName() {
        return this.fullPath.lastSegment();
    }

    public UniversalUniqueIdentifier getUUID() {
        return this.uuid;
    }

    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer();
        s2.append("FileState(uuid: ");
        s2.append(this.uuid.toString());
        s2.append(", lastModified: ");
        s2.append(this.lastModified);
        s2.append(", blob: ");
        s2.append(this.store.getFileFor(this));
        s2.append(')');
        return s2.toString();
    }
}

