/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class HashtableOfInt {
    private int[] keyTable;
    private int[] valueTable;
    private static final float GROWTH_FACTOR = 1.33f;
    private int elementSize = 0;
    private int threshold;

    public HashtableOfInt() {
        this(13);
    }

    public HashtableOfInt(int size) {
        this.threshold = size;
        int extraRoom = (int)((float)size * 1.33f);
        if (this.threshold == extraRoom) {
            ++extraRoom;
        }
        this.keyTable = new int[extraRoom];
        this.valueTable = new int[extraRoom];
    }

    public boolean containsKey(int key) {
        int currentKey;
        int index = key % this.valueTable.length;
        while ((currentKey = this.keyTable[index]) != 0) {
            if (currentKey == key) {
                return true;
            }
            index = (index + 1) % this.keyTable.length;
        }
        return false;
    }

    public int get(int key) {
        int currentKey;
        int index = key % this.valueTable.length;
        while ((currentKey = this.keyTable[index]) != 0) {
            if (currentKey == key) {
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        return Integer.MIN_VALUE;
    }

    public int removeKey(int key) {
        int currentKey;
        int index = key % this.valueTable.length;
        while ((currentKey = this.keyTable[index]) != 0) {
            if (currentKey == key) {
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        return Integer.MIN_VALUE;
    }

    public int put(int key, int value) {
        int currentKey;
        int index = key % this.valueTable.length;
        while ((currentKey = this.keyTable[index]) != 0) {
            if (currentKey == key) {
                this.valueTable[index] = value;
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return value;
    }

    private void rehash() {
        HashtableOfInt newHashtable = new HashtableOfInt((int)((float)this.elementSize * 1.33f));
        int i2 = this.keyTable.length;
        while (--i2 >= 0) {
            int currentKey = this.keyTable[i2];
            if (currentKey == 0) continue;
            newHashtable.put(currentKey, this.valueTable[i2]);
        }
        this.keyTable = newHashtable.keyTable;
        this.valueTable = newHashtable.valueTable;
        this.threshold = newHashtable.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String s2 = "";
        int i2 = 0;
        int length = this.valueTable.length;
        while (i2 < length) {
            int object = this.valueTable[i2];
            if (object != Integer.MIN_VALUE) {
                s2 = String.valueOf(s2) + this.keyTable[i2] + " -> " + object + "\n";
            }
            ++i2;
        }
        return s2;
    }

    public void save(DataOutputStream out) throws IOException {
        out.writeInt(this.elementSize);
        int tableSize = this.keyTable.length;
        out.writeInt(tableSize);
        out.writeInt(this.threshold);
        int i2 = 0;
        while (i2 < tableSize) {
            out.writeInt(this.keyTable[i2]);
            out.writeInt(this.valueTable[i2]);
            ++i2;
        }
    }

    public void load(DataInputStream in) throws IOException {
        this.elementSize = in.readInt();
        int tableSize = in.readInt();
        this.threshold = in.readInt();
        boolean fastMode = true;
        if ((double)tableSize / (double)this.elementSize < (double)1.33f) {
            this.keyTable = new int[(int)((float)this.elementSize * 1.33f)];
            this.valueTable = new int[(int)((float)this.elementSize * 1.33f)];
            this.elementSize = 0;
            fastMode = false;
        } else {
            this.keyTable = new int[tableSize];
            this.valueTable = new int[tableSize];
        }
        int i2 = 0;
        while (i2 < tableSize) {
            int key = in.readInt();
            int value = in.readInt();
            if (fastMode) {
                this.keyTable[i2] = key;
                this.valueTable[i2] = value;
            } else {
                this.put(key, value);
            }
            ++i2;
        }
    }
}

