/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.lang.ref.SoftReference;
import org.eclipse.core.internal.registry.RegistryObject;
import org.eclipse.core.internal.registry.TableReader;
import org.eclipse.core.internal.runtime.CompatibilityHelper;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class Extension
extends RegistryObject {
    public static final Extension[] EMPTY_ARRAY = new Extension[0];
    private String simpleId;
    private String namespace;
    private Object extraInformation;
    private static final byte LABEL = 0;
    private static final byte XPT_NAME = 1;
    private static final int EXTRA_SIZE = 2;

    Extension() {
    }

    Extension(int self, String simpleId, String namespace, int[] children, int extraData) {
        this.setObjectId(self);
        this.simpleId = simpleId;
        this.setRawChildren(children);
        this.extraDataOffset = extraData;
        this.namespace = namespace;
    }

    String getExtensionPointIdentifier() {
        return this.getExtraData()[1];
    }

    String getSimpleIdentifier() {
        return this.simpleId;
    }

    String getUniqueIdentifier() {
        return this.simpleId == null ? null : String.valueOf(this.getNamespace()) + '.' + this.simpleId;
    }

    void setExtensionPointIdentifier(String value) {
        this.ensureExtraInformationType();
        ((String[])this.extraInformation)[1] = value;
    }

    void setSimpleIdentifier(String value) {
        this.simpleId = value;
    }

    private String[] getExtraData() {
        if (this.extraDataOffset == -1) {
            if (this.extraInformation != null) {
                return (String[])this.extraInformation;
            }
            return null;
        }
        String[] result = null;
        if (this.extraInformation == null || (result = this.extraInformation instanceof SoftReference ? (String[])((SoftReference)this.extraInformation).get() : (String[])this.extraInformation) == null) {
            result = new TableReader().loadExtensionExtraData(this.extraDataOffset);
            this.extraInformation = new SoftReference<String[]>(result);
        }
        return result;
    }

    String getLabel() {
        String s2 = this.getExtraData()[0];
        if (s2 == null) {
            return "";
        }
        return s2;
    }

    void setLabel(String value) {
        this.ensureExtraInformationType();
        ((String[])this.extraInformation)[0] = value;
    }

    String getNamespace() {
        return this.namespace;
    }

    void setNamespace(String value) {
        this.namespace = value;
    }

    public String toString() {
        return String.valueOf(this.getUniqueIdentifier()) + " -> " + this.getExtensionPointIdentifier();
    }

    IPluginDescriptor getDeclaringPluginDescriptor() {
        Bundle[] hosts;
        Bundle underlyingBundle;
        IPluginDescriptor result = CompatibilityHelper.getPluginDescriptor(this.getNamespace());
        if (result == null && (underlyingBundle = Platform.getBundle(this.getNamespace())) != null && (hosts = Platform.getHosts(underlyingBundle)) != null) {
            result = CompatibilityHelper.getPluginDescriptor(hosts[0].getSymbolicName());
        }
        if (CompatibilityHelper.DEBUG && result == null) {
            Policy.debug("Could not obtain plug-in descriptor for bundle " + this.getNamespace());
        }
        return result;
    }

    private void ensureExtraInformationType() {
        if (this.extraInformation instanceof SoftReference) {
            this.extraInformation = ((SoftReference)this.extraInformation).get();
        }
        if (this.extraInformation == null) {
            this.extraInformation = new String[2];
        }
    }
}

