/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import org.eclipse.core.internal.localstore.CoreFileSystemLibrary;
import org.eclipse.core.internal.localstore.IUnifiedTreeVisitor;
import org.eclipse.core.internal.localstore.RefreshLocalVisitor;
import org.eclipse.core.internal.localstore.UnifiedTreeNode;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;

public class CopyVisitor
implements IUnifiedTreeVisitor {
    protected IResource rootDestination;
    protected IPath rootDestinationLocalLocation;
    protected IProgressMonitor monitor;
    protected int updateFlags;
    protected boolean force;
    protected boolean isDeep;
    protected int segmentsToDrop;
    protected MultiStatus status;
    protected RefreshLocalVisitor refreshLocalVisitor;

    public CopyVisitor(IResource rootSource, IResource destination, int updateFlags, IProgressMonitor monitor) {
        this.rootDestination = destination;
        this.rootDestinationLocalLocation = destination.getLocation();
        this.updateFlags = updateFlags;
        this.isDeep = (updateFlags & 0x20) == 0;
        this.force = (updateFlags & 1) != 0;
        this.monitor = monitor;
        this.segmentsToDrop = rootSource.getFullPath().segmentCount();
        this.status = new MultiStatus("org.eclipse.core.resources", 1, Messages.localstore_copyProblem, null);
    }

    protected boolean copy(UnifiedTreeNode node) {
        IPath sufix;
        Resource destination;
        Resource source = (Resource)node.getResource();
        if (!this.copyProperties(source, destination = this.getDestinationResource(source, sufix = source.getFullPath().removeFirstSegments(this.segmentsToDrop)))) {
            return false;
        }
        return this.copyContents(node, source, destination);
    }

    protected boolean copyContents(UnifiedTreeNode node, Resource source, Resource destination) {
        try {
            if (!this.isDeep && source.isLinked()) {
                destination.createLink(source.getRawLocation(), this.updateFlags & 0x10, null);
                return false;
            }
            if (destination.getType() == 2) {
                ((IFolder)((Object)destination)).create(this.updateFlags, true, null);
                CoreFileSystemLibrary.copyAttributes(node.getLocalLocation(), destination.getLocation().toOSString(), false);
                return true;
            }
            ((IFile)((Object)destination)).create(((IFile)((Object)source)).getContents(false), this.updateFlags, null);
            long lastModified = node.getLastModified();
            ResourceInfo destinationInfo = destination.getResourceInfo(false, true);
            destinationInfo.setLocalSyncInfo(lastModified);
            destinationInfo.clear(65536);
            IPath destinationLocation = destination.getLocation();
            destinationLocation.toFile().setLastModified(lastModified);
            this.getWorkspace().getAliasManager().updateAliases(destination, destinationLocation, 0, this.monitor);
            CoreFileSystemLibrary.copyAttributes(node.getLocalLocation(), destinationLocation.toOSString(), false);
            destination.getLocalManager().getHistoryStore().copyHistory(source, destination, false);
        }
        catch (CoreException e2) {
            this.status.add(e2.getStatus());
        }
        return false;
    }

    protected boolean copyProperties(Resource target, Resource destination) {
        try {
            target.getPropertyManager().copy(target, destination, 0);
            return true;
        }
        catch (CoreException e2) {
            this.status.add(e2.getStatus());
            return false;
        }
    }

    protected Resource getDestinationResource(Resource source, IPath sufix) {
        IPath destinationPath = this.rootDestination.getFullPath().append(sufix);
        return this.getWorkspace().newResource(destinationPath, source.getType());
    }

    protected RefreshLocalVisitor getRefreshLocalVisitor() {
        if (this.refreshLocalVisitor == null) {
            this.refreshLocalVisitor = new RefreshLocalVisitor(Policy.monitorFor(null));
        }
        return this.refreshLocalVisitor;
    }

    public IStatus getStatus() {
        return this.status;
    }

    protected Workspace getWorkspace() {
        return (Workspace)this.rootDestination.getWorkspace();
    }

    protected boolean isSynchronized(UnifiedTreeNode node) {
        if (!node.existsInWorkspace() || !node.existsInFileSystem()) {
            return false;
        }
        if (node.isFolder() && node.getResource().getType() == 2) {
            return true;
        }
        Resource target = (Resource)node.getResource();
        long lastModifed = target.getResourceInfo(false, false).getLocalSyncInfo();
        return lastModifed == node.getLastModified();
    }

    protected void synchronize(UnifiedTreeNode node) throws CoreException {
        this.getRefreshLocalVisitor().visit(node);
    }

    public boolean visit(UnifiedTreeNode node) throws CoreException {
        int work;
        block7: {
            boolean wasSynchronized;
            block6: {
                block5: {
                    Policy.checkCanceled(this.monitor);
                    work = 1;
                    try {
                        if (node.getLocalLocation() != null) break block5;
                        IPath path = node.getResource().getFullPath();
                        String message = NLS.bind(Messages.localstore_locationUndefined, path);
                        this.status.add(new ResourceStatus(271, path, message, null));
                        Object var6_8 = null;
                        this.monitor.worked(work);
                        return false;
                    }
                    catch (Throwable throwable) {
                        Object var6_12 = null;
                        this.monitor.worked(work);
                        throw throwable;
                    }
                }
                wasSynchronized = this.isSynchronized(node);
                if (!this.force || wasSynchronized) break block6;
                this.synchronize(node);
                work = 0;
                if (node.existsInFileSystem()) break block6;
                IPath path = node.getResource().getFullPath();
                String message = NLS.bind(Messages.resources_mustExist, path);
                this.status.add(new ResourceStatus(368, path, message, null));
                Object var6_9 = null;
                this.monitor.worked(work);
                return false;
            }
            if (this.force || wasSynchronized) break block7;
            IPath path = node.getResource().getFullPath();
            String message = NLS.bind(Messages.localstore_resourceIsOutOfSync, path);
            this.status.add(new ResourceStatus(274, path, message, null));
            Object var6_10 = null;
            this.monitor.worked(work);
            return true;
        }
        boolean bl = this.copy(node);
        Object var6_11 = null;
        this.monitor.worked(work);
        return bl;
    }
}

