/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.HashMap;
import java.util.Stack;
import org.eclipse.core.internal.jobs.Deadlock;
import org.eclipse.core.internal.jobs.DeadlockDetector;
import org.eclipse.core.internal.jobs.OrderedLock;
import org.eclipse.core.internal.jobs.Worker;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.LockListener;

public class LockManager {
    protected LockListener lockListener;
    private DeadlockDetector locks = new DeadlockDetector();
    private HashMap suspendedLocks = new HashMap();

    public void aboutToRelease() {
        if (this.lockListener == null) {
            return;
        }
        try {
            this.lockListener.aboutToRelease();
        }
        catch (Exception e2) {
            LockManager.handleException(e2);
        }
        catch (LinkageError e3) {
            LockManager.handleException(e3);
        }
    }

    public boolean aboutToWait(Thread lockOwner) {
        if (this.lockListener == null) {
            return false;
        }
        try {
            return this.lockListener.aboutToWait(lockOwner);
        }
        catch (Exception e2) {
            LockManager.handleException(e2);
        }
        catch (LinkageError e3) {
            LockManager.handleException(e3);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLockThread(Thread thread, ISchedulingRule lock) {
        if (this.locks == null) {
            return;
        }
        try {
            DeadlockDetector deadlockDetector = this.locks;
            synchronized (deadlockDetector) {
                this.locks.lockAcquired(thread, lock);
            }
        }
        catch (Exception e2) {
            this.handleInternalError(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLockWaitThread(Thread thread, ISchedulingRule lock) {
        if (this.locks == null) {
            return;
        }
        try {
            Deadlock found = null;
            DeadlockDetector deadlockDetector = this.locks;
            synchronized (deadlockDetector) {
                found = this.locks.lockWaitStart(thread, lock);
            }
            if (found == null) {
                return;
            }
            ISchedulingRule[] toSuspend = found.getLocks();
            LockState[] suspended = new LockState[toSuspend.length];
            int i2 = 0;
            while (i2 < toSuspend.length) {
                suspended[i2] = LockState.suspend((OrderedLock)toSuspend[i2]);
                ++i2;
            }
            HashMap hashMap = this.suspendedLocks;
            synchronized (hashMap) {
                Stack<LockState[]> prevLocks = (Stack<LockState[]>)this.suspendedLocks.get(found.getCandidate());
                if (prevLocks == null) {
                    prevLocks = new Stack<LockState[]>();
                }
                prevLocks.push(suspended);
                this.suspendedLocks.put(found.getCandidate(), prevLocks);
            }
        }
        catch (Exception e2) {
            this.handleInternalError(e2);
        }
    }

    private static void handleException(Throwable e2) {
        Status status;
        if (e2 instanceof CoreException) {
            status = new MultiStatus("org.eclipse.core.runtime", 2, Messages.jobs_internalError, e2);
            status.merge(((CoreException)e2).getStatus());
        } else {
            status = new Status(4, "org.eclipse.core.runtime", 2, Messages.jobs_internalError, e2);
        }
        InternalPlatform.getDefault().log(status);
    }

    private void handleInternalError(Throwable t2) {
        try {
            LockManager.handleException(t2);
            this.locks.toDebugString();
        }
        catch (Exception exception) {}
        this.locks = null;
    }

    public boolean isEmpty() {
        return this.locks.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLockOwner() {
        Thread current = Thread.currentThread();
        if (current instanceof Worker) {
            return true;
        }
        if (this.locks == null) {
            return false;
        }
        DeadlockDetector deadlockDetector = this.locks;
        synchronized (deadlockDetector) {
            return this.locks.contains(Thread.currentThread());
        }
    }

    public synchronized OrderedLock newLock() {
        return new OrderedLock(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLockCompletely(Thread thread, ISchedulingRule rule) {
        if (this.locks == null) {
            return;
        }
        try {
            DeadlockDetector deadlockDetector = this.locks;
            synchronized (deadlockDetector) {
                this.locks.lockReleasedCompletely(thread, rule);
            }
        }
        catch (Exception e2) {
            this.handleInternalError(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLockThread(Thread thread, ISchedulingRule lock) {
        try {
            DeadlockDetector deadlockDetector = this.locks;
            synchronized (deadlockDetector) {
                this.locks.lockReleased(thread, lock);
            }
        }
        catch (Exception e2) {
            this.handleInternalError(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLockWaitThread(Thread thread, ISchedulingRule lock) {
        try {
            DeadlockDetector deadlockDetector = this.locks;
            synchronized (deadlockDetector) {
                this.locks.lockWaitStop(thread, lock);
            }
        }
        catch (Exception e2) {
            this.handleInternalError(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resumeSuspendedLocks(Thread owner) {
        LockState[] toResume;
        HashMap hashMap = this.suspendedLocks;
        synchronized (hashMap) {
            Stack prevLocks = (Stack)this.suspendedLocks.get(owner);
            if (prevLocks == null) {
                return;
            }
            toResume = (LockState[])prevLocks.pop();
            if (prevLocks.empty()) {
                this.suspendedLocks.remove(owner);
            }
        }
        int i2 = 0;
        while (i2 < toResume.length) {
            toResume[i2].resume();
            ++i2;
        }
    }

    public void setLockListener(LockListener listener) {
        this.lockListener = listener;
    }

    private static class LockState {
        private int depth;
        private OrderedLock lock;

        LockState() {
        }

        protected static LockState suspend(OrderedLock lock) {
            LockState state = new LockState();
            state.lock = lock;
            state.depth = lock.forceRelease();
            return state;
        }

        public void resume() {
            while (true) {
                try {
                    if (!this.lock.acquire(Long.MAX_VALUE)) continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            this.lock.setDepth(this.depth);
        }
    }
}

