/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.ArrayList;
import org.eclipse.core.internal.jobs.Deadlock;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

class DeadlockDetector {
    private static int NO_STATE = 0;
    private static int WAITING_FOR_LOCK = -1;
    private static final int[][] EMPTY_MATRIX = new int[0][0];
    private int[][] graph = EMPTY_MATRIX;
    private final ArrayList locks = new ArrayList();
    private final ArrayList lockThreads = new ArrayList();
    private boolean resize = false;

    DeadlockDetector() {
    }

    private boolean addCycleThreads(ArrayList deadlockedThreads, Thread next) {
        Thread[] blocking = this.blockingThreads(next);
        if (blocking.length == 0) {
            return false;
        }
        boolean inCycle = false;
        int i2 = 0;
        while (i2 < blocking.length) {
            if (deadlockedThreads.contains(blocking[i2])) {
                inCycle = true;
            } else {
                deadlockedThreads.add(blocking[i2]);
                if (this.addCycleThreads(deadlockedThreads, blocking[i2])) {
                    inCycle = true;
                } else {
                    deadlockedThreads.remove(blocking[i2]);
                }
            }
            ++i2;
        }
        return inCycle;
    }

    private Thread[] blockingThreads(Thread current) {
        ISchedulingRule lock = (ISchedulingRule)this.getWaitingLock(current);
        return this.getThreadsOwningLock(lock);
    }

    private boolean checkWaitCycles(int[] waitingThreads, int lockIndex) {
        int i2 = 0;
        while (i2 < this.graph.length) {
            if (this.graph[i2][lockIndex] > NO_STATE) {
                if (waitingThreads[i2] > NO_STATE) {
                    return true;
                }
                int n2 = i2;
                waitingThreads[n2] = waitingThreads[n2] + 1;
                int j2 = 0;
                while (j2 < this.graph[i2].length) {
                    if (this.graph[i2][j2] == WAITING_FOR_LOCK && this.checkWaitCycles(waitingThreads, j2)) {
                        return true;
                    }
                    ++j2;
                }
                int n3 = i2;
                waitingThreads[n3] = waitingThreads[n3] - 1;
            }
            ++i2;
        }
        return false;
    }

    boolean contains(Thread t2) {
        return this.lockThreads.contains(t2);
    }

    private void fillPresentEntries(ISchedulingRule newLock, int lockIndex) {
        int i2;
        int j2 = 0;
        while (j2 < this.locks.size()) {
            if (j2 != lockIndex && newLock.isConflicting((ISchedulingRule)this.locks.get(j2))) {
                i2 = 0;
                while (i2 < this.graph.length) {
                    if (this.graph[i2][j2] > NO_STATE && this.graph[i2][lockIndex] == NO_STATE) {
                        this.graph[i2][lockIndex] = this.graph[i2][j2];
                    }
                    ++i2;
                }
            }
            ++j2;
        }
        j2 = 0;
        while (j2 < this.locks.size()) {
            if (j2 != lockIndex && newLock.isConflicting((ISchedulingRule)this.locks.get(j2))) {
                i2 = 0;
                while (i2 < this.graph.length) {
                    if (this.graph[i2][lockIndex] > NO_STATE && this.graph[i2][j2] == NO_STATE) {
                        this.graph[i2][j2] = this.graph[i2][lockIndex];
                    }
                    ++i2;
                }
            }
            ++j2;
        }
    }

    private Object[] getOwnedLocks(Thread current) {
        ArrayList ownedLocks = new ArrayList(1);
        int index = this.indexOf(current, false);
        int j2 = 0;
        while (j2 < this.graph[index].length) {
            if (this.graph[index][j2] > NO_STATE) {
                ownedLocks.add(this.locks.get(j2));
            }
            ++j2;
        }
        if (ownedLocks.size() == 0) {
            Assert.isLegal(false, "A thread with no locks is part of a deadlock.");
        }
        return ownedLocks.toArray();
    }

    private Thread[] getThreadsInDeadlock(Thread cause) {
        ArrayList<Thread> deadlockedThreads = new ArrayList<Thread>(2);
        if (this.ownsLocks(cause)) {
            deadlockedThreads.add(cause);
        }
        this.addCycleThreads(deadlockedThreads, cause);
        return deadlockedThreads.toArray(new Thread[deadlockedThreads.size()]);
    }

    private Thread[] getThreadsOwningLock(ISchedulingRule rule) {
        if (rule == null) {
            return new Thread[0];
        }
        int lockIndex = this.indexOf(rule, false);
        ArrayList blocking = new ArrayList(1);
        int i2 = 0;
        while (i2 < this.graph.length) {
            if (this.graph[i2][lockIndex] > NO_STATE) {
                blocking.add(this.lockThreads.get(i2));
            }
            ++i2;
        }
        if (blocking.size() == 0 && JobManager.DEBUG_LOCKS) {
            System.out.println("Lock " + rule + " is involved in deadlock but is not owned by any thread.");
        }
        if (blocking.size() > 1 && rule instanceof ILock && JobManager.DEBUG_LOCKS) {
            System.out.println("Lock " + rule + " is owned by more than 1 thread, but it is not a rule.");
        }
        return blocking.toArray(new Thread[blocking.size()]);
    }

    private Object getWaitingLock(Thread current) {
        int index = this.indexOf(current, false);
        int j2 = 0;
        while (j2 < this.graph[index].length) {
            if (this.graph[index][j2] == WAITING_FOR_LOCK) {
                return this.locks.get(j2);
            }
            ++j2;
        }
        return null;
    }

    private int indexOf(ISchedulingRule lock, boolean add) {
        int index = this.locks.indexOf(lock);
        if (index < 0 && add) {
            this.locks.add(lock);
            this.resize = true;
            index = this.locks.size() - 1;
        }
        return index;
    }

    private int indexOf(Thread owner, boolean add) {
        int index = this.lockThreads.indexOf(owner);
        if (index < 0 && add) {
            this.lockThreads.add(owner);
            this.resize = true;
            index = this.lockThreads.size() - 1;
        }
        return index;
    }

    boolean isEmpty() {
        return this.locks.size() == 0 && this.lockThreads.size() == 0 && this.graph.length == 0;
    }

    void lockAcquired(Thread owner, ISchedulingRule lock) {
        int lockIndex = this.indexOf(lock, true);
        int threadIndex = this.indexOf(owner, true);
        if (this.resize) {
            this.resizeGraph();
        }
        if (this.graph[threadIndex][lockIndex] == WAITING_FOR_LOCK) {
            this.graph[threadIndex][lockIndex] = NO_STATE;
        }
        ArrayList<ISchedulingRule> conflicting = new ArrayList<ISchedulingRule>(1);
        int NUM_PASSES = 2;
        conflicting.add(lock);
        int[] nArray = this.graph[threadIndex];
        int n2 = lockIndex;
        nArray[n2] = nArray[n2] + 1;
        int i2 = 0;
        while (i2 < NUM_PASSES) {
            int k2 = 0;
            while (k2 < conflicting.size()) {
                ISchedulingRule current = (ISchedulingRule)conflicting.get(k2);
                int j2 = 0;
                while (j2 < this.locks.size()) {
                    ISchedulingRule possible = (ISchedulingRule)this.locks.get(j2);
                    if (current.isConflicting(possible) && !conflicting.contains(possible)) {
                        conflicting.add(possible);
                        int[] nArray2 = this.graph[threadIndex];
                        int n3 = j2;
                        nArray2[n3] = nArray2[n3] + 1;
                    }
                    ++j2;
                }
                ++k2;
            }
            ++i2;
        }
    }

    void lockReleased(Thread owner, ISchedulingRule lock) {
        int lockIndex = this.indexOf(lock, false);
        int threadIndex = this.indexOf(owner, false);
        if (threadIndex < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("[lockReleased] Lock " + lock + " was already released by thread " + owner.getName());
            }
            return;
        }
        if (lockIndex < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("[lockReleased] Thread " + owner.getName() + " already released lock " + lock);
            }
            return;
        }
        if (lock instanceof ILock && this.graph[threadIndex][lockIndex] == WAITING_FOR_LOCK) {
            this.graph[threadIndex][lockIndex] = NO_STATE;
            return;
        }
        int j2 = 0;
        while (j2 < this.graph[threadIndex].length) {
            if (lock.isConflicting((ISchedulingRule)this.locks.get(j2)) || !(lock instanceof ILock) && !(this.locks.get(j2) instanceof ILock) && this.graph[threadIndex][j2] > NO_STATE) {
                if (this.graph[threadIndex][j2] == NO_STATE) {
                    if (JobManager.DEBUG_LOCKS) {
                        System.out.println("[lockReleased] More releases than acquires for thread " + owner.getName() + " and lock " + lock);
                    }
                } else {
                    int[] nArray = this.graph[threadIndex];
                    int n2 = j2;
                    nArray[n2] = nArray[n2] - 1;
                }
            }
            ++j2;
        }
        if (this.graph[threadIndex][lockIndex] == NO_STATE) {
            this.reduceGraph(threadIndex, lock);
        }
    }

    void lockReleasedCompletely(Thread owner, ISchedulingRule rule) {
        int ruleIndex = this.indexOf(rule, false);
        int threadIndex = this.indexOf(owner, false);
        if (threadIndex < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("[lockReleasedCompletely] Lock " + rule + " was already released by thread " + owner.getName());
            }
            return;
        }
        if (ruleIndex < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("[lockReleasedCompletely] Thread " + owner.getName() + " already released lock " + rule);
            }
            return;
        }
        int j2 = 0;
        while (j2 < this.graph[threadIndex].length) {
            if (!(this.locks.get(j2) instanceof ILock) && this.graph[threadIndex][j2] > NO_STATE) {
                this.graph[threadIndex][j2] = NO_STATE;
            }
            ++j2;
        }
        this.reduceGraph(threadIndex, rule);
    }

    Deadlock lockWaitStart(Thread client, ISchedulingRule lock) {
        this.setToWait(client, lock, false);
        int lockIndex = this.indexOf(lock, false);
        int[] temp = new int[this.lockThreads.size()];
        if (!this.checkWaitCycles(temp, lockIndex)) {
            return null;
        }
        Thread[] threads = this.getThreadsInDeadlock(client);
        Thread candidate = this.resolutionCandidate(threads);
        ISchedulingRule[] locksToSuspend = this.realLocksForThread(candidate);
        Deadlock deadlock = new Deadlock(threads, locksToSuspend, candidate);
        if (JobManager.DEBUG_LOCKS) {
            this.reportDeadlock(deadlock);
        }
        if (JobManager.DEBUG_DEADLOCK) {
            throw new IllegalStateException("Deadlock detected. Caused by thread " + client.getName() + '.');
        }
        int i2 = 0;
        while (i2 < locksToSuspend.length) {
            this.setToWait(deadlock.getCandidate(), locksToSuspend[i2], true);
            ++i2;
        }
        return deadlock;
    }

    void lockWaitStop(Thread owner, ISchedulingRule lock) {
        int lockIndex = this.indexOf(lock, false);
        int threadIndex = this.indexOf(owner, false);
        if (threadIndex < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("Thread " + owner.getName() + " was already removed.");
            }
            return;
        }
        if (lockIndex < 0) {
            if (JobManager.DEBUG_LOCKS) {
                System.out.println("Lock " + lock + " was already removed.");
            }
            return;
        }
        if (this.graph[threadIndex][lockIndex] != WAITING_FOR_LOCK) {
            Assert.isTrue(false, "Thread " + owner.getName() + " was not waiting for lock " + lock.toString() + " so it could not time out.");
        }
        this.graph[threadIndex][lockIndex] = NO_STATE;
        this.reduceGraph(threadIndex, lock);
    }

    private boolean ownsLocks(Thread cause) {
        int threadIndex = this.indexOf(cause, false);
        int j2 = 0;
        while (j2 < this.graph[threadIndex].length) {
            if (this.graph[threadIndex][j2] > NO_STATE) {
                return true;
            }
            ++j2;
        }
        return false;
    }

    private boolean ownsRealLocks(Thread owner) {
        int threadIndex = this.indexOf(owner, false);
        int j2 = 0;
        while (j2 < this.graph[threadIndex].length) {
            Object lock;
            if (this.graph[threadIndex][j2] > NO_STATE && (lock = this.locks.get(j2)) instanceof ILock) {
                return true;
            }
            ++j2;
        }
        return false;
    }

    private boolean ownsRuleLocks(Thread owner) {
        int threadIndex = this.indexOf(owner, false);
        int j2 = 0;
        while (j2 < this.graph[threadIndex].length) {
            Object lock;
            if (this.graph[threadIndex][j2] > NO_STATE && !((lock = this.locks.get(j2)) instanceof ILock)) {
                return true;
            }
            ++j2;
        }
        return false;
    }

    private ISchedulingRule[] realLocksForThread(Thread owner) {
        int threadIndex = this.indexOf(owner, false);
        ArrayList ownedLocks = new ArrayList(1);
        int j2 = 0;
        while (j2 < this.graph[threadIndex].length) {
            if (this.graph[threadIndex][j2] > NO_STATE && this.locks.get(j2) instanceof ILock) {
                ownedLocks.add(this.locks.get(j2));
            }
            ++j2;
        }
        if (ownedLocks.size() == 0) {
            Assert.isLegal(false, "A thread with no real locks was chosen to resolve deadlock.");
        }
        return ownedLocks.toArray(new ISchedulingRule[ownedLocks.size()]);
    }

    /*
     * Unable to fully structure code
     */
    private void reduceGraph(int row, ISchedulingRule lock) {
        numLocks = this.locks.size();
        emptyColumns = new boolean[numLocks];
        j = 0;
        while (j < numLocks) {
            if (lock.isConflicting((ISchedulingRule)this.locks.get(j)) || !(this.locks.get(j) instanceof ILock)) {
                emptyColumns[j] = true;
            }
            ++j;
        }
        rowEmpty = true;
        numEmpty = 0;
        j = 0;
        while (j < this.graph[row].length) {
            if (this.graph[row][j] != DeadlockDetector.NO_STATE) {
                rowEmpty = false;
                break;
            }
            ++j;
        }
        j = emptyColumns.length - 1;
        while (j >= 0) {
            i = 0;
            while (i < this.graph.length) {
                if (emptyColumns[j] && this.graph[i][j] != DeadlockDetector.NO_STATE) {
                    emptyColumns[j] = false;
                    break;
                }
                ++i;
            }
            if (emptyColumns[j]) {
                this.locks.remove(j);
                ++numEmpty;
            }
            --j;
        }
        if (numEmpty == 0 && !rowEmpty) {
            return;
        }
        if (rowEmpty) {
            this.lockThreads.remove(row);
        }
        numThreads = this.lockThreads.size();
        numLocks = this.locks.size();
        if (numThreads == 0 && numLocks == 0) {
            this.graph = DeadlockDetector.EMPTY_MATRIX;
            return;
        }
        tempGraph = new int[numThreads][numLocks];
        numRowsSkipped = 0;
        i = 0;
        while (i < this.graph.length - numRowsSkipped) {
            block15: {
                block14: {
                    if (i == row && rowEmpty && i >= this.graph.length - ++numRowsSkipped) break;
                    numColsSkipped = 0;
                    j = 0;
                    break block14;
                    while (j < this.graph[i].length - ++numColsSkipped) lbl-1000:
                    // 2 sources

                    {
                        ** while (!emptyColumns[j + numColsSkipped])
lbl53:
                        // 1 sources

                    }
lbl54:
                    // 2 sources

                    if (j >= this.graph[i].length - numColsSkipped) break block15;
                    tempGraph[i][j] = this.graph[i + numRowsSkipped][j + numColsSkipped];
                    ++j;
                }
                if (j < this.graph[i].length - numColsSkipped) ** GOTO lbl-1000
            }
            ++i;
        }
        this.graph = tempGraph;
        Assert.isTrue(numThreads == this.graph.length, "Rows and threads don't match.");
        Assert.isTrue(numLocks == (this.graph.length > 0 ? this.graph[0].length : 0), "Columns and locks don't match.");
    }

    private void reportDeadlock(Deadlock deadlock) {
        String msg = "Deadlock detected. All locks owned by thread " + deadlock.getCandidate().getName() + " will be suspended.";
        MultiStatus main = new MultiStatus("org.eclipse.core.runtime", 2, msg, new IllegalStateException());
        Thread[] threads = deadlock.getThreads();
        int i2 = 0;
        while (i2 < threads.length) {
            Object[] ownedLocks = this.getOwnedLocks(threads[i2]);
            Object waitLock = this.getWaitingLock(threads[i2]);
            StringBuffer buf = new StringBuffer("Thread ");
            buf.append(threads[i2].getName());
            buf.append(" has locks: ");
            int j2 = 0;
            while (j2 < ownedLocks.length) {
                buf.append(ownedLocks[j2]);
                buf.append(j2 < ownedLocks.length - 1 ? ", " : " ");
                ++j2;
            }
            buf.append("and is waiting for lock ");
            buf.append(waitLock);
            Status child = new Status(4, "org.eclipse.core.runtime", 2, buf.toString(), null);
            main.add(child);
            ++i2;
        }
        InternalPlatform.getDefault().log(main);
    }

    private void resizeGraph() {
        int newRows = this.lockThreads.size();
        int newCols = this.locks.size();
        if (newRows == 0 && newCols == 0) {
            this.graph = EMPTY_MATRIX;
            return;
        }
        int[][] tempGraph = new int[newRows][newCols];
        int i2 = 0;
        while (i2 < this.graph.length) {
            System.arraycopy(this.graph[i2], 0, tempGraph[i2], 0, this.graph[i2].length);
            ++i2;
        }
        this.graph = tempGraph;
        this.resize = false;
    }

    private Thread resolutionCandidate(Thread[] candidates) {
        int i2 = 0;
        while (i2 < candidates.length) {
            if (!this.ownsRuleLocks(candidates[i2])) {
                return candidates[i2];
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < candidates.length) {
            if (this.ownsRealLocks(candidates[i2])) {
                return candidates[i2];
            }
            ++i2;
        }
        return candidates[0];
    }

    private void setToWait(Thread owner, ISchedulingRule lock, boolean suspend) {
        boolean needTransfer = false;
        if (!suspend && !(lock instanceof ILock)) {
            needTransfer = true;
        }
        int lockIndex = this.indexOf(lock, !suspend);
        int threadIndex = this.indexOf(owner, !suspend);
        if (this.resize) {
            this.resizeGraph();
        }
        this.graph[threadIndex][lockIndex] = WAITING_FOR_LOCK;
        if (needTransfer) {
            this.fillPresentEntries(lock, lockIndex);
        }
    }

    public void toDebugString() {
        System.out.println(" :: ");
        int j2 = 0;
        while (j2 < this.locks.size()) {
            System.out.print(" " + this.locks.get(j2) + ',');
            ++j2;
        }
        System.out.println();
        int i2 = 0;
        while (i2 < this.graph.length) {
            System.out.print(" " + ((Thread)this.lockThreads.get(i2)).getName() + " : ");
            int j3 = 0;
            while (j3 < this.graph[i2].length) {
                System.out.print(" " + this.graph[i2][j3] + ',');
                ++j3;
            }
            System.out.println();
            ++i2;
        }
        System.out.println("-------");
    }
}

