/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.events.AutoBuildJob;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.events.BuilderPersistentInfo;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.InternalBuilder;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.events.ResourceComparator;
import org.eclipse.core.internal.events.ResourceDeltaFactory;
import org.eclipse.core.internal.events.ResourceStats;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.WorkManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class BuildManager
implements ICoreConstants,
IManager,
ILifecycleListener {
    private static final int TOTAL_BUILD_WORK = 100000;
    final AutoBuildJob autoBuildJob;
    private boolean building = false;
    private final ArrayList builtProjects = new ArrayList();
    protected InternalBuilder currentBuilder;
    private DeltaDataTree currentDelta;
    private ElementTree currentTree;
    private final DeltaCache deltaCache = new DeltaCache();
    private final DeltaCache deltaTreeCache = new DeltaCache();
    private ElementTree lastBuiltTree;
    private ILock lock;
    private boolean rebuildRequested = false;
    private final Bundle systemBundle = Platform.getBundle("org.eclipse.osgi");
    private long timeStamp = -1L;
    private Workspace workspace;

    public BuildManager(Workspace workspace, ILock workspaceLock) {
        this.workspace = workspace;
        this.autoBuildJob = new AutoBuildJob(workspace);
        this.lock = workspaceLock;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void basicBuild(int trigger, IncrementalProjectBuilder builder, Map args, MultiStatus status, IProgressMonitor monitor) {
        try {
            block18: {
                block17: {
                    int depth;
                    boolean clean;
                    block16: {
                        this.currentBuilder = builder;
                        this.currentBuilder.clearForgetLastBuiltState();
                        clean = trigger == 15;
                        this.lastBuiltTree = this.currentBuilder.getLastBuiltTree();
                        if (!clean && this.lastBuiltTree == null) {
                            trigger = 6;
                        }
                        boolean fullBuild = trigger == 6;
                        this.currentTree = fullBuild ? null : this.workspace.getElementTree();
                        depth = -1;
                        try {
                            boolean needsBuild = builder.getCommand().isBuilding(trigger);
                            if (needsBuild && !clean && !fullBuild && !this.needsBuild(this.currentBuilder)) {
                                needsBuild = false;
                            }
                            if (needsBuild) break block16;
                            monitor.beginTask("", 1);
                            monitor.done();
                            Object var12_10 = null;
                            if (depth >= 0) {
                                this.getWorkManager().endUnprotected(depth);
                            }
                            if (clean || this.currentBuilder.wasForgetStateRequested()) {
                                this.currentBuilder.setLastBuiltTree(null);
                            } else {
                                ElementTree lastTree = this.workspace.getElementTree();
                                lastTree.immutable();
                                this.currentBuilder.setLastBuiltTree(lastTree);
                            }
                            this.hookEndBuild(builder);
                        }
                        catch (Throwable throwable) {
                            Object var12_11 = null;
                            if (depth >= 0) {
                                this.getWorkManager().endUnprotected(depth);
                            }
                            if (clean || this.currentBuilder.wasForgetStateRequested()) {
                                this.currentBuilder.setLastBuiltTree(null);
                            } else {
                                ElementTree lastTree = this.workspace.getElementTree();
                                lastTree.immutable();
                                this.currentBuilder.setLastBuiltTree(lastTree);
                            }
                            this.hookEndBuild(builder);
                            throw throwable;
                        }
                        Object var15_16 = null;
                        this.currentBuilder = null;
                        this.currentTree = null;
                        this.lastBuiltTree = null;
                        this.currentDelta = null;
                        return;
                    }
                    String name = this.currentBuilder.getLabel();
                    String message = name != null ? NLS.bind(Messages.events_invoking_2, name, builder.getProject().getFullPath()) : NLS.bind(Messages.events_invoking_1, builder.getProject().getFullPath());
                    monitor.subTask(message);
                    this.hookStartBuild(builder, trigger);
                    depth = this.getWorkManager().beginUnprotected();
                    Platform.run(this.getSafeRunnable(trigger, args, status, monitor));
                    Object var12_12 = null;
                    if (depth >= 0) {
                        this.getWorkManager().endUnprotected(depth);
                    }
                    if (!clean && !this.currentBuilder.wasForgetStateRequested()) break block17;
                    this.currentBuilder.setLastBuiltTree(null);
                    break block18;
                }
                ElementTree lastTree = this.workspace.getElementTree();
                lastTree.immutable();
                this.currentBuilder.setLastBuiltTree(lastTree);
            }
            this.hookEndBuild(builder);
            Object var15_18 = null;
            this.currentBuilder = null;
            this.currentTree = null;
            this.lastBuiltTree = null;
            this.currentDelta = null;
            return;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            this.currentBuilder = null;
            this.currentTree = null;
            this.lastBuiltTree = null;
            this.currentDelta = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void basicBuild(IProject project, int trigger, ICommand[] commands, MultiStatus status, IProgressMonitor monitor) {
        monitor = Policy.monitorFor(monitor);
        try {
            try {
                String message = NLS.bind(Messages.events_building_1, project.getFullPath());
                monitor.beginTask(message, Math.max(1, commands.length));
                int i2 = 0;
                while (i2 < commands.length) {
                    this.checkCanceled(trigger, monitor);
                    BuildCommand command = (BuildCommand)commands[i2];
                    IProgressMonitor sub = Policy.subMonitorFor(monitor, 1);
                    IncrementalProjectBuilder builder = this.getBuilder(project, command, i2, status);
                    if (builder != null) {
                        this.basicBuild(trigger, builder, command.getArguments(false), status, sub);
                    }
                    ++i2;
                }
            }
            catch (CoreException e2) {
                status.add(e2.getStatus());
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var11_14 = null;
            monitor.done();
            return;
        }
    }

    private void basicBuild(final IProject project, final int trigger, final MultiStatus status, final IProgressMonitor monitor) {
        if (!project.isAccessible()) {
            return;
        }
        final ICommand[] commands = ((Project)project).internalGetDescription().getBuildSpec(false);
        if (commands.length == 0) {
            return;
        }
        ISafeRunnable code = new ISafeRunnable(){

            public void handleException(Throwable e2) {
                if (e2 instanceof OperationCanceledException) {
                    throw (OperationCanceledException)e2;
                }
                String message = e2.getMessage();
                if (message == null) {
                    message = NLS.bind(Messages.events_unknown, e2.getClass().getName(), project.getName());
                }
                status.add(new Status(2, "org.eclipse.core.resources", 566, message, e2));
            }

            public void run() throws Exception {
                BuildManager.this.basicBuild(project, trigger, commands, status, monitor);
            }
        };
        Platform.run(code);
    }

    private void basicBuildLoop(IProject[] ordered, IProject[] unordered, int trigger, MultiStatus status, IProgressMonitor monitor) {
        int maxIterations;
        int projectWork = ordered.length + unordered.length;
        if (projectWork > 0) {
            projectWork = 100000 / projectWork;
        }
        if ((maxIterations = this.workspace.getDescription().getMaxBuildIterations()) <= 0) {
            maxIterations = 1;
        }
        this.rebuildRequested = true;
        int iter = 0;
        while (this.rebuildRequested && iter < maxIterations) {
            this.rebuildRequested = false;
            this.builtProjects.clear();
            int i2 = 0;
            while (i2 < ordered.length) {
                if (ordered[i2].isAccessible()) {
                    this.basicBuild(ordered[i2], trigger, status, Policy.subMonitorFor(monitor, projectWork));
                    this.builtProjects.add(ordered[i2]);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < unordered.length) {
                if (unordered[i2].isAccessible()) {
                    this.basicBuild(unordered[i2], trigger, status, Policy.subMonitorFor(monitor, projectWork));
                    this.builtProjects.add(unordered[i2]);
                }
                ++i2;
            }
            trigger = 10;
            ++iter;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(int trigger, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(Messages.events_building_0, 100000);
            if (!this.canRun(trigger)) {
                Object var9_3 = null;
                monitor.done();
                if (trigger != 10) {
                    if (trigger != 6) return;
                }
                this.autoBuildJob.avoidBuild();
                return;
            }
            try {
                this.hookStartBuild(trigger);
                IProject[] ordered = this.workspace.getBuildOrder();
                HashSet<IProject> leftover = new HashSet<IProject>(Arrays.asList(this.workspace.getRoot().getProjects()));
                leftover.removeAll(Arrays.asList(ordered));
                IProject[] unordered = leftover.toArray(new IProject[leftover.size()]);
                MultiStatus status = new MultiStatus("org.eclipse.core.resources", 75, Messages.events_errors, null);
                this.basicBuildLoop(ordered, unordered, trigger, status, monitor);
                if (!status.isOK()) {
                    throw new ResourceException(status);
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                this.hookEndBuild(trigger);
                throw throwable;
            }
            {
                Object var7_12 = null;
                this.hookEndBuild(trigger);
            }
        }
        catch (Throwable throwable) {
            Object var9_4 = null;
            monitor.done();
            if (trigger != 10) {
                if (trigger != 6) throw throwable;
            }
            this.autoBuildJob.avoidBuild();
            throw throwable;
        }
        {
            Object var9_5 = null;
            monitor.done();
            if (trigger != 10) {
                if (trigger != 6) return;
            }
            this.autoBuildJob.avoidBuild();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(IProject project, int trigger, IProgressMonitor monitor) throws CoreException {
        if (!this.canRun(trigger)) {
            return;
        }
        try {
            this.hookStartBuild(trigger);
            MultiStatus status = new MultiStatus("org.eclipse.core.resources", 566, Messages.events_errors, null);
            this.basicBuild(project, trigger, status, monitor);
            if (!status.isOK()) {
                throw new ResourceException(status);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.hookEndBuild(trigger);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.hookEndBuild(trigger);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(IProject project, int trigger, String builderName, Map args, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = NLS.bind(Messages.events_building_1, project.getFullPath());
            monitor.beginTask(message, 1);
            if (!this.canRun(trigger)) {
                Object var12_7 = null;
                monitor.done();
                return;
            }
            try {
                this.hookStartBuild(trigger);
                MultiStatus status = new MultiStatus("org.eclipse.core.resources", 566, Messages.events_errors, null);
                ICommand command = this.getCommand(project, builderName, args);
                IncrementalProjectBuilder builder = this.getBuilder(project, command, -1, status);
                if (builder != null) {
                    this.basicBuild(trigger, builder, args, status, Policy.subMonitorFor(monitor, 1));
                }
                if (!status.isOK()) {
                    throw new ResourceException(status);
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                this.hookEndBuild(trigger);
                throw throwable;
            }
            {
                Object var10_15 = null;
                this.hookEndBuild(trigger);
            }
        }
        catch (Throwable throwable) {
            Object var12_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var12_9 = null;
            monitor.done();
            return;
        }
    }

    private boolean canRun(int trigger) {
        return !this.building;
    }

    private void checkCanceled(int trigger, IProgressMonitor monitor) {
        if (this.systemBundle.getState() == 16) {
            throw new OperationCanceledException();
        }
        Policy.checkCanceled(monitor);
        if (trigger != 9) {
            return;
        }
        if (this.autoBuildJob.isInterrupted()) {
            throw new OperationCanceledException();
        }
    }

    public ArrayList createBuildersPersistentInfo(IProject project) throws CoreException {
        ArrayList oldInfos = this.getBuildersPersistentInfo(project);
        ICommand[] commands = ((Project)project).internalGetDescription().getBuildSpec(false);
        if (commands.length == 0) {
            return null;
        }
        ArrayList<BuilderPersistentInfo> newInfos = new ArrayList<BuilderPersistentInfo>(commands.length);
        int i2 = 0;
        while (i2 < commands.length) {
            ElementTree oldTree;
            String builderName = commands[i2].getBuilderName();
            BuilderPersistentInfo info = null;
            IncrementalProjectBuilder builder = ((BuildCommand)commands[i2]).getBuilder();
            if (builder == null) {
                if (oldInfos != null) {
                    info = this.getBuilderInfo(oldInfos, builderName, i2);
                }
            } else if (!(builder instanceof MissingBuilder) && (oldTree = builder.getLastBuiltTree()) != null) {
                info = new BuilderPersistentInfo(project.getName(), builderName, i2);
                info.setLastBuildTree(oldTree);
                info.setInterestingProjects(builder.getInterestingProjects());
            }
            if (info != null) {
                newInfos.add(info);
            }
            ++i2;
        }
        return newInfos;
    }

    private String debugBuilder() {
        return this.currentBuilder == null ? "<no builder>" : this.currentBuilder.getClass().getName();
    }

    private String debugProject() {
        if (this.currentBuilder == null) {
            return "<no project>";
        }
        return this.currentBuilder.getProject().getFullPath().toString();
    }

    private String debugTrigger(int trigger) {
        switch (trigger) {
            case 6: {
                return "FULL_BUILD";
            }
            case 15: {
                return "CLEAN_BUILD";
            }
        }
        return "INCREMENTAL_BUILD";
    }

    public void endTopLevel(boolean needsBuild) {
        this.autoBuildJob.build(needsBuild);
    }

    private IncrementalProjectBuilder getBuilder(IProject project, ICommand command, int buildSpecIndex, MultiStatus status) throws CoreException {
        IncrementalProjectBuilder result = ((BuildCommand)command).getBuilder();
        if (result == null) {
            result = this.initializeBuilder(command.getBuilderName(), project, buildSpecIndex, status);
            ((BuildCommand)command).setBuilder(result);
            result.setCommand(command);
            result.setProject(project);
            ((InternalBuilder)result).startupOnInitialize();
        }
        if (!this.validateNature(result, command.getBuilderName())) {
            result.setLastBuiltTree(null);
            return null;
        }
        return result;
    }

    private BuilderPersistentInfo getBuilderInfo(ArrayList infos, String builderName, int buildSpecIndex) {
        BuilderPersistentInfo nameMatch = null;
        Iterator it = infos.iterator();
        while (it.hasNext()) {
            BuilderPersistentInfo info = (BuilderPersistentInfo)it.next();
            if (!info.getBuilderName().equals(builderName)) continue;
            if (nameMatch == null) {
                nameMatch = info;
            }
            if (buildSpecIndex != -1 && info.getBuildSpecIndex() != -1 && buildSpecIndex != info.getBuildSpecIndex()) continue;
            return info;
        }
        return nameMatch;
    }

    public ArrayList getBuildersPersistentInfo(IProject project) throws CoreException {
        return (ArrayList)project.getSessionProperty(K_BUILD_LIST);
    }

    private ICommand getCommand(IProject project, String builderName, Map args) {
        ICommand[] buildSpec = ((Project)project).internalGetDescription().getBuildSpec(false);
        int i2 = 0;
        while (i2 < buildSpec.length) {
            if (buildSpec[i2].getBuilderName().equals(builderName)) {
                return buildSpec[i2];
            }
            ++i2;
        }
        BuildCommand result = new BuildCommand();
        result.setBuilderName(builderName);
        result.setArguments(args);
        return result;
    }

    IResourceDelta getDelta(IProject project) {
        IResourceDelta result;
        block16: {
            block14: {
                block15: {
                    block13: {
                        block12: {
                            try {
                                this.lock.acquire();
                                if (this.currentTree != null) break block12;
                                if (Policy.DEBUG_BUILD_FAILURE) {
                                    Policy.debug("Build: no tree for delta " + this.debugBuilder() + " [" + this.debugProject() + "]");
                                }
                                IResourceDelta iResourceDelta = null;
                                Object var5_8 = null;
                                this.lock.release();
                                return iResourceDelta;
                            }
                            catch (Throwable throwable) {
                                Object var5_14 = null;
                                this.lock.release();
                                throw throwable;
                            }
                        }
                        if (this.isInterestingProject(project)) break block13;
                        if (Policy.DEBUG_BUILD_FAILURE) {
                            Policy.debug("Build: project not interesting for this builder " + this.debugBuilder() + " [" + this.debugProject() + "] " + project.getFullPath());
                        }
                        IResourceDelta iResourceDelta = null;
                        Object var5_9 = null;
                        this.lock.release();
                        return iResourceDelta;
                    }
                    if (this.currentDelta == null || this.currentDelta.findNodeAt(project.getFullPath()) != null) break block14;
                    if (project.exists()) break block15;
                    IResourceDelta iResourceDelta = null;
                    Object var5_10 = null;
                    this.lock.release();
                    return iResourceDelta;
                }
                IResourceDelta iResourceDelta = ResourceDeltaFactory.newEmptyDelta(project);
                Object var5_11 = null;
                this.lock.release();
                return iResourceDelta;
            }
            result = (IResourceDelta)this.deltaCache.getDelta(project.getFullPath(), this.lastBuiltTree, this.currentTree);
            if (result == null) break block16;
            IResourceDelta iResourceDelta = result;
            Object var5_12 = null;
            this.lock.release();
            return iResourceDelta;
        }
        long startTime = 0L;
        if (Policy.DEBUG_BUILD_DELTA) {
            startTime = System.currentTimeMillis();
            Policy.debug("Computing delta for project: " + project.getName());
        }
        result = ResourceDeltaFactory.computeDelta(this.workspace, this.lastBuiltTree, this.currentTree, project.getFullPath(), -1L);
        this.deltaCache.cache(project.getFullPath(), this.lastBuiltTree, this.currentTree, result);
        if (Policy.DEBUG_BUILD_FAILURE && result == null) {
            Policy.debug("Build: no delta " + this.debugBuilder() + " [" + this.debugProject() + "] " + project.getFullPath());
        }
        if (Policy.DEBUG_BUILD_DELTA) {
            Policy.debug("Finished computing delta, time: " + (System.currentTimeMillis() - startTime) + "ms");
        }
        IResourceDelta iResourceDelta = result;
        Object var5_13 = null;
        this.lock.release();
        return iResourceDelta;
    }

    private ISafeRunnable getSafeRunnable(final int trigger, final Map args, final MultiStatus status, final IProgressMonitor monitor) {
        return new ISafeRunnable(){

            public void handleException(Throwable e2) {
                if (e2 instanceof OperationCanceledException) {
                    BuildManager.this.currentBuilder.forgetLastBuiltState();
                    throw (OperationCanceledException)e2;
                }
                String builderName = BuildManager.this.currentBuilder.getLabel();
                if (builderName == null || builderName.length() == 0) {
                    builderName = BuildManager.this.currentBuilder.getClass().getName();
                }
                String pluginId = BuildManager.this.currentBuilder.getPluginId();
                String message = NLS.bind(Messages.events_builderError, builderName, BuildManager.this.currentBuilder.getProject().getName());
                status.add(new Status(2, pluginId, 75, message, null));
                if (e2 instanceof CoreException) {
                    status.add(((CoreException)e2).getStatus());
                } else {
                    message = e2.getMessage();
                    if (message == null) {
                        message = NLS.bind(Messages.events_unknown, e2.getClass().getName(), builderName);
                    }
                    status.add(new Status(2, pluginId, 75, message, e2));
                }
            }

            public void run() throws Exception {
                IProject[] prereqs = null;
                if (trigger != 15) {
                    prereqs = BuildManager.this.currentBuilder.build(trigger, args, monitor);
                } else {
                    BuildManager.this.currentBuilder.clean(monitor);
                }
                if (prereqs == null) {
                    prereqs = new IProject[]{};
                }
                BuildManager.this.currentBuilder.setInterestingProjects((IProject[])prereqs.clone());
            }
        };
    }

    private WorkManager getWorkManager() {
        try {
            return this.workspace.getWorkManager();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public void handleEvent(LifecycleEvent event) {
        IProject project = null;
        switch (event.kind) {
            case 16: 
            case 64: {
                project = (IProject)event.resource;
                if (!project.isAccessible()) break;
                this.setBuildersPersistentInfo(project, null);
            }
        }
    }

    boolean hasBeenBuilt(IProject project) {
        return this.builtProjects.contains(project);
    }

    private void hookEndBuild(IncrementalProjectBuilder builder) {
        if (ResourceStats.TRACE_BUILDERS) {
            ResourceStats.endBuild();
        }
        if (!Policy.DEBUG_BUILD_INVOKING || this.timeStamp == -1L) {
            return;
        }
        Policy.debug("Builder finished: " + this.toString(builder) + " time: " + (System.currentTimeMillis() - this.timeStamp) + "ms");
        this.timeStamp = -1L;
    }

    private void hookEndBuild(int trigger) {
        this.building = false;
        this.builtProjects.clear();
        this.deltaCache.flush();
        this.deltaTreeCache.flush();
        if (trigger == 15) {
            this.autoBuildJob.forceBuild();
        }
    }

    private void hookStartBuild(IncrementalProjectBuilder builder, int trigger) {
        if (ResourceStats.TRACE_BUILDERS) {
            ResourceStats.startBuild(builder);
        }
        if (Policy.DEBUG_BUILD_INVOKING) {
            this.timeStamp = System.currentTimeMillis();
            Policy.debug("Invoking (" + this.debugTrigger(trigger) + ") on builder: " + this.toString(builder));
        }
    }

    private void hookStartBuild(int trigger) {
        this.building = true;
        if (Policy.DEBUG_BUILD_STACK) {
            Status info = new Status(1, "org.eclipse.core.resources", 1, "Starting build: " + this.debugTrigger(trigger), new RuntimeException().fillInStackTrace());
            ResourcesPlugin.getPlugin().getLog().log(info);
        }
    }

    private IncrementalProjectBuilder initializeBuilder(String builderName, IProject project, int buildSpecIndex, MultiStatus status) throws CoreException {
        ArrayList infos;
        IncrementalProjectBuilder builder = null;
        try {
            builder = this.instantiateBuilder(builderName);
        }
        catch (CoreException e2) {
            status.add(new ResourceStatus(75, project.getFullPath(), NLS.bind(Messages.events_instantiate_1, builderName), e2));
            status.add(e2.getStatus());
        }
        if (builder == null) {
            builder = new MissingBuilder(builderName);
        }
        if ((infos = this.getBuildersPersistentInfo(project)) != null) {
            BuilderPersistentInfo info = this.getBuilderInfo(infos, builderName, buildSpecIndex);
            if (info != null) {
                infos.remove(info);
                ElementTree tree = info.getLastBuiltTree();
                if (tree != null) {
                    builder.setLastBuiltTree(tree);
                }
                builder.setInterestingProjects(info.getInterestingProjects());
            }
            if (infos.size() == 0) {
                this.setBuildersPersistentInfo(project, null);
            }
        }
        return builder;
    }

    private IncrementalProjectBuilder instantiateBuilder(String builderName) throws CoreException {
        IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.resources", "builders", builderName);
        if (extension == null) {
            return null;
        }
        IConfigurationElement[] configs = extension.getConfigurationElements();
        if (configs.length == 0) {
            return null;
        }
        String hasNature = configs[0].getAttribute("hasNature");
        String natureId = null;
        if (hasNature != null && hasNature.equalsIgnoreCase(Boolean.TRUE.toString())) {
            String builderId = extension.getUniqueIdentifier();
            natureId = this.workspace.getNatureManager().findNatureForBuilder(builderId);
            if (natureId == null) {
                return null;
            }
        }
        InternalBuilder builder = (InternalBuilder)configs[0].createExecutableExtension("run");
        builder.setPluginId(extension.getNamespace());
        builder.setLabel(extension.getLabel());
        builder.setNatureId(natureId);
        return (IncrementalProjectBuilder)builder;
    }

    public void interrupt() {
        this.autoBuildJob.interrupt();
    }

    private boolean isInterestingProject(IProject project) {
        if (project.equals(this.currentBuilder.getProject())) {
            return true;
        }
        IProject[] interestingProjects = this.currentBuilder.getInterestingProjects();
        int i2 = 0;
        while (i2 < interestingProjects.length) {
            if (interestingProjects[i2].equals(project)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private boolean needsBuild(InternalBuilder builder) {
        ElementTree oldTree = builder.getLastBuiltTree();
        ElementTree newTree = this.workspace.getElementTree();
        long start = System.currentTimeMillis();
        this.currentDelta = (DeltaDataTree)this.deltaTreeCache.getDelta(null, oldTree, newTree);
        if (this.currentDelta == null) {
            if (Policy.DEBUG_NEEDS_BUILD) {
                String message = "Checking if need to build. Starting delta computation between: " + oldTree.toString() + " and " + newTree.toString();
                Policy.debug(message);
            }
            this.currentDelta = newTree.getDataTree().forwardDeltaWith(oldTree.getDataTree(), ResourceComparator.getBuildComparator());
            if (Policy.DEBUG_NEEDS_BUILD) {
                Policy.debug("End delta computation. (" + (System.currentTimeMillis() - start) + "ms).");
            }
            this.deltaTreeCache.cache(null, oldTree, newTree, this.currentDelta);
        }
        if (this.currentDelta.findNodeAt(builder.getProject().getFullPath()) != null) {
            if (Policy.DEBUG_NEEDS_BUILD) {
                Policy.debug(String.valueOf(this.toString(builder)) + " needs building because of changes in: " + builder.getProject().getName());
            }
            return true;
        }
        IProject[] projects = builder.getInterestingProjects();
        int i2 = 0;
        while (i2 < projects.length) {
            if (this.currentDelta.findNodeAt(projects[i2].getFullPath()) != null) {
                if (Policy.DEBUG_NEEDS_BUILD) {
                    Policy.debug(String.valueOf(this.toString(builder)) + " needs building because of changes in: " + projects[i2].getName());
                }
                return true;
            }
            ++i2;
        }
        return false;
    }

    private void removeBuilders(IProject project, String builderId) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] oldSpec = desc.getBuildSpec();
        int oldLength = oldSpec.length;
        if (oldLength == 0) {
            return;
        }
        int remaining = 0;
        int i2 = 0;
        while (i2 < oldSpec.length) {
            if (oldSpec[i2].getBuilderName().equals(builderId)) {
                oldSpec[i2] = null;
            } else {
                ++remaining;
            }
            ++i2;
        }
        if (remaining == oldSpec.length) {
            return;
        }
        ICommand[] newSpec = new ICommand[remaining];
        int i3 = 0;
        int newIndex = 0;
        while (i3 < oldLength) {
            if (oldSpec[i3] != null) {
                newSpec[newIndex++] = oldSpec[i3];
            }
            ++i3;
        }
        desc.setBuildSpec(newSpec);
        project.setDescription(desc, 0, null);
    }

    void requestRebuild() {
        this.rebuildRequested = true;
    }

    public void setBuildersPersistentInfo(IProject project, ArrayList list) {
        try {
            project.setSessionProperty(K_BUILD_LIST, list);
        }
        catch (CoreException coreException) {
            ResourceStatus error = new ResourceStatus(4, 1, project.getFullPath(), "Project missing in setBuildersPersistentInfo", null);
            ResourcesPlugin.getPlugin().getLog().log(error);
        }
    }

    public void shutdown(IProgressMonitor monitor) {
        this.autoBuildJob.cancel();
    }

    public void startup(IProgressMonitor monitor) {
        this.workspace.addLifecycleListener(this);
    }

    private String toString(InternalBuilder builder) {
        String name = builder.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        return String.valueOf(name) + "(" + builder.getProject().getName() + ")";
    }

    private boolean validateNature(InternalBuilder builder, String builderId) throws CoreException {
        String nature = builder.getNatureId();
        if (nature == null) {
            return true;
        }
        IProject project = builder.getProject();
        if (!project.hasNature(nature)) {
            this.removeBuilders(project, builderId);
            return false;
        }
        return project.isNatureEnabled(nature);
    }

    class DeltaCache {
        private Object delta;
        private ElementTree newTree;
        private ElementTree oldTree;
        private IPath projectPath;

        DeltaCache() {
        }

        public void cache(IPath project, ElementTree anOldTree, ElementTree aNewTree, Object aDelta) {
            this.projectPath = project;
            this.oldTree = anOldTree;
            this.newTree = aNewTree;
            this.delta = aDelta;
        }

        public void flush() {
            this.projectPath = null;
            this.oldTree = null;
            this.newTree = null;
            this.delta = null;
        }

        public Object getDelta(IPath project, ElementTree anOldTree, ElementTree aNewTree) {
            boolean pathsEqual;
            if (this.delta == null) {
                return null;
            }
            boolean bl = this.projectPath == null ? project == null : (pathsEqual = this.projectPath.equals(project));
            if (pathsEqual && this.oldTree == anOldTree && this.newTree == aNewTree) {
                return this.delta;
            }
            return null;
        }
    }

    class MissingBuilder
    extends IncrementalProjectBuilder {
        private boolean hasBeenBuilt = false;
        private String name;

        MissingBuilder(String name) {
            this.name = name;
        }

        protected IProject[] build(int kind, Map args, IProgressMonitor monitor) {
            if (!this.hasBeenBuilt) {
                this.hasBeenBuilt = true;
                String msg = NLS.bind(Messages.events_skippingBuilder, this.name, this.getProject().getName());
                Status status = new Status(2, "org.eclipse.core.resources", 1, msg, null);
                ResourcesPlugin.getPlugin().getLog().log(status);
            }
            return null;
        }
    }
}

