/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.bridge;

import java.io.File;
import java.io.Serializable;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.util.LangUtil;

public class SourceLocation
implements ISourceLocation,
Serializable {
    public static final ISourceLocation UNKNOWN = new SourceLocation(ISourceLocation.NO_FILE, 0, 0, 0);
    private final File sourceFile;
    private final int startLine;
    private final int column;
    private final int endLine;
    private int offset;
    private final String context;
    private boolean noColumn;

    public static final void validLine(int line) {
        if (line < 0) {
            throw new IllegalArgumentException("negative line: " + line);
        }
        if (line > 0x3FFFFFFF) {
            throw new IllegalArgumentException("line too large: " + line);
        }
    }

    public static final void validColumn(int column) {
        if (column < 0) {
            throw new IllegalArgumentException("negative column: " + column);
        }
        if (column > 0x3FFFFFFF) {
            throw new IllegalArgumentException("column too large: " + column);
        }
    }

    public SourceLocation(File file, int line) {
        this(file, line, line, -2147483647);
    }

    public SourceLocation(File file, int line, int endLine) {
        this(file, line, endLine, -2147483647);
    }

    public SourceLocation(File file, int line, int endLine, int column) {
        this(file, line, endLine, column, null);
    }

    public SourceLocation(File file, int line, int endLine, int column, String context) {
        if (column == -2147483647) {
            column = 0;
            this.noColumn = true;
        }
        if (null == file) {
            file = ISourceLocation.NO_FILE;
        }
        SourceLocation.validLine(line);
        SourceLocation.validLine(endLine);
        LangUtil.throwIaxIfFalse(line <= endLine, line + " > " + endLine);
        LangUtil.throwIaxIfFalse(column >= 0, "negative column: " + column);
        this.sourceFile = file;
        this.startLine = line;
        this.column = column;
        this.endLine = endLine;
        this.context = context;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public int getLine() {
        return this.startLine;
    }

    public int getColumn() {
        return this.column;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public String getContext() {
        return this.context;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (null != this.context) {
            sb.append(this.context);
            sb.append(LangUtil.EOL);
        }
        if (this.sourceFile != ISourceLocation.NO_FILE) {
            sb.append(this.sourceFile.getPath());
        }
        if (this.startLine > 0) {
            sb.append(":");
            sb.append(this.startLine);
        }
        if (!this.noColumn) {
            sb.append(":" + this.column);
        }
        if (this.offset >= 0) {
            sb.append("::" + this.offset);
        }
        return sb.toString();
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int i2) {
        this.offset = i2;
    }
}

