/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.MonthDurationValue;
import net.sf.saxon.value.RestrictedStringValue;
import net.sf.saxon.value.SecondsDurationValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;

public class StringValue
extends AtomicValue {
    public static final StringValue EMPTY_STRING = new StringValue("");
    public static final StringValue SINGLE_SPACE = new StringValue(" ");
    protected CharSequence value;
    protected int length = -1;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$StringValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;

    protected StringValue() {
        this.value = "";
    }

    public StringValue(CharSequence charSequence) {
        this.value = charSequence == null ? "" : charSequence;
    }

    public static StringValue makeStringValue(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0) {
            return EMPTY_STRING;
        }
        return new StringValue(charSequence);
    }

    public final String getStringValue() {
        this.value = ((Object)this.value).toString();
        return this.value;
    }

    public final CharSequence getStringValueCS() {
        return this.value;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        int n2 = builtInAtomicType.getFingerprint();
        if (n2 == 513 || n2 == 643 || n2 == 88) {
            return this;
        }
        return StringValue.convertStringToBuiltInType(this.value, builtInAtomicType, bl ? xPathContext.getConfiguration().getNameChecker() : null);
    }

    public static AtomicValue convertStringToBuiltInType(CharSequence charSequence, BuiltInAtomicType builtInAtomicType, NameChecker nameChecker) {
        try {
            switch (builtInAtomicType.getFingerprint()) {
                case 514: {
                    return BooleanValue.fromString(charSequence);
                }
                case 517: 
                case 646: {
                    return new DoubleValue(charSequence);
                }
                case 532: {
                    return IntegerValue.stringToInteger(charSequence);
                }
                case 541: 
                case 542: 
                case 543: 
                case 544: {
                    if (nameChecker != null) {
                        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                            if (charSequence.charAt(i2) != '+') continue;
                            ValidationException validationException = new ValidationException("An unsigned number must not contain a plus sign");
                            return new ValidationErrorValue(validationException);
                        }
                    }
                }
                case 533: 
                case 534: 
                case 535: 
                case 536: 
                case 537: 
                case 538: 
                case 539: 
                case 540: {
                    AtomicValue atomicValue = IntegerValue.stringToInteger(charSequence);
                    if (atomicValue instanceof ValidationErrorValue) {
                        return atomicValue;
                    }
                    ValidationException validationException = atomicValue instanceof IntegerValue ? ((IntegerValue)atomicValue).convertToSubtype(builtInAtomicType, nameChecker != null) : ((BigIntegerValue)atomicValue).convertToSubType(builtInAtomicType, nameChecker != null);
                    return validationException == null ? atomicValue : new ValidationErrorValue(validationException);
                }
                case 515: {
                    return DecimalValue.makeDecimalValue(charSequence, nameChecker != null);
                }
                case 516: {
                    return new FloatValue(charSequence);
                }
                case 521: {
                    return new DateValue(charSequence);
                }
                case 519: {
                    return new DateTimeValue(charSequence);
                }
                case 520: {
                    return new TimeValue(charSequence);
                }
                case 523: {
                    return new GYearValue(charSequence);
                }
                case 522: {
                    return new GYearMonthValue(charSequence);
                }
                case 526: {
                    return new GMonthValue(charSequence);
                }
                case 524: {
                    return new GMonthDayValue(charSequence);
                }
                case 525: {
                    return new GDayValue(charSequence);
                }
                case 518: {
                    return new DurationValue(charSequence);
                }
                case 644: {
                    return new MonthDurationValue(charSequence);
                }
                case 645: {
                    return new SecondsDurationValue(charSequence);
                }
                case 573: 
                case 642: {
                    return new UntypedAtomicValue(charSequence);
                }
                case 88: 
                case 513: 
                case 643: {
                    return StringValue.makeStringValue(charSequence);
                }
                case 553: 
                case 554: 
                case 555: 
                case 556: 
                case 558: 
                case 559: 
                case 560: 
                case 561: 
                case 563: {
                    return RestrictedStringValue.makeRestrictedString(charSequence, builtInAtomicType.getFingerprint(), nameChecker);
                }
                case 529: {
                    if (AnyURIValue.isValidURI(charSequence)) {
                        return new AnyURIValue(charSequence);
                    }
                    throw new ValidationException("Invalid URI: " + ((Object)charSequence).toString());
                }
                case 527: {
                    return new HexBinaryValue(charSequence);
                }
                case 528: {
                    return new Base64BinaryValue(charSequence);
                }
            }
            ValidationException validationException = new ValidationException("Cannot convert string to type " + Err.wrap(builtInAtomicType.getDisplayName()));
            validationException.setErrorCode("XPTY0004");
            validationException.setIsTypeError(true);
            throw validationException;
        }
        catch (ValidationException validationException) {
            if (validationException.getErrorCodeLocalPart() == null) {
                validationException.setErrorCode("FORG0001");
            }
            return new ValidationErrorValue(validationException);
        }
        catch (XPathException xPathException) {
            if (xPathException.getErrorCodeLocalPart() == null) {
                xPathException.setErrorCode("FORG0001");
            }
            ValidationException validationException = new ValidationException(xPathException.getMessage());
            if (xPathException.getErrorCodeLocalPart() == null) {
                validationException.setErrorCode("FORG0001");
            } else {
                validationException.setErrorCode(xPathException.getErrorCodeLocalPart());
            }
            return new ValidationErrorValue(validationException);
        }
    }

    public static AtomicValue convertStringToAtomicType(CharSequence charSequence, AtomicType atomicType, NameChecker nameChecker) {
        if (atomicType instanceof BuiltInAtomicType) {
            return StringValue.convertStringToBuiltInType(charSequence, (BuiltInAtomicType)atomicType, nameChecker);
        }
        AtomicValue atomicValue = StringValue.convertStringToBuiltInType(charSequence, (BuiltInAtomicType)atomicType.getPrimitiveItemType(), nameChecker);
        if (atomicValue instanceof ValidationErrorValue) {
            return atomicValue;
        }
        return atomicType.makeDerivedValue(atomicValue, charSequence, nameChecker != null);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.STRING_TYPE;
    }

    public int getStringLength() {
        if (this.length == -1) {
            this.length = StringValue.getStringLength(this.value);
        }
        return this.length;
    }

    public static int getStringLength(CharSequence charSequence) {
        int n2 = 0;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 >= '\ud800' && c2 <= '\udbff') continue;
            ++n2;
        }
        return n2;
    }

    public SequenceIterator iterateCharacters() {
        return new CharacterIterator();
    }

    public static int[] expand(CharSequence charSequence) {
        int[] nArray = new int[StringValue.getStringLength(charSequence)];
        int n2 = 0;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            int n3;
            int n4 = charSequence.charAt(i2);
            if (n4 >= 55296 && n4 <= 56319) {
                n3 = (n4 - 55296) * 1024 + (charSequence.charAt(i2 + 1) - 56320) + 65536;
                ++i2;
            } else {
                n3 = n4;
            }
            nArray[n2++] = n3;
        }
        return nArray;
    }

    public static CharSequence contract(int[] nArray, int n2) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(nArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] < 65536) {
                fastStringBuffer.append((char)nArray[i2]);
                continue;
            }
            fastStringBuffer.append(XMLChar.highSurrogate(nArray[i2]));
            fastStringBuffer.append(XMLChar.lowSurrogate(nArray[i2]));
        }
        return fastStringBuffer;
    }

    public boolean equals(Object object) {
        if (object instanceof AnyURIValue) {
            throw new ClassCastException("Cannot compare string to anyURI");
        }
        StringValue stringValue = (StringValue)((AtomicValue)object).getPrimitiveValue();
        return this.getStringValue().equals(stringValue.getStringValue());
    }

    public int hashCode() {
        return this.getStringValue().hashCode();
    }

    public boolean schemaEquals(Value value) {
        if (value instanceof AtomicValue) {
            value = ((AtomicValue)value).getPrimitiveValue();
        }
        if (value instanceof StringValue) {
            return ((Object)this.value).toString().equals(((Object)((StringValue)value).value).toString());
        }
        return false;
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        return this.value.length() > 0;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = StringValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.value;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$StringValue == null ? (class$net$sf$saxon$value$StringValue = StringValue.class$("net.sf.saxon.value.StringValue")) : class$net$sf$saxon$value$StringValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = StringValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = StringValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == Boolean.TYPE) {
            BooleanValue booleanValue = (BooleanValue)this.convert(514, xPathContext);
            return booleanValue.getBooleanValue();
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = StringValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            BooleanValue booleanValue = (BooleanValue)this.convert(514, xPathContext);
            return booleanValue.getBooleanValue();
        }
        if (clazz == Double.TYPE) {
            DoubleValue doubleValue = (DoubleValue)this.convert(517, xPathContext);
            return new Double(doubleValue.getDoubleValue());
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = StringValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            DoubleValue doubleValue = (DoubleValue)this.convert(517, xPathContext);
            return new Double(doubleValue.getDoubleValue());
        }
        if (clazz == Float.TYPE) {
            DoubleValue doubleValue = (DoubleValue)this.convert(517, xPathContext);
            return new Float(doubleValue.getDoubleValue());
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = StringValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            DoubleValue doubleValue = (DoubleValue)this.convert(517, xPathContext);
            return new Float(doubleValue.getDoubleValue());
        }
        if (clazz == Long.TYPE) {
            IntegerValue integerValue = (IntegerValue)this.convert(532, xPathContext);
            return new Long(integerValue.longValue());
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = StringValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            IntegerValue integerValue = (IntegerValue)this.convert(532, xPathContext);
            return new Long(integerValue.longValue());
        }
        if (clazz == Integer.TYPE) {
            IntegerValue integerValue = (IntegerValue)this.convert(532, xPathContext);
            return new Integer((int)integerValue.longValue());
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = StringValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            IntegerValue integerValue = (IntegerValue)this.convert(532, xPathContext);
            return new Integer((int)integerValue.longValue());
        }
        if (clazz == Short.TYPE) {
            IntegerValue integerValue = (IntegerValue)this.convert(532, xPathContext);
            return new Short((short)integerValue.longValue());
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = StringValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            IntegerValue integerValue = (IntegerValue)this.convert(532, xPathContext);
            return new Short((short)integerValue.longValue());
        }
        if (clazz == Byte.TYPE) {
            IntegerValue integerValue = (IntegerValue)this.convert(532, xPathContext);
            return new Byte((byte)integerValue.longValue());
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = StringValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            IntegerValue integerValue = (IntegerValue)this.convert(532, xPathContext);
            return new Byte((byte)integerValue.longValue());
        }
        if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = StringValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            if (this.value.length() == 1) {
                return new Character(this.value.charAt(0));
            }
            DynamicError dynamicError = new DynamicError("Cannot convert string to Java char unless length is 1");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("SAXON:0000");
            throw dynamicError;
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            DynamicError dynamicError = new DynamicError("Conversion of string to " + clazz.getName() + " is not supported");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("SAXON:0000");
            throw dynamicError;
        }
        return object;
    }

    public String toString() {
        return "\"" + this.value + '\"';
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class CharacterIterator
    implements SequenceIterator {
        int inpos = 0;
        int outpos = 0;
        int current = -1;

        public Item next() {
            if (this.inpos < StringValue.this.value.length()) {
                char c2;
                this.current = (c2 = StringValue.this.value.charAt(this.inpos++)) >= '\ud800' && c2 <= '\udbff' ? (c2 - 55296) * 1024 + (StringValue.this.value.charAt(this.inpos++) - 56320) + 65536 : (int)c2;
                ++this.outpos;
                return new IntegerValue(this.current);
            }
            this.outpos = -1;
            return null;
        }

        public Item current() {
            if (this.outpos < 1) {
                return null;
            }
            return new IntegerValue(this.current);
        }

        public int position() {
            return this.outpos;
        }

        public SequenceIterator getAnother() {
            return new CharacterIterator();
        }

        public int getProperties() {
            return 0;
        }
    }
}

