/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigInteger;
import net.sf.saxon.om.FastStringBuffer;

public class FloatingPointConverter {
    public static FloatingPointConverter THE_INSTANCE = new FloatingPointConverter();
    private static final char[] NEGATIVE_INFINITY = new char[]{'-', 'I', 'N', 'F'};
    private static final char[] POSITIVE_INFINITY = new char[]{'I', 'N', 'F'};
    private static final char[] NaN = new char[]{'N', 'a', 'N'};
    private static final char[] charForDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final long doubleSignMask = Long.MIN_VALUE;
    private static final long doubleExpMask = 0x7FF0000000000000L;
    private static final int doubleExpShift = 52;
    private static final int doubleExpBias = 1023;
    private static final long doubleFractMask = 0xFFFFFFFFFFFFFL;
    private static final int floatSignMask = Integer.MIN_VALUE;
    private static final int floatExpMask = 2139095040;
    private static final int floatExpShift = 23;
    private static final int floatExpBias = 127;
    private static final int floatFractMask = 0x7FFFFF;
    private static final BigInteger TEN = BigInteger.valueOf(10L);
    private static final BigInteger NINE = BigInteger.valueOf(9L);

    private FloatingPointConverter() {
    }

    public static FastStringBuffer appendInt(FastStringBuffer fastStringBuffer, int n2) {
        if (n2 < 0) {
            if (n2 == Integer.MIN_VALUE) {
                fastStringBuffer.append("-2147483648");
                return fastStringBuffer;
            }
            fastStringBuffer.append('-');
            n2 = -n2;
        }
        if (n2 < 10) {
            fastStringBuffer.append(charForDigit[n2]);
            return fastStringBuffer;
        }
        if (n2 < 100) {
            fastStringBuffer.append(charForDigit[n2 / 10]);
            fastStringBuffer.append(charForDigit[n2 % 10]);
            return fastStringBuffer;
        }
        if (n2 < 1000) {
            fastStringBuffer.append(charForDigit[n2 / 100]);
            int n3 = n2 % 100;
            fastStringBuffer.append(charForDigit[n3 / 10]);
            fastStringBuffer.append(charForDigit[n3 % 10]);
            return fastStringBuffer;
        }
        if (n2 < 10000) {
            fastStringBuffer.append(charForDigit[n2 / 1000]);
            int n4 = n2 % 1000;
            fastStringBuffer.append(charForDigit[n4 / 100]);
            fastStringBuffer.append(charForDigit[(n4 %= 100) / 10]);
            fastStringBuffer.append(charForDigit[n4 % 10]);
            return fastStringBuffer;
        }
        if (n2 < 100000) {
            fastStringBuffer.append(charForDigit[n2 / 10000]);
            int n5 = n2 % 10000;
            fastStringBuffer.append(charForDigit[n5 / 1000]);
            fastStringBuffer.append(charForDigit[(n5 %= 1000) / 100]);
            fastStringBuffer.append(charForDigit[(n5 %= 100) / 10]);
            fastStringBuffer.append(charForDigit[n5 % 10]);
            return fastStringBuffer;
        }
        if (n2 < 1000000) {
            fastStringBuffer.append(charForDigit[n2 / 100000]);
            int n6 = n2 % 100000;
            fastStringBuffer.append(charForDigit[n6 / 10000]);
            fastStringBuffer.append(charForDigit[(n6 %= 10000) / 1000]);
            fastStringBuffer.append(charForDigit[(n6 %= 1000) / 100]);
            fastStringBuffer.append(charForDigit[(n6 %= 100) / 10]);
            fastStringBuffer.append(charForDigit[n6 % 10]);
            return fastStringBuffer;
        }
        if (n2 < 10000000) {
            fastStringBuffer.append(charForDigit[n2 / 1000000]);
            int n7 = n2 % 1000000;
            fastStringBuffer.append(charForDigit[n7 / 100000]);
            fastStringBuffer.append(charForDigit[(n7 %= 100000) / 10000]);
            fastStringBuffer.append(charForDigit[(n7 %= 10000) / 1000]);
            fastStringBuffer.append(charForDigit[(n7 %= 1000) / 100]);
            fastStringBuffer.append(charForDigit[(n7 %= 100) / 10]);
            fastStringBuffer.append(charForDigit[n7 % 10]);
            return fastStringBuffer;
        }
        if (n2 < 100000000) {
            fastStringBuffer.append(charForDigit[n2 / 10000000]);
            int n8 = n2 % 10000000;
            fastStringBuffer.append(charForDigit[n8 / 1000000]);
            fastStringBuffer.append(charForDigit[(n8 %= 1000000) / 100000]);
            fastStringBuffer.append(charForDigit[(n8 %= 100000) / 10000]);
            fastStringBuffer.append(charForDigit[(n8 %= 10000) / 1000]);
            fastStringBuffer.append(charForDigit[(n8 %= 1000) / 100]);
            fastStringBuffer.append(charForDigit[(n8 %= 100) / 10]);
            fastStringBuffer.append(charForDigit[n8 % 10]);
            return fastStringBuffer;
        }
        if (n2 < 1000000000) {
            fastStringBuffer.append(charForDigit[n2 / 100000000]);
            int n9 = n2 % 100000000;
            fastStringBuffer.append(charForDigit[n9 / 10000000]);
            fastStringBuffer.append(charForDigit[(n9 %= 10000000) / 1000000]);
            fastStringBuffer.append(charForDigit[(n9 %= 1000000) / 100000]);
            fastStringBuffer.append(charForDigit[(n9 %= 100000) / 10000]);
            fastStringBuffer.append(charForDigit[(n9 %= 10000) / 1000]);
            fastStringBuffer.append(charForDigit[(n9 %= 1000) / 100]);
            fastStringBuffer.append(charForDigit[(n9 %= 100) / 10]);
            fastStringBuffer.append(charForDigit[n9 % 10]);
            return fastStringBuffer;
        }
        fastStringBuffer.append(charForDigit[n2 / 1000000000]);
        int n10 = n2 % 1000000000;
        fastStringBuffer.append(charForDigit[n10 / 100000000]);
        fastStringBuffer.append(charForDigit[(n10 %= 100000000) / 10000000]);
        fastStringBuffer.append(charForDigit[(n10 %= 10000000) / 1000000]);
        fastStringBuffer.append(charForDigit[(n10 %= 1000000) / 100000]);
        fastStringBuffer.append(charForDigit[(n10 %= 100000) / 10000]);
        fastStringBuffer.append(charForDigit[(n10 %= 10000) / 1000]);
        fastStringBuffer.append(charForDigit[(n10 %= 1000) / 100]);
        fastStringBuffer.append(charForDigit[(n10 %= 100) / 10]);
        fastStringBuffer.append(charForDigit[n10 % 10]);
        return fastStringBuffer;
    }

    private static void fppfpp(FastStringBuffer fastStringBuffer, int n2, long l2, int n3) {
        boolean bl;
        int n4;
        int n5;
        long l3;
        long l4 = l2 << Math.max(n2 - n3, 0);
        long l5 = 1L << Math.max(0, -(n2 - n3));
        long l6 = l3 = 1L << Math.max(n2 - n3, 0);
        boolean bl2 = true;
        if (l2 == 1L << n3 - 1) {
            l6 <<= 1;
            l4 <<= 1;
            l5 <<= 1;
        }
        int n6 = 0;
        while (l4 < (l5 + 9L) / 10L) {
            --n6;
            l4 *= 10L;
            l3 *= 10L;
            l6 *= 10L;
        }
        while (2L * l4 + l6 >= 2L * l5) {
            l5 *= 10L;
            ++n6;
        }
        for (n5 = n6; n5 < 0; ++n5) {
            if (bl2) {
                fastStringBuffer.append("0.");
            }
            bl2 = false;
            fastStringBuffer.append('0');
        }
        while (true) {
            --n6;
            n4 = (int)(l4 * 10L / l5);
            l4 = l4 * 10L % l5;
            n5 = 2L * l4 < (l3 *= 10L) ? 1 : 0;
            boolean bl3 = bl = 2L * l4 > 2L * l5 - (l6 *= 10L);
            if (n5 != 0 || bl) break;
            if (n6 == -1) {
                if (bl2) {
                    fastStringBuffer.append('0');
                }
                fastStringBuffer.append('.');
            }
            fastStringBuffer.append(charForDigit[n4]);
            bl2 = false;
        }
        if (bl && (n5 == 0 || 2L * l4 > l5)) {
            ++n4;
        }
        if (n6 == -1) {
            if (bl2) {
                fastStringBuffer.append('0');
            }
            fastStringBuffer.append('.');
        }
        fastStringBuffer.append(charForDigit[n4]);
        for (int i2 = 0; i2 < n6; ++i2) {
            fastStringBuffer.append('0');
        }
    }

    private static void fppfppBig(FastStringBuffer fastStringBuffer, int n2, long l2, int n3) {
        boolean bl;
        int n4;
        int n5;
        BigInteger bigInteger;
        BigInteger bigInteger2 = BigInteger.valueOf(l2).shiftLeft(Math.max(n2 - n3, 0));
        BigInteger bigInteger3 = BigInteger.ONE.shiftLeft(Math.max(0, -(n2 - n3)));
        BigInteger bigInteger4 = bigInteger = BigInteger.ONE.shiftLeft(Math.max(n2 - n3, 0));
        boolean bl2 = true;
        if (l2 == 1L << n3 - 1) {
            bigInteger4 = bigInteger4.shiftLeft(1);
            bigInteger2 = bigInteger2.shiftLeft(1);
            bigInteger3 = bigInteger3.shiftLeft(1);
        }
        int n6 = 0;
        while (bigInteger2.compareTo(bigInteger3.add(NINE).divide(TEN)) < 0) {
            --n6;
            bigInteger2 = bigInteger2.multiply(TEN);
            bigInteger = bigInteger.multiply(TEN);
            bigInteger4 = bigInteger4.multiply(TEN);
        }
        while (bigInteger2.shiftLeft(1).add(bigInteger4).compareTo(bigInteger3.shiftLeft(1)) >= 0) {
            bigInteger3 = bigInteger3.multiply(TEN);
            ++n6;
        }
        for (n5 = n6; n5 < 0; ++n5) {
            if (bl2) {
                fastStringBuffer.append("0.");
            }
            bl2 = false;
            fastStringBuffer.append('0');
        }
        while (true) {
            --n6;
            BigInteger bigInteger5 = bigInteger2.multiply(TEN);
            n4 = bigInteger5.divide(bigInteger3).intValue();
            bigInteger2 = bigInteger5.mod(bigInteger3);
            bigInteger = bigInteger.multiply(TEN);
            bigInteger4 = bigInteger4.multiply(TEN);
            BigInteger bigInteger6 = bigInteger2.shiftLeft(1);
            n5 = bigInteger6.compareTo(bigInteger) < 0 ? 1 : 0;
            boolean bl3 = bl = bigInteger6.compareTo(bigInteger3.shiftLeft(1).subtract(bigInteger4)) > 0;
            if (n5 != 0 || bl) break;
            if (n6 == -1) {
                if (bl2) {
                    fastStringBuffer.append('0');
                }
                fastStringBuffer.append('.');
            }
            fastStringBuffer.append(charForDigit[n4]);
            bl2 = false;
        }
        if (bl && (n5 == 0 || bigInteger2.shiftLeft(1).compareTo(bigInteger3) > 0)) {
            ++n4;
        }
        if (n6 == -1) {
            if (bl2) {
                fastStringBuffer.append('0');
            }
            fastStringBuffer.append('.');
        }
        fastStringBuffer.append(charForDigit[n4]);
        for (int i2 = 0; i2 < n6; ++i2) {
            fastStringBuffer.append('0');
        }
    }

    private static void fppfppExponential(FastStringBuffer fastStringBuffer, int n2, long l2, int n3) {
        boolean bl;
        boolean bl2;
        int n4;
        BigInteger bigInteger;
        BigInteger bigInteger2 = BigInteger.valueOf(l2).shiftLeft(Math.max(n2 - n3, 0));
        BigInteger bigInteger3 = BigInteger.ONE.shiftLeft(Math.max(0, -(n2 - n3)));
        BigInteger bigInteger4 = bigInteger = BigInteger.ONE.shiftLeft(Math.max(n2 - n3, 0));
        boolean bl3 = true;
        boolean bl4 = false;
        if (l2 == 1L << n3 - 1) {
            bigInteger4 = bigInteger4.shiftLeft(1);
            bigInteger2 = bigInteger2.shiftLeft(1);
            bigInteger3 = bigInteger3.shiftLeft(1);
        }
        int n5 = 0;
        while (bigInteger2.compareTo(bigInteger3.add(NINE).divide(TEN)) < 0) {
            --n5;
            bigInteger2 = bigInteger2.multiply(TEN);
            bigInteger = bigInteger.multiply(TEN);
            bigInteger4 = bigInteger4.multiply(TEN);
        }
        while (bigInteger2.shiftLeft(1).add(bigInteger4).compareTo(bigInteger3.shiftLeft(1)) >= 0) {
            bigInteger3 = bigInteger3.multiply(TEN);
            ++n5;
        }
        int n6 = n5 - 1;
        while (true) {
            --n5;
            BigInteger bigInteger5 = bigInteger2.multiply(TEN);
            n4 = bigInteger5.divide(bigInteger3).intValue();
            bigInteger2 = bigInteger5.mod(bigInteger3);
            bigInteger = bigInteger.multiply(TEN);
            bigInteger4 = bigInteger4.multiply(TEN);
            BigInteger bigInteger6 = bigInteger2.shiftLeft(1);
            bl2 = bigInteger6.compareTo(bigInteger) < 0;
            boolean bl5 = bl = bigInteger6.compareTo(bigInteger3.shiftLeft(1).subtract(bigInteger4)) > 0;
            if (bl2 || bl) break;
            fastStringBuffer.append(charForDigit[n4]);
            if (bl3) {
                fastStringBuffer.append('.');
                bl4 = true;
            }
            bl3 = false;
        }
        if (bl && (!bl2 || bigInteger2.shiftLeft(1).compareTo(bigInteger3) > 0)) {
            ++n4;
        }
        fastStringBuffer.append(charForDigit[n4]);
        if (!bl4) {
            fastStringBuffer.append(".0");
        }
        fastStringBuffer.append('E');
        FloatingPointConverter.appendInt(fastStringBuffer, n6);
    }

    public static FastStringBuffer appendDouble(FastStringBuffer fastStringBuffer, double d2) {
        double d3 = d2;
        if (d3 == Double.NEGATIVE_INFINITY) {
            fastStringBuffer.append(NEGATIVE_INFINITY);
        } else if (d3 == Double.POSITIVE_INFINITY) {
            fastStringBuffer.append(POSITIVE_INFINITY);
        } else if (d3 != d3) {
            fastStringBuffer.append(NaN);
        } else if (d3 == 0.0) {
            if ((Double.doubleToLongBits(d3) & Long.MIN_VALUE) != 0L) {
                fastStringBuffer.append('-');
            }
            fastStringBuffer.append('0');
        } else if (d3 == Double.MAX_VALUE) {
            fastStringBuffer.append("1.7976931348623157E308");
        } else if (d3 == -1.7976931348623157E308) {
            fastStringBuffer.append("-1.7976931348623157E308");
        } else if (d3 == Double.MIN_VALUE) {
            fastStringBuffer.append("4.9E-324");
        } else if (d3 == -4.9E-324) {
            fastStringBuffer.append("-4.9E-324");
        } else {
            if (d3 < 0.0) {
                fastStringBuffer.append('-');
                d3 = -d3;
            }
            boolean bl = d3 >= 1000000.0 || d3 < 1.0E-6;
            long l2 = Double.doubleToLongBits(d3);
            long l3 = 0x10000000000000L | l2 & 0xFFFFFFFFFFFFFL;
            long l4 = (l2 & 0x7FF0000000000000L) >> 52;
            int n2 = (int)l4 - 1023;
            if (l4 == 0L) {
                fastStringBuffer.append(Double.toString(d2));
                return fastStringBuffer;
            }
            if (bl) {
                FloatingPointConverter.fppfppExponential(fastStringBuffer, n2, l3, 52);
            } else if (d3 <= 0.01) {
                FloatingPointConverter.fppfppBig(fastStringBuffer, n2, l3, 52);
            } else {
                FloatingPointConverter.fppfpp(fastStringBuffer, n2, l3, 52);
            }
        }
        return fastStringBuffer;
    }

    public static FastStringBuffer appendFloat(FastStringBuffer fastStringBuffer, float f2) {
        float f3 = f2;
        if (f3 == Float.NEGATIVE_INFINITY) {
            fastStringBuffer.append(NEGATIVE_INFINITY);
        } else if (f3 == Float.POSITIVE_INFINITY) {
            fastStringBuffer.append(POSITIVE_INFINITY);
        } else if (f3 != f3) {
            fastStringBuffer.append(NaN);
        } else if ((double)f3 == 0.0) {
            if ((Float.floatToIntBits(f3) & Integer.MIN_VALUE) != 0) {
                fastStringBuffer.append('-');
            }
            fastStringBuffer.append('0');
        } else if (f3 == Float.MAX_VALUE) {
            fastStringBuffer.append("3.4028235E38");
        } else if (f3 == -3.4028235E38f) {
            fastStringBuffer.append("-3.4028235E38");
        } else if (f3 == Float.MIN_VALUE) {
            fastStringBuffer.append("1.4E-45");
        } else if (f3 == -1.4E-45f) {
            fastStringBuffer.append("-1.4E-45");
        } else {
            if (f3 < 0.0f) {
                fastStringBuffer.append('-');
                f3 = -f3;
            }
            boolean bl = f3 >= 1000000.0f || f3 < 1.0E-6f;
            int n2 = Float.floatToIntBits(f3);
            int n3 = 0x800000 | n2 & 0x7FFFFF;
            int n4 = (n2 & 0x7F800000) >> 23;
            int n5 = n4 - 127;
            int n6 = 23;
            if (n4 == 0) {
                fastStringBuffer.append(Float.toString(f2));
                return fastStringBuffer;
            }
            if (bl) {
                FloatingPointConverter.fppfppExponential(fastStringBuffer, n5, n3, n6);
            } else {
                FloatingPointConverter.fppfpp(fastStringBuffer, n5, n3, n6);
            }
        }
        return fastStringBuffer;
    }
}

