/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.FloatingPointConverter;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;

public final class DoubleValue
extends NumericValue {
    public static final DoubleValue ZERO = new DoubleValue(0.0);
    public static final DoubleValue NaN = new DoubleValue(Double.NaN);
    private double value;
    static Pattern nonExponentialPattern = Pattern.compile("(-?[0-9])([0-9]+?)(0*)\\.([0-9]*)");
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$DoubleValue;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;

    public DoubleValue(CharSequence charSequence) throws ValidationException {
        try {
            this.value = Value.stringToNumber(charSequence);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValidationException("Cannot convert string " + Err.wrap(charSequence, 4) + " to a double");
        }
    }

    public DoubleValue(double d2) {
        this.value = d2;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public int hashCode() {
        if (this.value > -2.147483648E9 && this.value < 2.147483647E9) {
            return (int)this.value;
        }
        return new Double(this.value).hashCode();
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.value != 0.0 && !Double.isNaN(this.value);
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 514: {
                return BooleanValue.get(this.effectiveBooleanValue(null));
            }
            case 88: 
            case 517: 
            case 643: 
            case 646: {
                return this;
            }
            case 532: {
                if (Double.isNaN(this.value)) {
                    ValidationException validationException = new ValidationException("Cannot convert double NaN to an integer");
                    validationException.setErrorCode("FOCA0002");
                    return new ValidationErrorValue(validationException);
                }
                if (Double.isInfinite(this.value)) {
                    ValidationException validationException = new ValidationException("Cannot convert double infinity to an integer");
                    validationException.setErrorCode("FOCA0002");
                    return new ValidationErrorValue(validationException);
                }
                if (this.value > 9.223372036854776E18 || this.value < -9.223372036854776E18) {
                    return new BigIntegerValue(new BigDecimal(this.value).toBigInteger());
                }
                return new IntegerValue((long)this.value);
            }
            case 515: {
                try {
                    return new DecimalValue(this.value);
                }
                catch (ValidationException validationException) {
                    return new ValidationErrorValue(validationException);
                }
            }
            case 516: {
                return new FloatValue((float)this.value);
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert double to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public String getStringValue() {
        return ((Object)DoubleValue.doubleToString(this.value)).toString();
    }

    public CharSequence getStringValueCS() {
        return DoubleValue.doubleToString(this.value);
    }

    public static CharSequence doubleToString(double d2) {
        FastStringBuffer fastStringBuffer = FloatingPointConverter.appendDouble(new FastStringBuffer(20), d2);
        return fastStringBuffer;
    }

    public static CharSequence doubleToStringOLD(double d2, String string) {
        String string2;
        if (d2 == 0.0) {
            if (string.charAt(0) == '-') {
                return "-0";
            }
            return "0";
        }
        if (Double.isInfinite(d2)) {
            return d2 > 0.0 ? "INF" : "-INF";
        }
        if (Double.isNaN(d2)) {
            return "NaN";
        }
        double d3 = Math.abs(d2);
        String string3 = string;
        if (d3 < 1.0E-6 || d3 >= 1000000.0) {
            if (string3.indexOf(69) < 0) {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(32);
                Matcher matcher = nonExponentialPattern.matcher(string3);
                if (matcher.matches()) {
                    fastStringBuffer.append(matcher.group(1));
                    fastStringBuffer.append('.');
                    fastStringBuffer.append(matcher.group(2));
                    String string4 = matcher.group(4);
                    if ("0".equals(string4)) {
                        fastStringBuffer.append("E" + (matcher.group(2).length() + matcher.group(3).length()));
                        return fastStringBuffer;
                    }
                    fastStringBuffer.append(matcher.group(3));
                    fastStringBuffer.append(matcher.group(4));
                    fastStringBuffer.append("E" + (matcher.group(2).length() + matcher.group(3).length()));
                    return fastStringBuffer;
                }
                return string3;
            }
            return string3;
        }
        int n2 = string3.length();
        if (string3.endsWith("E0")) {
            string3 = string3.substring(0, n2 - 2);
        }
        if (string3.endsWith(".0")) {
            return string3.substring(0, n2 - 2);
        }
        int n3 = string3.indexOf(69);
        if (n3 < 0) {
            while (string3.charAt(n2 - 1) == '0' && string3.charAt(n2 - 2) != '.') {
                string3 = string3.substring(0, --n2);
            }
            return string3;
        }
        int n4 = Integer.parseInt(string3.substring(n3 + 1));
        if (string3.charAt(0) == '-') {
            string2 = "-";
            string3 = string3.substring(1);
            --n3;
        } else {
            string2 = "";
        }
        int n5 = n3 - 2;
        if (n4 >= n5) {
            return string2 + string3.substring(0, 1) + string3.substring(2, n3) + DoubleValue.zeros(n4 - n5);
        }
        if (n4 > 0) {
            return string2 + string3.substring(0, 1) + string3.substring(2, 2 + n4) + '.' + string3.substring(2 + n4, n3);
        }
        while (string3.charAt(n3 - 1) == '0') {
            --n3;
        }
        return string2 + "0." + DoubleValue.zeros(-1 - n4) + string3.substring(0, 1) + string3.substring(2, n3);
    }

    static String zeros(int n2) {
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = 48;
        }
        return new String(cArray);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.DOUBLE_TYPE;
    }

    public NumericValue negate() {
        return new DoubleValue(-this.value);
    }

    public NumericValue floor() {
        return new DoubleValue(Math.floor(this.value));
    }

    public NumericValue ceiling() {
        return new DoubleValue(Math.ceil(this.value));
    }

    public NumericValue round() {
        if (Double.isNaN(this.value)) {
            return this;
        }
        if (Double.isInfinite(this.value)) {
            return this;
        }
        if (this.value == 0.0) {
            return this;
        }
        if (this.value > -0.5 && this.value < 0.0) {
            return new DoubleValue(-0.0);
        }
        if (this.value > -9.223372036854776E18 && this.value < 9.223372036854776E18) {
            return new DoubleValue(Math.round(this.value));
        }
        return this;
    }

    public NumericValue roundHalfToEven(int n2) {
        if (Double.isNaN(this.value)) {
            return this;
        }
        if (Double.isInfinite(this.value)) {
            return this;
        }
        if (this.value == 0.0) {
            return this;
        }
        double d2 = Math.pow(10.0, n2 + 1);
        double d3 = Math.abs(this.value * d2);
        if (Double.isInfinite(d3)) {
            BigDecimal bigDecimal = new BigDecimal(this.value);
            bigDecimal.setScale(n2, 6);
            return new DoubleValue(bigDecimal.doubleValue());
        }
        double d4 = d3 % 10.0;
        d3 = d4 > 5.0 ? (d3 += 10.0 - d4) : (d4 < 5.0 ? (d3 -= d4) : (d3 % 20.0 == 15.0 ? (d3 += 5.0) : (d3 -= 5.0)));
        d3 /= d2;
        if (this.value < 0.0) {
            d3 = 0.0 - d3;
        }
        return new DoubleValue(d3);
    }

    public double signum() {
        if (Double.isNaN(this.value)) {
            return this.value;
        }
        if (this.value > 0.0) {
            return 1.0;
        }
        if (this.value == 0.0) {
            return 0.0;
        }
        return -1.0;
    }

    public boolean isWholeNumber() {
        return this.value == Math.floor(this.value) && !Double.isInfinite(this.value);
    }

    public NumericValue arithmetic(int n2, NumericValue numericValue, XPathContext xPathContext) throws XPathException {
        if (numericValue instanceof DoubleValue) {
            switch (n2) {
                case 15: {
                    return new DoubleValue(this.value + ((DoubleValue)numericValue).value);
                }
                case 16: {
                    return new DoubleValue(this.value - ((DoubleValue)numericValue).value);
                }
                case 17: {
                    return new DoubleValue(this.value * ((DoubleValue)numericValue).value);
                }
                case 18: {
                    return new DoubleValue(this.value / ((DoubleValue)numericValue).value);
                }
                case 50: {
                    if (((DoubleValue)numericValue).value == 0.0) {
                        DynamicError dynamicError = new DynamicError("Integer division by zero");
                        dynamicError.setErrorCode("FOAR0001");
                        dynamicError.setXPathContext(xPathContext);
                        throw dynamicError;
                    }
                    if (this.isNaN() || Double.isInfinite(this.value)) {
                        DynamicError dynamicError = new DynamicError("First operand of idiv is NaN or infinity");
                        dynamicError.setErrorCode("FOAR0002");
                        dynamicError.setXPathContext(xPathContext);
                        throw dynamicError;
                    }
                    if (numericValue.isNaN()) {
                        DynamicError dynamicError = new DynamicError("Second operand of idiv is NaN");
                        dynamicError.setErrorCode("FOAR0002");
                        dynamicError.setXPathContext(xPathContext);
                        throw dynamicError;
                    }
                    return (NumericValue)new DoubleValue(this.value / ((DoubleValue)numericValue).value).convert(532, xPathContext);
                }
                case 19: {
                    return new DoubleValue(this.value % ((DoubleValue)numericValue).value);
                }
            }
            throw new UnsupportedOperationException("Unknown operator");
        }
        return this.arithmetic(n2, (DoubleValue)numericValue.convert(517, xPathContext), xPathContext);
    }

    public boolean schemaEquals(Value value) {
        if (value instanceof AtomicValue) {
            value = ((AtomicValue)value).getPrimitiveValue();
        }
        if (value instanceof DoubleValue) {
            return this.value == ((DoubleValue)value).value;
        }
        return false;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = DoubleValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return new Double(this.value);
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DoubleValue == null ? (class$net$sf$saxon$value$DoubleValue = DoubleValue.class$("net.sf.saxon.value.DoubleValue")) : class$net$sf$saxon$value$DoubleValue)) {
            return this;
        }
        if (clazz == Boolean.TYPE) {
            return this.effectiveBooleanValue(xPathContext);
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = DoubleValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return this.effectiveBooleanValue(xPathContext);
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = DoubleValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = DoubleValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = DoubleValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(this.value);
        }
        if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = DoubleValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(this.value);
        }
        if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = DoubleValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long((long)this.value);
        }
        if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = DoubleValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer((int)this.value);
        }
        if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = DoubleValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short((short)this.value);
        }
        if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = DoubleValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte((byte)this.value);
        }
        if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = DoubleValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            return new Character((char)this.value);
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            DynamicError dynamicError = new DynamicError("Conversion of double to " + clazz.getName() + " is not supported");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("SAXON:0000");
        }
        return object;
    }

    public static void printInternalForm(double d2) {
        long l2 = Double.doubleToLongBits(d2);
        if (l2 == 0x7FF0000000000000L) {
            System.err.println("+Infinity");
        } else if (l2 == -4503599627370496L) {
            System.err.println("-Infinity");
        } else if (l2 == 9221120237041090560L) {
            System.err.println("NaN");
        } else {
            int n2 = l2 >> 63 == 0L ? 1 : -1;
            int n3 = (int)(l2 >> 52 & 0x7FFL);
            long l3 = n3 == 0 ? (l2 & 0xFFFFFFFFFFFFFL) << 1 : l2 & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            System.err.println("Sign: " + n2);
            System.err.println("Exponent: " + (n3 - 1075));
            System.err.println("Mantissa: " + l3);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

