/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

public class SystemIdMap {
    private int[] sequenceNumbers = new int[4];
    private String[] uris = new String[4];
    private int allocated = 0;

    public void setSystemId(int n2, String string) {
        if (this.allocated > 0 && string.equals(this.uris[this.allocated - 1])) {
            return;
        }
        if (this.sequenceNumbers.length <= this.allocated + 1) {
            int[] nArray = new int[this.allocated * 2];
            String[] stringArray = new String[this.allocated * 2];
            System.arraycopy(this.sequenceNumbers, 0, nArray, 0, this.allocated);
            System.arraycopy(this.uris, 0, stringArray, 0, this.allocated);
            this.sequenceNumbers = nArray;
            this.uris = stringArray;
        }
        this.sequenceNumbers[this.allocated] = n2;
        this.uris[this.allocated] = string;
        ++this.allocated;
    }

    public String getSystemId(int n2) {
        if (this.allocated == 0) {
            return null;
        }
        for (int i2 = 1; i2 < this.allocated; ++i2) {
            if (this.sequenceNumbers[i2] <= n2) continue;
            return this.uris[i2 - 1];
        }
        return this.uris[this.allocated - 1];
    }
}

