/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.tinytree.LargeStringBuffer;
import net.sf.saxon.tinytree.TinyAttributeImpl;
import net.sf.saxon.tinytree.TinyCommentImpl;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.tinytree.TinyElementImpl;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyParentNodeImpl;
import net.sf.saxon.tinytree.TinyProcInstImpl;
import net.sf.saxon.tinytree.TinyTextImpl;
import net.sf.saxon.tinytree.WhitespaceTextImpl;
import net.sf.saxon.tree.LineNumberMap;
import net.sf.saxon.tree.SystemIdMap;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public final class TinyTree {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private Configuration config;
    private ArrayList documentList = new ArrayList(5);
    protected int documentNumber;
    protected LargeStringBuffer charBuffer;
    protected FastStringBuffer commentBuffer = null;
    protected int numberOfNodes = 0;
    public byte[] nodeKind;
    protected short[] depth;
    protected int[] next;
    protected int[] alpha;
    protected int[] beta;
    protected int[] nameCode;
    protected int[] prior = null;
    protected int[] typeCodeArray = null;
    private static final int TYPECODE_IDREF = 0x20000000;
    protected int numberOfAttributes = 0;
    protected int[] attParent;
    protected int[] attCode;
    protected CharSequence[] attValue;
    protected int[] attTypeCode;
    protected int numberOfNamespaces = 0;
    protected int[] namespaceParent;
    protected int[] namespaceCode;
    private int[] rootIndex = new int[5];
    protected int rootIndexUsed = 0;
    private LineNumberMap lineNumberMap;
    private SystemIdMap systemIdMap = null;
    protected boolean usesNamespaces = false;
    private static int treesCreated = 5;
    private static double averageNodes = 4000.0;
    private static double averageAttributes = 100.0;
    private static double averageNamespaces = 20.0;
    private static double averageCharacters = 4000.0;

    public TinyTree() {
        this((int)(averageNodes + 1.0), (int)(averageAttributes + 1.0), (int)(averageNamespaces + 1.0), (int)(averageCharacters + 1.0));
    }

    public TinyTree(int n2, int n3, int n4, int n5) {
        this.nodeKind = new byte[n2];
        this.depth = new short[n2];
        this.next = new int[n2];
        this.alpha = new int[n2];
        this.beta = new int[n2];
        this.nameCode = new int[n2];
        this.numberOfAttributes = 0;
        this.attParent = new int[n3];
        this.attCode = new int[n3];
        this.attValue = new String[n3];
        this.numberOfNamespaces = 0;
        this.namespaceParent = new int[n4];
        this.namespaceCode = new int[n4];
        this.charBuffer = new LargeStringBuffer(n5, 64000);
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
        this.addNamespace(0, 65537);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    private void ensureNodeCapacity(short s2) {
        if (this.nodeKind.length < this.numberOfNodes + 1) {
            int n2 = s2 == 11 ? this.numberOfNodes + 1 : this.numberOfNodes * 2;
            byte[] byArray = new byte[n2];
            int[] nArray = new int[n2];
            short[] sArray = new short[n2];
            int[] nArray2 = new int[n2];
            int[] nArray3 = new int[n2];
            int[] nArray4 = new int[n2];
            System.arraycopy(this.nodeKind, 0, byArray, 0, this.numberOfNodes);
            System.arraycopy(this.next, 0, nArray, 0, this.numberOfNodes);
            System.arraycopy(this.depth, 0, sArray, 0, this.numberOfNodes);
            System.arraycopy(this.alpha, 0, nArray2, 0, this.numberOfNodes);
            System.arraycopy(this.beta, 0, nArray3, 0, this.numberOfNodes);
            System.arraycopy(this.nameCode, 0, nArray4, 0, this.numberOfNodes);
            this.nodeKind = byArray;
            this.next = nArray;
            this.depth = sArray;
            this.alpha = nArray2;
            this.beta = nArray3;
            this.nameCode = nArray4;
            if (this.typeCodeArray != null) {
                int[] nArray5 = new int[n2];
                System.arraycopy(this.typeCodeArray, 0, nArray5, 0, this.numberOfNodes);
                this.typeCodeArray = nArray5;
            }
        }
    }

    private void ensureAttributeCapacity() {
        if (this.attParent.length < this.numberOfAttributes + 1) {
            int n2 = this.numberOfAttributes * 2;
            if (n2 == 0) {
                n2 = 10;
            }
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            String[] stringArray = new String[n2];
            System.arraycopy(this.attParent, 0, nArray, 0, this.numberOfAttributes);
            System.arraycopy(this.attCode, 0, nArray2, 0, this.numberOfAttributes);
            System.arraycopy(this.attValue, 0, stringArray, 0, this.numberOfAttributes);
            this.attParent = nArray;
            this.attCode = nArray2;
            this.attValue = stringArray;
            if (this.attTypeCode != null) {
                int[] nArray3 = new int[n2];
                System.arraycopy(this.attTypeCode, 0, nArray3, 0, this.numberOfAttributes);
                this.attTypeCode = nArray3;
            }
        }
    }

    private void ensureNamespaceCapacity() {
        if (this.namespaceParent.length < this.numberOfNamespaces + 1) {
            int n2 = this.numberOfNamespaces * 2;
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            System.arraycopy(this.namespaceParent, 0, nArray, 0, this.numberOfNamespaces);
            System.arraycopy(this.namespaceCode, 0, nArray2, 0, this.numberOfNamespaces);
            this.namespaceParent = nArray;
            this.namespaceCode = nArray2;
        }
    }

    void addDocumentNode(TinyDocumentImpl tinyDocumentImpl) {
        this.documentList.add(tinyDocumentImpl);
        this.addNode((short)9, 0, this.documentList.size() - 1, 0, -1);
    }

    int addNode(short s2, int n2, int n3, int n4, int n5) {
        this.ensureNodeCapacity(s2);
        this.nodeKind[this.numberOfNodes] = (byte)s2;
        this.depth[this.numberOfNodes] = (short)n2;
        this.alpha[this.numberOfNodes] = n3;
        this.beta[this.numberOfNodes] = n4;
        this.nameCode[this.numberOfNodes] = n5;
        this.next[this.numberOfNodes] = -1;
        if (this.typeCodeArray != null) {
            this.typeCodeArray[this.numberOfNodes] = 641;
        }
        if (this.numberOfNodes == 0) {
            this.documentNumber = this.config.getDocumentNumberAllocator().allocateDocumentNumber();
        }
        if (n2 == 0 && s2 != 11) {
            if (this.rootIndexUsed == this.rootIndex.length) {
                int[] nArray = new int[this.rootIndexUsed * 2];
                System.arraycopy(this.rootIndex, 0, nArray, 0, this.rootIndexUsed);
                this.rootIndex = nArray;
            }
            this.rootIndex[this.rootIndexUsed++] = this.numberOfNodes;
        }
        return this.numberOfNodes++;
    }

    void appendChars(CharSequence charSequence) {
        this.charBuffer.append(charSequence);
    }

    void condense() {
        int[] nArray;
        Object[] objectArray;
        int[] nArray2;
        Object[] objectArray2;
        int n2;
        if (this.rootIndexUsed > 1) {
            return;
        }
        if (this.numberOfNodes * 3 < this.nodeKind.length || this.nodeKind.length - this.numberOfNodes > 20000) {
            n2 = this.numberOfNodes + 1;
            objectArray2 = new byte[n2];
            nArray2 = new int[n2];
            objectArray = new short[n2];
            nArray = new int[n2];
            int[] nArray3 = new int[n2];
            int[] nArray4 = new int[n2];
            System.arraycopy(this.nodeKind, 0, objectArray2, 0, this.numberOfNodes);
            System.arraycopy(this.next, 0, nArray2, 0, this.numberOfNodes);
            System.arraycopy(this.depth, 0, objectArray, 0, this.numberOfNodes);
            System.arraycopy(this.alpha, 0, nArray, 0, this.numberOfNodes);
            System.arraycopy(this.beta, 0, nArray3, 0, this.numberOfNodes);
            System.arraycopy(this.nameCode, 0, nArray4, 0, this.numberOfNodes);
            if (this.typeCodeArray != null) {
                int[] nArray5 = new int[n2];
                System.arraycopy(this.typeCodeArray, 0, nArray5, 0, this.numberOfNodes);
                this.typeCodeArray = nArray5;
            }
            this.nodeKind = objectArray2;
            this.next = nArray2;
            this.depth = objectArray;
            this.alpha = nArray;
            this.beta = nArray3;
            this.nameCode = nArray4;
        }
        if (this.numberOfAttributes * 3 < this.attParent.length || this.attParent.length - this.numberOfAttributes > 1000) {
            n2 = this.numberOfAttributes;
            if (n2 == 0) {
                this.attParent = EMPTY_INT_ARRAY;
                this.attCode = EMPTY_INT_ARRAY;
                this.attValue = EMPTY_STRING_ARRAY;
                this.attTypeCode = null;
            }
            objectArray2 = new int[n2];
            nArray2 = new int[n2];
            objectArray = new String[n2];
            System.arraycopy(this.attParent, 0, objectArray2, 0, this.numberOfAttributes);
            System.arraycopy(this.attCode, 0, nArray2, 0, this.numberOfAttributes);
            System.arraycopy(this.attValue, 0, objectArray, 0, this.numberOfAttributes);
            this.attParent = objectArray2;
            this.attCode = nArray2;
            this.attValue = (CharSequence[])objectArray;
            if (this.attTypeCode != null) {
                nArray = new int[n2];
                System.arraycopy(this.attTypeCode, 0, nArray, 0, this.numberOfAttributes);
                this.attTypeCode = nArray;
            }
        }
        if (this.numberOfNamespaces * 3 < this.namespaceParent.length) {
            n2 = this.numberOfNamespaces;
            objectArray2 = new int[n2];
            nArray2 = new int[n2];
            System.arraycopy(this.namespaceParent, 0, objectArray2, 0, this.numberOfNamespaces);
            System.arraycopy(this.namespaceCode, 0, nArray2, 0, this.numberOfNamespaces);
            this.namespaceParent = objectArray2;
            this.namespaceCode = nArray2;
        }
        this.updateStatistics();
    }

    void setElementAnnotation(int n2, int n3) {
        if (n3 != 641) {
            if (this.typeCodeArray == null) {
                this.typeCodeArray = new int[this.nodeKind.length];
                Arrays.fill(this.typeCodeArray, 0, this.nodeKind.length, 641);
            }
            this.typeCodeArray[n2] = n3;
        }
    }

    public int getTypeAnnotation(int n2) {
        if (this.typeCodeArray == null) {
            return 641;
        }
        return this.typeCodeArray[n2] & 0xFFFFF;
    }

    public int getNodeKind(int n2) {
        int n3 = this.nodeKind[n2];
        return n3 == 4 ? 3 : n3;
    }

    public int getNameCode(int n2) {
        return this.nameCode[n2];
    }

    void ensurePriorIndex() {
        if (this.prior == null || this.prior.length < this.numberOfNodes) {
            this.makePriorIndex();
        }
    }

    private synchronized void makePriorIndex() {
        this.prior = new int[this.numberOfNodes];
        Arrays.fill(this.prior, 0, this.numberOfNodes, -1);
        for (int i2 = 0; i2 < this.numberOfNodes; ++i2) {
            int n2 = this.next[i2];
            if (n2 <= i2) continue;
            this.prior[n2] = i2;
        }
    }

    void addAttribute(NodeInfo nodeInfo, int n2, int n3, int n4, CharSequence charSequence, int n5) {
        this.ensureAttributeCapacity();
        this.attParent[this.numberOfAttributes] = n2;
        this.attCode[this.numberOfAttributes] = n3;
        this.attValue[this.numberOfAttributes] = charSequence;
        if (n4 == -1) {
            n4 = 642;
        }
        if (n4 != 642) {
            this.initializeAttributeTypeCodes();
        }
        if (this.attTypeCode != null) {
            this.attTypeCode[this.numberOfAttributes] = n4;
        }
        if (this.alpha[n2] == -1) {
            this.alpha[n2] = this.numberOfAttributes;
        }
        if (nodeInfo instanceof TinyDocumentImpl) {
            boolean bl = false;
            if ((n5 & 0x800) != 0) {
                bl = true;
            } else if ((n3 & 0xFFFFF) == 388) {
                bl = true;
            } else if (this.config.getTypeHierarchy().isIdCode(n4)) {
                bl = true;
            }
            if (bl) {
                String string = ((Object)charSequence).toString().trim();
                if (nodeInfo.getConfiguration().getNameChecker().isValidNCName(string)) {
                    TinyNodeImpl tinyNodeImpl = this.getNode(n2);
                    ((TinyDocumentImpl)nodeInfo).registerID(tinyNodeImpl, string);
                } else if (this.attTypeCode != null) {
                    this.attTypeCode[this.numberOfAttributes] = 642;
                }
            }
            if ((n5 & 0x1000) != 0) {
                this.initializeAttributeTypeCodes();
                this.attTypeCode[this.numberOfAttributes] = n4 | 0x20000000;
            }
        }
        ++this.numberOfAttributes;
    }

    private void initializeAttributeTypeCodes() {
        if (this.attTypeCode == null) {
            this.attTypeCode = new int[this.attParent.length];
            Arrays.fill(this.attTypeCode, 0, this.numberOfAttributes, 642);
        }
    }

    public void indexIDElement(NodeInfo nodeInfo, int n2, NameChecker nameChecker) {
        String string = ((Object)TinyParentNodeImpl.getStringValue(this, n2)).toString().trim();
        if (nodeInfo.getNodeKind() == 9 && nameChecker.isValidNCName(string)) {
            TinyNodeImpl tinyNodeImpl = this.getNode(n2);
            ((TinyDocumentImpl)nodeInfo).registerID(tinyNodeImpl, string);
        }
    }

    void addNamespace(int n2, int n3) {
        this.ensureNamespaceCapacity();
        this.namespaceParent[this.numberOfNamespaces] = n2;
        this.namespaceCode[this.numberOfNamespaces] = n3;
        if (this.beta[n2] == -1) {
            this.beta[n2] = this.numberOfNamespaces;
        }
        ++this.numberOfNamespaces;
        if (n3 != 65537) {
            this.usesNamespaces = true;
        }
    }

    public TinyNodeImpl getNode(int n2) {
        switch (this.nodeKind[n2]) {
            case 9: {
                return (TinyDocumentImpl)this.documentList.get(this.alpha[n2]);
            }
            case 1: {
                return new TinyElementImpl(this, n2);
            }
            case 3: {
                return new TinyTextImpl(this, n2);
            }
            case 4: {
                return new WhitespaceTextImpl(this, n2);
            }
            case 8: {
                return new TinyCommentImpl(this, n2);
            }
            case 7: {
                return new TinyProcInstImpl(this, n2);
            }
            case 12: {
                throw new IllegalArgumentException("Attempting to treat a parent pointer as a node");
            }
        }
        return null;
    }

    AtomicValue getAtomizedValueOfUntypedNode(int n2) {
        switch (this.nodeKind[n2]) {
            case 1: 
            case 9: {
                int n3;
                short s2 = this.depth[n2];
                if (this.depth[n3] <= s2) {
                    return UntypedAtomicValue.ZERO_LENGTH_UNTYPED;
                }
                if (this.nodeKind[n3] == 3 && this.depth[n3 + 1] <= s2) {
                    int n4 = this.beta[n3];
                    int n5 = this.alpha[n3];
                    return new UntypedAtomicValue(this.charBuffer.subSequence(n5, n5 + n4));
                }
                if (this.nodeKind[n3] == 4 && this.depth[n3 + 1] <= s2) {
                    return new UntypedAtomicValue(WhitespaceTextImpl.getStringValue(this, n3));
                }
                FastStringBuffer fastStringBuffer = null;
                for (n3 = n2 + 1; n3 < this.numberOfNodes && this.depth[n3] > s2; ++n3) {
                    if (this.nodeKind[n3] == 3) {
                        if (fastStringBuffer == null) {
                            fastStringBuffer = new FastStringBuffer(1024);
                        }
                        fastStringBuffer.append(TinyTextImpl.getStringValue(this, n3));
                        continue;
                    }
                    if (this.nodeKind[n3] != 4) continue;
                    if (fastStringBuffer == null) {
                        fastStringBuffer = new FastStringBuffer(1024);
                    }
                    fastStringBuffer.append(WhitespaceTextImpl.getStringValue(this, n3));
                }
                if (fastStringBuffer == null) {
                    return UntypedAtomicValue.ZERO_LENGTH_UNTYPED;
                }
                return new UntypedAtomicValue(fastStringBuffer.condense());
            }
            case 3: {
                return new UntypedAtomicValue(TinyTextImpl.getStringValue(this, n2));
            }
            case 4: {
                return new UntypedAtomicValue(WhitespaceTextImpl.getStringValue(this, n2));
            }
            case 7: 
            case 8: {
                int n6 = this.alpha[n2];
                int n7 = this.beta[n2];
                if (n7 == 0) {
                    return UntypedAtomicValue.ZERO_LENGTH_UNTYPED;
                }
                char[] cArray = new char[n7];
                this.commentBuffer.getChars(n6, n6 + n7, cArray, 0);
                return new StringValue(new CharSlice(cArray, 0, n7));
            }
        }
        throw new IllegalStateException("Unknown node kind");
    }

    TinyAttributeImpl getAttributeNode(int n2) {
        return new TinyAttributeImpl(this, n2);
    }

    int getAttributeAnnotation(int n2) {
        if (this.attTypeCode == null) {
            return 642;
        }
        return this.attTypeCode[n2] & 0x400FFFFF;
    }

    public boolean isIdrefAttribute(int n2) {
        if (this.attTypeCode == null) {
            return false;
        }
        int n3 = this.attTypeCode[n2];
        if ((this.attTypeCode[n2] & 0x20000000) != 0) {
            return true;
        }
        if ((n3 &= 0xFFFFF) == 642) {
            return false;
        }
        if (n3 == 561) {
            return true;
        }
        if (n3 == 562) {
            return true;
        }
        if (n3 < 1024) {
            return false;
        }
        SchemaType schemaType = this.getConfiguration().getSchemaType(n3);
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        if (schemaType instanceof AtomicType) {
            return typeHierarchy.isSubType((AtomicType)schemaType, (AtomicType)BuiltInSchemaFactory.getSchemaType(561));
        }
        if (schemaType instanceof ListType) {
            SimpleType simpleType = ((ListType)schemaType).getItemType();
            if (!(simpleType instanceof AtomicType)) {
                return false;
            }
            return typeHierarchy.isSubType((AtomicType)simpleType, (AtomicType)BuiltInSchemaFactory.getSchemaType(561));
        }
        return false;
    }

    public boolean isIdrefElement(int n2) {
        if (this.typeCodeArray == null) {
            return false;
        }
        int n3 = this.typeCodeArray[n2];
        if ((n3 & 0x20000000) == 0) {
            return this.getConfiguration().getTypeHierarchy().isIdrefsCode(n3 & 0xFFFFF);
        }
        return true;
    }

    void setSystemId(int n2, String string) {
        if (string == null) {
            string = "";
        }
        if (this.systemIdMap == null) {
            this.systemIdMap = new SystemIdMap();
        }
        this.systemIdMap.setSystemId(n2, string);
    }

    String getSystemId(int n2) {
        if (this.systemIdMap == null) {
            return null;
        }
        return this.systemIdMap.getSystemId(n2);
    }

    int getRootNode(int n2) {
        for (int i2 = this.rootIndexUsed - 1; i2 >= 0; --i2) {
            if (this.rootIndex[i2] > n2) continue;
            return this.rootIndex[i2];
        }
        return 0;
    }

    public void setLineNumbering() {
        this.lineNumberMap = new LineNumberMap();
        this.lineNumberMap.setLineNumber(0, 0);
    }

    void setLineNumber(int n2, int n3) {
        if (this.lineNumberMap != null) {
            this.lineNumberMap.setLineNumber(n2, n3);
        }
    }

    int getLineNumber(int n2) {
        if (this.lineNumberMap != null) {
            return this.lineNumberMap.getLineNumber(n2);
        }
        return -1;
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    public boolean isNilled(int n2) {
        if (this.nodeKind[n2] != 1) {
            return false;
        }
        if (this.typeCodeArray == null || this.typeCodeArray[n2] == -1 || this.typeCodeArray[n2] == 641) {
            return false;
        }
        int n3 = this.alpha[n2];
        if (n3 > 0) {
            while (n3 < this.numberOfAttributes && this.attParent[n3] == n2) {
                String string;
                if (this.attCode[n3] == 770 && ((string = ((Object)this.attValue[n3]).toString().trim()).equals("1") || string.equals("true"))) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public void diagnosticDump() {
        int n2;
        System.err.println("    node    type   depth    next   alpha    beta    name");
        for (n2 = 0; n2 < this.numberOfNodes; ++n2) {
            System.err.println(this.n8(n2) + this.n8(this.nodeKind[n2]) + this.n8(this.depth[n2]) + this.n8(this.next[n2]) + this.n8(this.alpha[n2]) + this.n8(this.beta[n2]) + this.n8(this.nameCode[n2]));
        }
        System.err.println("    attr  parent    name    value");
        for (n2 = 0; n2 < this.numberOfAttributes; ++n2) {
            System.err.println(this.n8(n2) + this.n8(this.attParent[n2]) + this.n8(this.attCode[n2]) + "    " + this.attValue[n2]);
        }
        System.err.println("      ns  parent  prefix     uri");
        for (n2 = 0; n2 < this.numberOfNamespaces; ++n2) {
            System.err.println(this.n8(n2) + this.n8(this.namespaceParent[n2]) + this.n8(this.namespaceCode[n2] >> 16) + this.n8(this.namespaceCode[n2] & 0xFFFF));
        }
    }

    private String n8(int n2) {
        String string = "        " + n2;
        return string.substring(string.length() - 8);
    }

    public void showSize() {
        System.err.println("Tree size: " + this.numberOfNodes + " nodes, " + this.charBuffer.length() + " characters, " + this.numberOfAttributes + " attributes");
    }

    private void updateStatistics() {
        int n2;
        int n3 = treesCreated;
        treesCreated = n2 = treesCreated + 1;
        if ((averageNodes = (averageNodes * (double)n3 + (double)this.numberOfNodes) / (double)n2) < 10.0) {
            averageNodes = 10.0;
        }
        if ((averageAttributes = (averageAttributes * (double)n3 + (double)this.numberOfAttributes) / (double)n2) < 10.0) {
            averageAttributes = 10.0;
        }
        if ((averageNamespaces = (averageNamespaces * (double)n3 + (double)this.numberOfNamespaces) / (double)n2) < 5.0) {
            averageNamespaces = 5.0;
        }
        if ((averageCharacters = (averageCharacters * (double)n3 + (double)this.charBuffer.length()) / (double)n2) < 100.0) {
            averageCharacters = 100.0;
        }
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public int getNumberOfAttributes() {
        return this.numberOfAttributes;
    }

    public int getNumberOfNamespaces() {
        return this.numberOfNamespaces;
    }

    public byte[] getNodeKindArray() {
        return this.nodeKind;
    }

    public short[] getNodeDepthArray() {
        return this.depth;
    }

    public int[] getNameCodeArray() {
        return this.nameCode;
    }

    public int[] getTypeCodeArray() {
        return this.typeCodeArray;
    }

    public int[] getNextPointerArray() {
        return this.next;
    }

    public int[] getAlphaArray() {
        return this.alpha;
    }

    public int[] getBetaArray() {
        return this.beta;
    }

    public CharSequence getCharacterBuffer() {
        return this.charBuffer;
    }

    public CharSequence getCommentBuffer() {
        return this.commentBuffer;
    }

    public int[] getAttributeNameCodeArray() {
        return this.attCode;
    }

    public int[] getAttributeTypeCodeArray() {
        return this.attTypeCode;
    }

    public int[] getAttributeParentArray() {
        return this.attParent;
    }

    public CharSequence[] getAttributeValueArray() {
        return this.attValue;
    }

    public int[] getNamespaceCodeArray() {
        return this.namespaceCode;
    }

    public int[] getNamespaceParentArray() {
        return this.namespaceParent;
    }
}

