/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

final class TinyProcInstImpl
extends TinyNodeImpl {
    public TinyProcInstImpl(TinyTree tinyTree, int n2) {
        this.tree = tinyTree;
        this.nodeNr = n2;
    }

    public String getStringValue() {
        int n2 = this.tree.alpha[this.nodeNr];
        int n3 = this.tree.beta[this.nodeNr];
        if (n3 == 0) {
            return "";
        }
        char[] cArray = new char[n3];
        this.tree.commentBuffer.getChars(n2, n2 + n3, cArray, 0);
        return new String(cArray, 0, n3);
    }

    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator(new StringValue(this.getStringValue()));
    }

    public Value atomize() {
        return new StringValue(this.getStringValue());
    }

    public final int getNodeKind() {
        return 7;
    }

    public String getBaseURI() {
        return Navigator.getBaseURI(this);
    }

    public void copy(Receiver receiver, int n2, boolean bl, int n3) throws XPathException {
        receiver.processingInstruction(this.getDisplayName(), this.getStringValue(), 0, 0);
    }

    public String getTarget() {
        return this.getDisplayName();
    }

    public String getData() {
        return this.getStringValue();
    }
}

