/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import java.util.Iterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.tinytree.TinyElementImpl;
import net.sf.saxon.tinytree.TinyTree;

final class DeclaredPrefixIterator
implements Iterator {
    private TinyTree tree;
    private NamePool pool;
    private int owner;
    private int index;

    public DeclaredPrefixIterator(TinyElementImpl tinyElementImpl) {
        this.owner = tinyElementImpl.nodeNr;
        this.tree = tinyElementImpl.tree;
        this.pool = this.tree.getNamePool();
        this.index = this.tree.beta[this.owner];
    }

    public boolean hasNext() {
        return this.index >= 0 && this.tree.namespaceParent[this.index] == this.owner;
    }

    public Object next() {
        int n2 = this.tree.namespaceCode[this.index--];
        return this.pool.getPrefix(n2 >> 16);
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

