/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.JavaExtensionLibrary;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Validation;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.SaxonCollation;
import net.sf.saxon.style.SaxonImportQuery;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetFunctionLibrary;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.style.XSLDecimalFormat;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLGeneralIncorporate;
import net.sf.saxon.style.XSLImport;
import net.sf.saxon.style.XSLImportSchema;
import net.sf.saxon.style.XSLInclude;
import net.sf.saxon.style.XSLKey;
import net.sf.saxon.style.XSLNamespaceAlias;
import net.sf.saxon.style.XSLOutput;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLPreserveSpace;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLVariable;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.Whitespace;

public class XSLStylesheet
extends StyleElement {
    Executable exec = new Executable();
    private LocationMap locationMap = new LocationMap();
    private HashMap globalVariableIndex = new HashMap(20);
    private NamePool targetNamePool;
    private boolean wasIncluded = false;
    private int precedence = 0;
    private int minImportPrecedence = 0;
    private XSLStylesheet importer = null;
    private PreparedStylesheet stylesheet;
    private List topLevel;
    private HashMap templateIndex = new HashMap(20);
    private int inputAnnotations = 0;
    public static final int ANNOTATION_STRIP = 1;
    public static final int ANNOTATION_PRESERVE = 2;
    private HashSet schemaIndex = new HashSet(10);
    private XQueryFunctionLibrary queryFunctions;
    private FunctionLibrary javaFunctions;
    private int numberOfAliases = 0;
    private ArrayList namespaceAliasList = new ArrayList(5);
    private short[] aliasSCodes;
    private int[] aliasNCodes;
    private int largestPatternStackFrame = 0;
    private int defaultValidation = 4;
    private FunctionLibraryList functionLibrary;
    private boolean needsDynamicOutputProperties = false;
    private boolean allowsAllBuiltInTypes = false;

    public void setPreparedStylesheet(PreparedStylesheet preparedStylesheet) {
        Configuration configuration = preparedStylesheet.getConfiguration();
        this.stylesheet = preparedStylesheet;
        this.targetNamePool = preparedStylesheet.getTargetNamePool();
        this.exec.setConfiguration(configuration);
        this.exec.setRuleManager(new RuleManager());
        this.exec.setLocationMap(this.locationMap);
        this.exec.setHostLanguage(50);
        this.functionLibrary = new FunctionLibraryList();
        this.functionLibrary.addFunctionLibrary(new SystemFunctionLibrary(1));
        this.functionLibrary.addFunctionLibrary(new StylesheetFunctionLibrary(this, true));
        this.functionLibrary.addFunctionLibrary(configuration.getVendorFunctionLibrary());
        this.functionLibrary.addFunctionLibrary(new ConstructorFunctionLibrary(configuration));
        this.queryFunctions = new XQueryFunctionLibrary(configuration);
        this.functionLibrary.addFunctionLibrary(this.queryFunctions);
        if (configuration.isAllowExternalFunctions()) {
            this.javaFunctions = configuration.getExtensionBinder();
            this.functionLibrary.addFunctionLibrary(this.javaFunctions);
        }
        this.functionLibrary.addFunctionLibrary(new StylesheetFunctionLibrary(this, false));
    }

    public PreparedStylesheet getPreparedStylesheet() {
        if (this.importer != null) {
            return this.importer.getPreparedStylesheet();
        }
        return this.stylesheet;
    }

    public Executable getExecutable() {
        return this.exec;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public LocationMap getLocationMap() {
        return this.locationMap;
    }

    public NamePool getTargetNamePool() {
        return this.targetNamePool;
    }

    public RuleManager getRuleManager() {
        return this.exec.getRuleManager();
    }

    protected Mode getStripperRules() {
        if (this.exec.getStripperRules() == null) {
            this.exec.setStripperRules(new Mode(-4));
        }
        return this.exec.getStripperRules();
    }

    public boolean stripsWhitespace() {
        for (int i2 = 0; i2 < this.topLevel.size(); ++i2) {
            NodeInfo nodeInfo = (NodeInfo)this.topLevel.get(i2);
            if (nodeInfo.getFingerprint() != 179) continue;
            return true;
        }
        return false;
    }

    public KeyManager getKeyManager() {
        if (this.exec.getKeyManager() == null) {
            this.exec.setKeyManager(new KeyManager(this.getConfiguration()));
        }
        return this.exec.getKeyManager();
    }

    public DecimalFormatManager getDecimalFormatManager() {
        if (this.exec.getDecimalFormatManager() == null) {
            this.exec.setDecimalFormatManager(new DecimalFormatManager());
        }
        return this.exec.getDecimalFormatManager();
    }

    public void setCollation(String string, Comparator comparator, boolean bl) {
        if (this.exec.getCollationTable() == null) {
            this.exec.setCollationTable(new HashMap(20));
        }
        this.exec.getCollationTable().put(string, comparator);
        if (bl) {
            this.exec.setDefaultCollationName(string);
        }
    }

    protected Comparator findCollation(String string) {
        if (string.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            return CodepointCollator.getInstance();
        }
        Comparator comparator = null;
        if (string == null) {
            string = this.exec.getDefaultCollationName();
        }
        if (this.exec.getCollationTable() != null) {
            comparator = (Comparator)this.exec.getCollationTable().get(string);
        }
        if (comparator != null) {
            return comparator;
        }
        XSLStylesheet xSLStylesheet = this.getPrincipalStylesheet();
        List list = xSLStylesheet.getTopLevel();
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            if (!(list.get(i2) instanceof SaxonCollation)) continue;
            SaxonCollation saxonCollation = (SaxonCollation)list.get(i2);
            if (string == null && saxonCollation.isDefaultCollation()) {
                this.exec.setDefaultCollationName(saxonCollation.getCollationName());
                return saxonCollation.getCollator();
            }
            if (!saxonCollation.getCollationName().equals(string)) continue;
            return saxonCollation.getCollator();
        }
        if (string == null) {
            return null;
        }
        Configuration configuration = this.getConfiguration();
        return configuration.getCollationURIResolver().resolve(string, this.getBaseURI(), configuration);
    }

    public String getDefaultCollationName() {
        return this.exec.getDefaultCollationName();
    }

    public XSLCharacterMap getCharacterMap(int n2) {
        for (int i2 = this.topLevel.size() - 1; i2 >= 0; --i2) {
            XSLCharacterMap xSLCharacterMap;
            if (!(this.topLevel.get(i2) instanceof XSLCharacterMap) || (xSLCharacterMap = (XSLCharacterMap)this.topLevel.get(i2)).getCharacterMapFingerprint() != n2) continue;
            return xSLCharacterMap;
        }
        return null;
    }

    public void setPrecedence(int n2) {
        this.precedence = n2;
    }

    public int getPrecedence() {
        if (this.wasIncluded) {
            return this.importer.getPrecedence();
        }
        return this.precedence;
    }

    public int getMinImportPrecedence() {
        return this.minImportPrecedence;
    }

    public void setMinImportPrecedence(int n2) {
        this.minImportPrecedence = n2;
    }

    public void setImporter(XSLStylesheet xSLStylesheet) {
        this.importer = xSLStylesheet;
    }

    public XSLStylesheet getImporter() {
        return this.importer;
    }

    public void setWasIncluded() {
        this.wasIncluded = true;
    }

    public List getTopLevel() {
        return this.topLevel;
    }

    public int allocateGlobalSlot(int n2) {
        return this.exec.getGlobalVariableMap().allocateSlotNumber(n2);
    }

    public void allocatePatternSlots(int n2) {
        if (n2 > this.largestPatternStackFrame) {
            this.largestPatternStackFrame = n2;
        }
    }

    public void prepareAttributes() throws XPathException {
        String string = null;
        String string2 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            int n2 = attributeCollection.getNameCode(i2);
            String string3 = this.getNamePool().getClarkName(n2);
            if (string3 == "version" || string3 == "id" || string3 == "extension-element-prefixes" || string3 == "exclude-result-prefixes") continue;
            if (string3 == "default-validation") {
                this.defaultValidation = Validation.getCode(attributeCollection.getValue(i2));
                if (this.defaultValidation != -1) continue;
                this.compileError("Invalid value for default-validation attribute. Permitted values are (strict, lax, preserve, strip)", "XTSE0020");
                continue;
            }
            if (string3 == "input-type-annotations") {
                string = attributeCollection.getValue(i2);
                continue;
            }
            if (string3 == "{http://saxon.sf.net/}allow-all-built-in-types") {
                string2 = attributeCollection.getValue(i2);
                continue;
            }
            this.checkUnknownAttribute(n2);
        }
        if (this.version == null) {
            this.reportAbsence("version");
        }
        if (string != null) {
            if (string.equals("strip")) {
                this.setInputTypeAnnotations(1);
            } else if (string.equals("preserve")) {
                this.setInputTypeAnnotations(2);
            } else if (!string.equals("unspecified")) {
                this.compileError("Invalid value for input-type-annotations attribute. Permitted values are (strip, preserve, unspecified)", "XTSE0020");
            }
        }
        if (string2 != null) {
            if (string2.equals("yes")) {
                this.allowsAllBuiltInTypes = true;
            } else if (!string.equals("no")) {
                this.compileWarning("Invalid value for saxon:allow-all-built-in-types attribute. Permitted values are (yes, no)", "XTSE0020");
            }
        }
    }

    public int getDefaultValidation() {
        return this.defaultValidation;
    }

    public int getInputTypeAnnotationsAttribute() throws XPathException {
        String string = this.getAttributeValue("input-type-annotations");
        if (string != null) {
            if (string.equals("strip")) {
                this.setInputTypeAnnotations(1);
            } else if (string.equals("preserve")) {
                this.setInputTypeAnnotations(2);
            } else if (!string.equals("unspecified")) {
                this.compileError("Invalid value for input-type-annotations attribute. Permitted values are (strip, preserve, unspecified)", "XTSE0020");
            }
        }
        return this.inputAnnotations;
    }

    public int getInputTypeAnnotations() {
        return this.inputAnnotations;
    }

    public void setInputTypeAnnotations(int n2) throws XPathException {
        this.inputAnnotations |= n2;
        if (this.inputAnnotations == 3) {
            this.compileError("One stylesheet module specifies input-type-annotations='strip', another specifies input-type-annotations='preserve'", "XTSE0265");
        }
    }

    public boolean allowsAllBuiltInTypes() {
        return this.allowsAllBuiltInTypes;
    }

    protected int getNamespaceAlias(short s2) {
        for (int i2 = 0; i2 < this.numberOfAliases; ++i2) {
            if (s2 != this.aliasSCodes[i2]) continue;
            return this.aliasNCodes[i2];
        }
        return s2;
    }

    protected boolean isAliasResultNamespace(short s2) {
        for (int i2 = 0; i2 < this.numberOfAliases; ++i2) {
            if (s2 != (this.aliasNCodes[i2] & 0xFFFF)) continue;
            return true;
        }
        return false;
    }

    public void validate() throws XPathException {
        NodeInfo nodeInfo;
        if (this.validationError != null) {
            this.compileError(this.validationError);
        }
        if (this.getParent().getNodeKind() != 9) {
            this.compileError(this.getDisplayName() + " must be the outermost element", "XTSE0010");
        }
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (nodeInfo.getNodeKind() == 3 || nodeInfo instanceof XSLTemplate || nodeInfo instanceof XSLImport || nodeInfo instanceof XSLInclude || nodeInfo instanceof XSLAttributeSet || nodeInfo instanceof XSLCharacterMap || nodeInfo instanceof XSLDecimalFormat || nodeInfo instanceof XSLFunction || nodeInfo instanceof XSLImportSchema || nodeInfo instanceof XSLKey || nodeInfo instanceof XSLNamespaceAlias || nodeInfo instanceof XSLOutput || nodeInfo instanceof XSLParam || nodeInfo instanceof XSLPreserveSpace || nodeInfo instanceof XSLVariable || nodeInfo instanceof XSLParam || nodeInfo instanceof DataElement || !"http://www.w3.org/1999/XSL/Transform".equals(nodeInfo.getURI()) && !"".equals(nodeInfo.getURI()) || nodeInfo instanceof AbsentExtensionElement && ((StyleElement)nodeInfo).forwardsCompatibleModeIsEnabled()) continue;
            ((StyleElement)nodeInfo).compileError("Element " + nodeInfo.getDisplayName() + " must not appear directly within " + this.getDisplayName() + " because it is not in a namespace", "XTSE0130");
        }
    }

    public void preprocess() throws XPathException {
        Object e2;
        int n2;
        this.spliceIncludes();
        this.buildIndexes();
        this.processAllAttributes();
        this.collectNamespaceAliases();
        for (n2 = 0; n2 < this.topLevel.size(); ++n2) {
            e2 = this.topLevel.get(n2);
            if (!(e2 instanceof StyleElement)) continue;
            ((StyleElement)e2).fixupReferences();
        }
        this.validate();
        for (n2 = 0; n2 < this.topLevel.size(); ++n2) {
            e2 = this.topLevel.get(n2);
            if (!(e2 instanceof StyleElement)) continue;
            ((StyleElement)e2).validateSubtree();
        }
    }

    public void spliceIncludes() throws XPathException {
        NodeInfo nodeInfo;
        boolean bl = false;
        this.topLevel = new ArrayList(50);
        this.minImportPrecedence = this.precedence;
        StyleElement styleElement = this;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (nodeInfo.getNodeKind() == 3) {
                if (Whitespace.isWhite(nodeInfo.getStringValueCS())) continue;
                styleElement.compileError("No character data is allowed between top-level elements", "XTSE0120");
                continue;
            }
            if (nodeInfo instanceof DataElement) {
                bl = true;
                continue;
            }
            styleElement = (StyleElement)nodeInfo;
            if (nodeInfo instanceof XSLGeneralIncorporate) {
                XSLStylesheet xSLStylesheet;
                XSLGeneralIncorporate xSLGeneralIncorporate = (XSLGeneralIncorporate)nodeInfo;
                xSLGeneralIncorporate.processAttributes();
                if (xSLGeneralIncorporate.isImport()) {
                    if (bl) {
                        xSLGeneralIncorporate.compileError("xsl:import elements must come first", "XTSE0200");
                    }
                } else {
                    bl = true;
                }
                if ((xSLStylesheet = xSLGeneralIncorporate.getIncludedStylesheet(this, this.precedence)) == null) {
                    return;
                }
                if (xSLGeneralIncorporate.isImport()) {
                    this.precedence = xSLStylesheet.getPrecedence() + 1;
                } else {
                    this.precedence = xSLStylesheet.getPrecedence();
                    xSLStylesheet.setMinImportPrecedence(this.minImportPrecedence);
                    xSLStylesheet.setWasIncluded();
                }
                List list = xSLStylesheet.topLevel;
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    StyleElement styleElement2 = (StyleElement)list.get(i2);
                    int n2 = this.topLevel.size() - 1;
                    if (n2 < 0 || styleElement2.getPrecedence() >= ((StyleElement)this.topLevel.get(n2)).getPrecedence()) {
                        this.topLevel.add(styleElement2);
                        continue;
                    }
                    while (n2 >= 0 && styleElement2.getPrecedence() < ((StyleElement)this.topLevel.get(n2)).getPrecedence()) {
                        --n2;
                    }
                    this.topLevel.add(n2 + 1, styleElement2);
                }
                continue;
            }
            bl = true;
            this.topLevel.add(nodeInfo);
        }
    }

    private void buildIndexes() throws XPathException {
        Object object;
        for (int i2 = this.topLevel.size() - 1; i2 >= 0; --i2) {
            object = this.topLevel.get(i2);
            if (object instanceof XSLTemplate) {
                this.indexNamedTemplate((XSLTemplate)object);
                continue;
            }
            if (object instanceof XSLVariableDeclaration) {
                this.indexVariableDeclaration((XSLVariableDeclaration)object);
                continue;
            }
            if (object instanceof XSLNamespaceAlias) {
                this.namespaceAliasList.add(object);
                ++this.numberOfAliases;
                continue;
            }
            if (object instanceof XSLImportSchema) {
                try {
                    ((XSLImportSchema)object).readSchema();
                    continue;
                }
                catch (SchemaException schemaException) {
                    throw StaticError.makeStaticError(schemaException);
                }
            }
            if (object instanceof XSLDecimalFormat) {
                ((XSLDecimalFormat)object).register();
                continue;
            }
            if (!(object instanceof SaxonImportQuery)) continue;
            ((SaxonImportQuery)object).importModule();
        }
        Configuration configuration = this.getConfiguration();
        object = this.schemaIndex.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            configuration.sealNamespace(string);
        }
    }

    private void indexVariableDeclaration(XSLVariableDeclaration xSLVariableDeclaration) throws XPathException {
        int n2 = xSLVariableDeclaration.getVariableFingerprint();
        if (n2 != -1) {
            Integer n3 = new Integer(n2);
            XSLVariableDeclaration xSLVariableDeclaration2 = (XSLVariableDeclaration)this.globalVariableIndex.get(n3);
            if (xSLVariableDeclaration2 == null) {
                this.globalVariableIndex.put(n3, xSLVariableDeclaration);
            } else {
                int n4;
                int n5 = xSLVariableDeclaration.getPrecedence();
                if (n5 == (n4 = xSLVariableDeclaration2.getPrecedence())) {
                    xSLVariableDeclaration.compileError("Duplicate global variable declaration (see line " + xSLVariableDeclaration2.getLineNumber() + " of " + xSLVariableDeclaration2.getSystemId() + ')', "XTSE0630");
                } else if (n5 < n4) {
                    xSLVariableDeclaration.setRedundant();
                } else {
                    xSLVariableDeclaration2.setRedundant();
                    this.globalVariableIndex.put(n3, xSLVariableDeclaration);
                }
            }
        }
    }

    private void indexNamedTemplate(XSLTemplate xSLTemplate) throws XPathException {
        int n2 = xSLTemplate.getTemplateFingerprint();
        if (n2 != -1) {
            Integer n3 = new Integer(n2);
            XSLTemplate xSLTemplate2 = (XSLTemplate)this.templateIndex.get(n3);
            if (xSLTemplate2 == null) {
                this.templateIndex.put(n3, xSLTemplate);
            } else {
                int n4;
                int n5 = xSLTemplate.getPrecedence();
                if (n5 == (n4 = xSLTemplate2.getPrecedence())) {
                    xSLTemplate.compileError("Duplicate named template (see line " + xSLTemplate2.getLineNumber() + " of " + xSLTemplate2.getSystemId() + ')', "XTSE0660");
                } else if (n5 >= n4) {
                    this.templateIndex.put(n3, xSLTemplate);
                }
            }
            this.exec.putNamedTemplate(n2, xSLTemplate.getCompiledTemplate());
        }
    }

    private void collectNamespaceAliases() throws XPathException {
        this.aliasSCodes = new short[this.numberOfAliases];
        this.aliasNCodes = new int[this.numberOfAliases];
        int n2 = 0;
        int n3 = -1;
        for (int i2 = 0; i2 < this.numberOfAliases; ++i2) {
            XSLNamespaceAlias xSLNamespaceAlias = (XSLNamespaceAlias)this.namespaceAliasList.get(i2);
            short s2 = xSLNamespaceAlias.getStylesheetURICode();
            int n4 = xSLNamespaceAlias.getResultNamespaceCode();
            int n5 = xSLNamespaceAlias.getPrecedence();
            if (n3 != n5) {
                n3 = n5;
                n2 = i2;
            }
            for (int i3 = n2; i3 < i2; ++i3) {
                if (s2 != this.aliasSCodes[i3] || (n4 & 0xFFFF) == (this.aliasNCodes[i3] & 0xFFFF)) continue;
                xSLNamespaceAlias.compileError("More than one alias is defined for the same namespace prefix", "XTSE0810");
            }
            this.aliasSCodes[i2] = s2;
            this.aliasNCodes[i2] = n4;
        }
        this.namespaceAliasList = null;
    }

    protected boolean hasNamespaceAliases() {
        return this.numberOfAliases > 0;
    }

    public void processAllAttributes() throws XPathException {
        this.prepareAttributes();
        if (this.topLevel == null) {
            return;
        }
        for (int i2 = 0; i2 < this.topLevel.size(); ++i2) {
            Object e2 = this.topLevel.get(i2);
            if (!(e2 instanceof StyleElement)) continue;
            try {
                ((StyleElement)e2).processAllAttributes();
                continue;
            }
            catch (XPathException xPathException) {
                ((StyleElement)e2).compileError(xPathException);
            }
        }
    }

    public XSLVariableDeclaration getGlobalVariable(int n2) {
        return (XSLVariableDeclaration)this.globalVariableIndex.get(new Integer(n2));
    }

    public void setNeedsDynamicOutputProperties(boolean bl) {
        this.needsDynamicOutputProperties = bl;
    }

    public Properties gatherOutputProperties(int n2) throws XPathException {
        boolean bl = n2 == -1;
        Properties properties = new Properties();
        HashMap hashMap = new HashMap(10);
        for (int i2 = this.topLevel.size() - 1; i2 >= 0; --i2) {
            XSLOutput xSLOutput;
            Object e2 = this.topLevel.get(i2);
            if (!(e2 instanceof XSLOutput) || (xSLOutput = (XSLOutput)e2).getOutputFingerprint() != n2) continue;
            bl = true;
            xSLOutput.gatherOutputProperties(properties, hashMap);
        }
        if (!bl) {
            this.compileError("Requested output format " + (n2 == -1 ? "(unnamed)" : this.getNamePool().getClarkName(n2)) + " has not been defined");
        }
        return properties;
    }

    protected void declareXQueryFunction(XQueryFunction xQueryFunction) throws XPathException {
        this.queryFunctions.declareFunction(xQueryFunction);
    }

    protected void declareJavaClass(String string, Class clazz) {
        if (!(this.javaFunctions instanceof JavaExtensionLibrary)) {
            throw new IllegalStateException("saxon:script cannot be used with a custom extension library factory");
        }
        ((JavaExtensionLibrary)this.javaFunctions).declareJavaClass(string, clazz);
    }

    protected boolean isImportedSchema(String string) {
        return this.schemaIndex.contains(string);
    }

    protected void addImportedSchema(String string) {
        this.schemaIndex.add(string);
    }

    protected HashSet getImportedSchemaTable() {
        return this.schemaIndex;
    }

    public Executable compileStylesheet() throws XPathException {
        try {
            Object object;
            Expression expression;
            Object object2;
            try {
                Iterator iterator = this.queryFunctions.getFunctionDefinitions();
                while (iterator.hasNext()) {
                    object2 = (XQueryFunction)iterator.next();
                    ((XQueryFunction)object2).fixupReferences(this.getStaticContext());
                }
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
            for (int i2 = 0; i2 < this.topLevel.size(); ++i2) {
                StyleElement styleElement;
                object2 = (NodeInfo)this.topLevel.get(i2);
                if (!(object2 instanceof StyleElement) || !((expression = (styleElement = (StyleElement)object2).compile(this.exec)) instanceof ComputedExpression)) continue;
                ((ComputedExpression)expression).setLocationId(this.allocateLocationId(this.getSystemId(), styleElement.getLineNumber()));
            }
            if (this.exec.getDecimalFormatManager() != null) {
                try {
                    this.exec.getDecimalFormatManager().fixupDefaultDefault();
                }
                catch (StaticError staticError) {
                    this.compileError(staticError.getMessage(), staticError.getErrorCodeLocalPart());
                }
            }
            this.exec.setStripsWhitespace(this.stripsWhitespace());
            Properties properties = this.gatherOutputProperties(-1);
            properties.setProperty("{http://saxon.sf.net/}stylesheet-version", this.getVersion().toString());
            this.exec.setDefaultOutputProperties(properties);
            object2 = new IntHashSet(5);
            for (int i3 = 0; i3 < this.topLevel.size(); ++i3) {
                int n2;
                expression = this.topLevel.get(i3);
                if (!(expression instanceof XSLOutput) || (n2 = ((XSLOutput)(object = (XSLOutput)((Object)expression))).getOutputFingerprint()) == -1) continue;
                ((IntHashSet)object2).add(n2);
            }
            if (((IntHashSet)object2).isEmpty()) {
                if (this.needsDynamicOutputProperties) {
                    this.compileError("The stylesheet contains xsl:result-document instructions that calculate the output format name at run-time, but there are no named xsl:output declarations", "XTDE1460");
                }
            } else {
                IntIterator intIterator = ((IntHashSet)object2).iterator();
                while (intIterator.hasNext()) {
                    int n3 = intIterator.next();
                    object = this.gatherOutputProperties(n3);
                    if (!this.needsDynamicOutputProperties) continue;
                    this.exec.setOutputProperties(n3, (Properties)object);
                }
            }
            this.exec.setPatternSlotSpace(this.largestPatternStackFrame);
            this.exec.setStripsInputTypeAnnotations(this.inputAnnotations == 1);
            for (int i4 = 0; i4 < this.topLevel.size(); ++i4) {
                XSLCharacterMap xSLCharacterMap;
                if (!(this.topLevel.get(i4) instanceof XSLCharacterMap) || (xSLCharacterMap = (XSLCharacterMap)this.topLevel.get(i4)).isRedundant()) continue;
                int n4 = xSLCharacterMap.getCharacterMapFingerprint();
                IntHashMap intHashMap = new IntHashMap(20);
                xSLCharacterMap.assemble(intHashMap);
                if (this.exec.getCharacterMapIndex() == null) {
                    this.exec.setCharacterMapIndex(new IntHashMap(20));
                }
                this.exec.getCharacterMapIndex().put(n4, intHashMap);
            }
            ExecutableFunctionLibrary executableFunctionLibrary = new ExecutableFunctionLibrary(this.getConfiguration());
            ExecutableFunctionLibrary executableFunctionLibrary2 = new ExecutableFunctionLibrary(this.getConfiguration());
            for (int i5 = 0; i5 < this.topLevel.size(); ++i5) {
                Object e2 = this.topLevel.get(i5);
                if (!(e2 instanceof XSLFunction)) continue;
                XSLFunction xSLFunction = (XSLFunction)e2;
                if (xSLFunction.isOverriding()) {
                    executableFunctionLibrary.addFunction(xSLFunction.getCompiledFunction());
                    continue;
                }
                executableFunctionLibrary2.addFunction(xSLFunction.getCompiledFunction());
            }
            FunctionLibraryList functionLibraryList = new FunctionLibraryList();
            functionLibraryList.addFunctionLibrary(new SystemFunctionLibrary(1));
            functionLibraryList.addFunctionLibrary(executableFunctionLibrary);
            functionLibraryList.addFunctionLibrary(this.getConfiguration().getVendorFunctionLibrary());
            functionLibraryList.addFunctionLibrary(new ConstructorFunctionLibrary(this.getConfiguration()));
            functionLibraryList.addFunctionLibrary(this.queryFunctions);
            if (this.getConfiguration().isAllowExternalFunctions()) {
                functionLibraryList.addFunctionLibrary(this.javaFunctions);
            }
            functionLibraryList.addFunctionLibrary(executableFunctionLibrary2);
            this.exec.setFunctionLibrary(functionLibraryList);
            return this.exec;
        }
        catch (RuntimeException runtimeException) {
            if (this.getPreparedStylesheet().getErrorCount() > 0) {
                return this.exec;
            }
            throw runtimeException;
        }
    }

    public Expression compile(Executable executable) {
        return null;
    }
}

