/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class XSLSort
extends StyleElement {
    private SortKeyDefinition sortKeyDefinition;
    private Expression select;
    private Expression order;
    private Expression dataType = null;
    private Expression caseOrder;
    private Expression lang;
    private Expression collationName;
    private Expression stable;

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            int n2 = attributeCollection.getNameCode(i2);
            String string8 = this.getNamePool().getClarkName(n2);
            if (string8 == "select") {
                string = attributeCollection.getValue(i2);
                continue;
            }
            if (string8 == "order") {
                string2 = attributeCollection.getValue(i2).trim();
                continue;
            }
            if (string8 == "data-type") {
                string3 = attributeCollection.getValue(i2).trim();
                continue;
            }
            if (string8 == "case-order") {
                string4 = attributeCollection.getValue(i2).trim();
                continue;
            }
            if (string8 == "lang") {
                string5 = attributeCollection.getValue(i2).trim();
                continue;
            }
            if (string8 == "collation") {
                string6 = attributeCollection.getValue(i2).trim();
                continue;
            }
            if (string8 == "stable") {
                string7 = attributeCollection.getValue(i2).trim();
                continue;
            }
            this.checkUnknownAttribute(n2);
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        }
        this.order = string2 == null ? new StringValue("ascending") : this.makeAttributeValueTemplate(string2);
        this.dataType = string3 == null ? EmptySequence.getInstance() : this.makeAttributeValueTemplate(string3);
        this.caseOrder = string4 == null ? new StringValue("#default") : this.makeAttributeValueTemplate(string4);
        this.lang = string5 == null ? new StringValue(Locale.getDefault().getLanguage()) : this.makeAttributeValueTemplate(string5);
        this.stable = string7 == null ? null : this.makeAttributeValueTemplate(string7);
        if (string6 != null) {
            this.collationName = this.makeAttributeValueTemplate(string6);
        }
    }

    public void validate() throws XPathException {
        Object object;
        if (this.select != null && this.hasChildNodes()) {
            this.compileError("An xsl:sort element with a select attribute must be empty", "XTSE1015");
        }
        if (this.select == null && !this.hasChildNodes()) {
            this.select = new ContextItemExpression();
        }
        Comparator comparator = null;
        if (this.collationName instanceof StringValue) {
            object = ((StringValue)this.collationName).getStringValue();
            try {
                URI uRI = new URI((String)object);
                if (!uRI.isAbsolute()) {
                    URI uRI2 = new URI(this.getBaseURI());
                    uRI = uRI2.resolve(uRI);
                    object = uRI.toString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                this.compileError("Collation name '" + (String)object + "' is not a valid URI");
                object = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
            }
            comparator = this.getPrincipalStylesheet().findCollation((String)object);
            if (comparator == null) {
                this.compileError("Collation " + (String)object + " has not been defined", "XTDE1035");
                comparator = Collator.getInstance();
            }
        }
        this.select = this.typeCheck("select", this.select);
        this.order = this.typeCheck("order", this.order);
        this.caseOrder = this.typeCheck("case-order", this.caseOrder);
        this.lang = this.typeCheck("lang", this.lang);
        this.dataType = this.typeCheck("data-type", this.dataType);
        this.collationName = this.typeCheck("collation", this.collationName);
        this.stable = this.typeCheck("stable", this.stable);
        if (this.select != null) {
            try {
                object = new RoleLocator(4, "xsl:sort/select", 0, null);
                ((RoleLocator)object).setSourceLocator(new ExpressionLocation(this));
                this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.ATOMIC_SEQUENCE, false, (RoleLocator)object, this.getStaticContext());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
        this.sortKeyDefinition = new SortKeyDefinition();
        this.sortKeyDefinition.setOrder(this.order);
        this.sortKeyDefinition.setCaseOrder(this.caseOrder);
        this.sortKeyDefinition.setLanguage(this.lang);
        this.sortKeyDefinition.setSortKey(this.select);
        this.sortKeyDefinition.setDataTypeExpression(this.dataType);
        this.sortKeyDefinition.setCollationName(this.collationName);
        this.sortKeyDefinition.setCollation(comparator);
        this.sortKeyDefinition.setBaseURI(this.getBaseURI());
        this.sortKeyDefinition.setStable(this.stable);
        this.sortKeyDefinition.setBackwardsCompatible(this.backwardsCompatibleModeIsEnabled());
    }

    protected ItemType getReturnedItemType() {
        return null;
    }

    public Expression compile(Executable executable) throws XPathException {
        if (this.select == null) {
            Expression expression = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
            if (expression instanceof ComputedExpression) {
                ((ComputedExpression)expression).setParentExpression(this);
            }
            if (expression == null) {
                expression = EmptySequence.getInstance();
            }
            try {
                StaticContext staticContext = this.getStaticContext();
                Atomizer atomizer = new Atomizer(expression.simplify(staticContext), staticContext.getConfiguration());
                atomizer.setParentExpression(this.sortKeyDefinition.getParentExpression());
                this.sortKeyDefinition.setSortKey(atomizer);
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
        this.sortKeyDefinition = this.sortKeyDefinition.simplify(this.getStaticContext(), executable);
        return null;
    }

    public SortKeyDefinition getSortKeyDefinition() {
        return this.sortKeyDefinition;
    }

    public Expression getStable() {
        return this.stable;
    }
}

