/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.Err;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Attribute;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.FixedAttribute;
import net.sf.saxon.instruct.SavedNamespaceContext;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.Validation;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLStringConstructor;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.StringValue;

public final class XSLAttribute
extends XSLStringConstructor {
    private Expression attributeName;
    private Expression separator;
    private Expression namespace = null;
    private int validationAction = 3;
    private SimpleType schemaType;

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            int n2 = attributeCollection.getNameCode(i2);
            String string7 = this.getNamePool().getClarkName(n2);
            if (string7 == "name") {
                string = attributeCollection.getValue(i2).trim();
                continue;
            }
            if (string7 == "namespace") {
                string2 = attributeCollection.getValue(i2).trim();
                continue;
            }
            if (string7 == "select") {
                string3 = attributeCollection.getValue(i2);
                continue;
            }
            if (string7 == "separator") {
                string4 = attributeCollection.getValue(i2);
                continue;
            }
            if (string7 == "validation") {
                string5 = attributeCollection.getValue(i2).trim();
                continue;
            }
            if (string7 == "type") {
                string6 = attributeCollection.getValue(i2).trim();
                continue;
            }
            this.checkUnknownAttribute(n2);
        }
        if (string == null) {
            this.reportAbsence("name");
            return;
        }
        this.attributeName = this.makeAttributeValueTemplate(string);
        if (this.attributeName instanceof StringValue) {
            if (!this.getConfiguration().getNameChecker().isQName(((StringValue)this.attributeName).getStringValue())) {
                this.invalidAttributeName("Attribute name " + Err.wrap(string) + " is not a valid QName");
            }
            if (string.equals("xmlns") && this.namespace == null) {
                this.invalidAttributeName("Invalid attribute name: xmlns");
            }
            if (string.startsWith("xmlns:")) {
                if (string2 == null) {
                    this.invalidAttributeName("Invalid attribute name: " + Err.wrap(string));
                } else {
                    string = string.substring(6);
                    this.attributeName = new StringValue(string);
                }
            }
        }
        if (string2 != null) {
            this.namespace = this.makeAttributeValueTemplate(string2);
        }
        if (string3 != null) {
            this.select = this.makeExpression(string3);
        }
        this.separator = string4 == null ? (string3 == null ? StringValue.EMPTY_STRING : StringValue.SINGLE_SPACE) : this.makeAttributeValueTemplate(string4);
        if (string5 != null) {
            this.validationAction = Validation.getCode(string5);
            if (this.validationAction != 4 && !this.getConfiguration().isSchemaAware(50)) {
                this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
                this.validationAction = this.getContainingStylesheet().getDefaultValidation();
            }
            if (this.validationAction == -1) {
                this.compileError("Invalid value of validation attribute", "XTSE0020");
                this.validationAction = this.getContainingStylesheet().getDefaultValidation();
            }
        } else {
            this.validationAction = this.getContainingStylesheet().getDefaultValidation();
        }
        if (string6 != null) {
            if (!this.getConfiguration().isSchemaAware(50)) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            } else {
                SchemaType schemaType = this.getSchemaType(string6);
                if (schemaType == null) {
                    this.compileError("Unknown attribute type " + string6, "XTSE1520");
                } else if (schemaType.isSimpleType()) {
                    this.schemaType = (SimpleType)schemaType;
                } else {
                    this.compileError("Type annotation for attributes must be a simple type", "XTSE1530");
                    schemaType = null;
                }
            }
        }
        if (string6 != null && string5 != null) {
            this.compileError("The validation and type attributes are mutually exclusive", "XTSE1505");
            this.validationAction = this.getContainingStylesheet().getDefaultValidation();
            this.schemaType = null;
        }
    }

    private void invalidAttributeName(String string) throws XPathException {
        this.compileError(string, "XTDE0850");
        this.attributeName = new StringValue("saxon-error-attribute");
    }

    public void validate() throws XPathException {
        if (!(this.getParent() instanceof XSLAttributeSet)) {
            this.checkWithinTemplate();
        }
        if (this.schemaType != null && this.schemaType.isNamespaceSensitive()) {
            this.compileError("Validation at attribute level must not specify a namespace-sensitive type (xs:QName or xs:NOTATION)", "XTTE1545");
        }
        this.attributeName = this.typeCheck("name", this.attributeName);
        this.namespace = this.typeCheck("namespace", this.namespace);
        this.select = this.typeCheck("select", this.select);
        this.separator = this.typeCheck("separator", this.separator);
        super.validate();
    }

    protected String getErrorCodeForSelectPlusContent() {
        return "XTSE0840";
    }

    public Expression compile(Executable executable) throws XPathException {
        Object object;
        SavedNamespaceContext savedNamespaceContext = null;
        int n2 = this.getTypeAnnotation(this.schemaType);
        if (this.attributeName instanceof StringValue) {
            String[] stringArray;
            object = ((StringValue)this.attributeName).getStringValue().trim();
            try {
                stringArray = this.getConfiguration().getNameChecker().getQNameParts((CharSequence)object);
            }
            catch (QNameException qNameException) {
                return null;
            }
            if (this.namespace == null) {
                String string = "";
                if (!stringArray[0].equals("") && (string = this.getURIForPrefix(stringArray[0], false)) == null) {
                    this.undeclaredNamespaceError(stringArray[0], "XTSE0280");
                    return null;
                }
                int n3 = this.getTargetNamePool().allocate(stringArray[0], string, stringArray[1]);
                FixedAttribute fixedAttribute = new FixedAttribute(n3, this.validationAction, this.schemaType, n2);
                fixedAttribute.setParentExpression(this);
                this.compileContent(executable, fixedAttribute, this.separator);
                ExpressionTool.makeParentReferences(fixedAttribute);
                return fixedAttribute;
            }
            if (this.namespace instanceof StringValue) {
                Object object2;
                String string = ((StringValue)this.namespace).getStringValue();
                if (string.equals("")) {
                    stringArray[0] = "";
                } else if (stringArray[0].equals("")) {
                    AxisIterator axisIterator = this.iterateAxis((byte)8);
                    while ((object2 = (NodeInfo)axisIterator.next()) != null) {
                        if (!object2.getStringValue().equals(string)) continue;
                        stringArray[0] = object2.getLocalPart();
                        break;
                    }
                    if (stringArray[0].equals("") && (object2 = this.getTargetNamePool().suggestPrefixForURI(((StringValue)this.namespace).getStringValue())) != null) {
                        stringArray[0] = object2;
                    }
                    if (stringArray[0].equals("")) {
                        stringArray[0] = "ns0";
                    }
                }
                int n4 = this.getTargetNamePool().allocate(stringArray[0], string, stringArray[1]);
                object2 = new FixedAttribute(n4, this.validationAction, this.schemaType, n2);
                this.compileContent(executable, (SimpleNodeConstructor)object2, this.separator);
                ExpressionTool.makeParentReferences((Expression)object2);
                return object2;
            }
        } else if (this.namespace == null) {
            savedNamespaceContext = this.makeNamespaceContext();
        }
        object = new Attribute(this.attributeName, this.namespace, savedNamespaceContext, this.validationAction, this.schemaType, n2, false);
        this.compileContent(executable, (SimpleNodeConstructor)object, this.separator);
        return object;
    }
}

