/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;

public class SaxonScript
extends StyleElement {
    private Class javaClass = null;
    private String implementsURI = null;
    private String language = null;

    public void prepareAttributes() throws XPathException {
        Object object;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            int n2 = attributeCollection.getNameCode(i2);
            object = this.getNamePool().getClarkName(n2);
            if (object == "language") {
                string = attributeCollection.getValue(i2).trim();
                continue;
            }
            if (object == "implements-prefix") {
                string2 = attributeCollection.getValue(i2).trim();
                continue;
            }
            if (object == "src") {
                string3 = attributeCollection.getValue(i2).trim();
                continue;
            }
            if (object == "archive") {
                string4 = attributeCollection.getValue(i2).trim();
                continue;
            }
            this.checkUnknownAttribute(n2);
        }
        if (string2 == null) {
            this.reportAbsence("implements-prefix");
            return;
        }
        this.implementsURI = this.getURIForPrefix(string2, false);
        if (this.implementsURI == null) {
            this.undeclaredNamespaceError(string2, null);
            return;
        }
        if (string == null) {
            this.reportAbsence("language");
            return;
        }
        this.language = string;
        if (this.language.equals("java")) {
            URL uRL;
            if (string3 == null) {
                this.compileError("For java, the src attribute is mandatory");
                return;
            }
            if (!string3.startsWith("java:")) {
                this.compileError("The src attribute must be a URI of the form java:full.class.Name");
                return;
            }
            String string5 = string3.substring(5);
            if (string4 == null) {
                try {
                    this.javaClass = this.getConfiguration().getClass(string5, false, null);
                }
                catch (TransformerException transformerException) {
                    this.compileError(transformerException);
                    return;
                }
            }
            try {
                uRL = new URL(this.getBaseURI());
            }
            catch (MalformedURLException malformedURLException) {
                this.compileError("Invalid base URI " + this.getBaseURI());
                return;
            }
            object = new StringTokenizer(string4);
            int n3 = 0;
            while (((StringTokenizer)object).hasMoreTokens()) {
                ++n3;
                ((StringTokenizer)object).nextToken();
            }
            URL[] uRLArray = new URL[n3];
            n3 = 0;
            object = new StringTokenizer(string4);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string6 = ((StringTokenizer)object).nextToken();
                try {
                    uRLArray[n3++] = new URL(uRL, string6);
                }
                catch (MalformedURLException malformedURLException) {
                    this.compileError("Invalid URL " + string6);
                    return;
                }
            }
            try {
                this.javaClass = new URLClassLoader(uRLArray).loadClass(string5);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.compileError("Cannot find class " + string5 + " in the specified archive" + (n3 > 1 ? "s" : ""));
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.compileError("Cannot use the archive attribute with this Java VM");
            }
        } else {
            this.compileError("The only language supported for Saxon extension functions is 'java'");
        }
        this.getPrincipalStylesheet().declareJavaClass(this.implementsURI, this.javaClass);
    }

    public void validate() throws XPathException {
        this.checkTopLevel(null);
    }

    public Expression compile(Executable executable) throws XPathException {
        return null;
    }
}

