/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.Concat;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.SimpleContentConstructor;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public abstract class AttributeValueTemplate {
    private AttributeValueTemplate() {
    }

    public static Expression make(String string, int n2, StaticContext staticContext) throws XPathException {
        Object object;
        Serializable serializable;
        ArrayList<Expression> arrayList = new ArrayList<Expression>(5);
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = string.indexOf("{", n4);
            int n6 = string.indexOf("{{", n4);
            int n7 = string.indexOf("}", n4);
            int n8 = string.indexOf("}}", n4);
            if (!(n5 >= 0 && n3 >= n5 || n7 >= 0 && n3 >= n7)) {
                AttributeValueTemplate.addStringComponent(arrayList, string, n4, n3);
                break;
            }
            if (n7 >= 0 && (n5 < 0 || n7 < n5)) {
                if (n7 != n8) {
                    serializable = new StaticError("Closing curly brace in attribute value template \"" + string.substring(0, n3) + "\" must be doubled");
                    ((XPathException)serializable).setErrorCode("XTSE0370");
                    throw serializable;
                }
                AttributeValueTemplate.addStringComponent(arrayList, string, n4, n7 + 1);
                n4 = n7 + 2;
                continue;
            }
            if (n6 >= 0 && n6 == n5) {
                AttributeValueTemplate.addStringComponent(arrayList, string, n4, n6 + 1);
                n4 = n6 + 2;
                continue;
            }
            if (n5 >= 0) {
                if (n5 > n4) {
                    AttributeValueTemplate.addStringComponent(arrayList, string, n4, n5);
                }
                object = new ExpressionParser();
                serializable = ((ExpressionParser)object).parse(string, n5 + 1, 115, n2, staticContext);
                serializable = serializable.simplify(staticContext);
                n4 = ((ExpressionParser)object).getTokenizer().currentTokenStartOffset + 1;
                if (staticContext.isInBackwardsCompatibleMode()) {
                    arrayList.add(AttributeValueTemplate.makeFirstItem((Expression)serializable, staticContext));
                    continue;
                }
                arrayList.add(new SimpleContentConstructor((Expression)serializable, StringValue.SINGLE_SPACE).simplify(staticContext));
                continue;
            }
            throw new IllegalStateException("Internal error parsing AVT");
        }
        if (arrayList.size() == 0) {
            return StringValue.EMPTY_STRING;
        }
        if (arrayList.size() == 1) {
            return ((Expression)arrayList.get(0)).simplify(staticContext);
        }
        serializable = (Concat)SystemFunction.makeSystemFunction("concat", arrayList.size(), staticContext.getNamePool());
        object = new Expression[arrayList.size()];
        arrayList.toArray((T[])object);
        ((FunctionCall)serializable).setArguments((Expression[])object);
        ((ComputedExpression)serializable).setLocationId(staticContext.getLocationMap().allocateLocationId(staticContext.getSystemId(), n2));
        return ((FunctionCall)serializable).simplify(staticContext);
    }

    private static void addStringComponent(List list, String string, int n2, int n3) {
        if (n2 < n3) {
            list.add(StringValue.makeStringValue(string.substring(n2, n3)));
        }
    }

    public static Expression makeFirstItem(Expression expression, StaticContext staticContext) {
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        if (!expression.getItemType(typeHierarchy).isAtomicType()) {
            expression = new Atomizer(expression, staticContext.getConfiguration());
        }
        if (Cardinality.allowsMany(expression.getCardinality())) {
            expression = new FirstItemExpression(expression);
        }
        if (!typeHierarchy.isSubType(expression.getItemType(typeHierarchy), Type.STRING_TYPE)) {
            expression = new AtomicSequenceConverter(expression, Type.STRING_TYPE);
        }
        return expression;
    }
}

