/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class SQLQuery
extends ExtensionInstruction {
    Expression connection;
    Expression column;
    Expression table;
    Expression where;
    String rowTag;
    String colTag;
    boolean disable = false;

    public void prepareAttributes() throws XPathException {
        String string;
        String string2 = this.attributeList.getValue("", "column");
        if (string2 == null) {
            this.reportAbsence("column");
        }
        this.column = this.makeAttributeValueTemplate(string2);
        String string3 = this.attributeList.getValue("", "table");
        if (string3 == null) {
            this.reportAbsence("table");
        }
        this.table = this.makeAttributeValueTemplate(string3);
        String string4 = this.attributeList.getValue("", "where");
        this.where = string4 == null ? StringValue.EMPTY_STRING : this.makeAttributeValueTemplate(string4);
        String string5 = this.attributeList.getValue("", "connection");
        if (string5 == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(string5);
        }
        this.rowTag = this.attributeList.getValue("", "row-tag");
        if (this.rowTag == null) {
            this.rowTag = "row";
        }
        if (this.rowTag.indexOf(58) >= 0) {
            this.compileError("rowTag must not contain a colon");
        }
        this.colTag = this.attributeList.getValue("", "column-tag");
        if (this.colTag == null) {
            this.colTag = "col";
        }
        if (this.colTag.indexOf(58) >= 0) {
            this.compileError("colTag must not contain a colon");
        }
        if ((string = this.attributeList.getValue("", "disable-output-escaping")) != null) {
            if (string.equals("yes")) {
                this.disable = true;
            } else if (string.equals("no")) {
                this.disable = false;
            } else {
                this.compileError("disable-output-escaping attribute must be either yes or no");
            }
        }
    }

    public void validate() throws XPathException {
        super.validate();
        this.column = this.typeCheck("column", this.column);
        this.table = this.typeCheck("table", this.table);
        this.where = this.typeCheck("where", this.where);
        this.connection = this.typeCheck("connection", this.connection);
    }

    public Expression compile(Executable executable) throws XPathException {
        QueryInstruction queryInstruction = new QueryInstruction(this.connection, this.column, this.table, this.where, this.rowTag, this.colTag, this.disable);
        return queryInstruction;
    }

    private static class QueryInstruction
    extends SimpleExpression {
        public static final int CONNECTION = 0;
        public static final int COLUMN = 1;
        public static final int TABLE = 2;
        public static final int WHERE = 3;
        String rowTag;
        String colTag;
        int options;

        public QueryInstruction(Expression expression, Expression expression2, Expression expression3, Expression expression4, String string, String string2, boolean bl) {
            Expression[] expressionArray = new Expression[]{expression, expression2, expression3, expression4};
            this.setArguments(expressionArray);
            this.rowTag = string;
            this.colTag = string2;
            this.options = bl ? 1 : 0;
        }

        public int getImplementationMethod() {
            return 4;
        }

        public String getExpressionType() {
            return "sql:query";
        }

        /*
         * Loose catch block
         */
        public void process(XPathContext xPathContext) throws XPathException {
            block24: {
                SQLException sQLException3222;
                boolean bl;
                Controller controller = xPathContext.getController();
                Item item = this.arguments[0].evaluateItem(xPathContext);
                if (!(item instanceof ObjectValue) || !(((ObjectValue)item).getObject() instanceof Connection)) {
                    DynamicError dynamicError = new DynamicError("Value of connection expression is not a JDBC Connection");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                Connection connection = (Connection)((ObjectValue)item).getObject();
                String string = this.arguments[1].evaluateAsString(xPathContext);
                String string2 = this.arguments[2].evaluateAsString(xPathContext);
                String string3 = this.arguments[3].evaluateAsString(xPathContext);
                NamePool namePool = controller.getNamePool();
                int n2 = namePool.allocate("", "", this.rowTag);
                int n3 = namePool.allocate("", "", this.colTag);
                Statement statement = null;
                ResultSet resultSet = null;
                DynamicError dynamicError = null;
                try {
                    block21: {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("SELECT " + string + " FROM " + string2);
                        if (string3 != "") {
                            stringBuffer.append(" WHERE " + string3);
                        }
                        statement = connection.prepareStatement(stringBuffer.toString());
                        controller.setUserData(this, "sql:statement", statement);
                        resultSet = statement.executeQuery();
                        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
                        String string4 = "";
                        int n4 = resultSet.getMetaData().getColumnCount();
                        while (resultSet.next()) {
                            sequenceReceiver.startElement(n2, 641, this.locationId, 0);
                            for (int i2 = 1; i2 <= n4; ++i2) {
                                string4 = resultSet.getString(i2);
                                sequenceReceiver.startElement(n3, 641, this.locationId, 0);
                                if (string4 != null) {
                                    sequenceReceiver.characters(string4, this.locationId, this.options);
                                }
                                sequenceReceiver.endElement();
                            }
                            sequenceReceiver.endElement();
                        }
                        if (connection.getAutoCommit()) break block21;
                        connection.commit();
                    }
                    Object var20_21 = null;
                    boolean bl2 = bl = dynamicError != null;
                }
                catch (Throwable throwable) {
                    SQLException sQLException22222;
                    boolean bl3;
                    Object var20_22 = null;
                    boolean bl4 = bl3 = dynamicError != null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException22222) {
                            dynamicError = new DynamicError("(SQL) " + sQLException22222.getMessage());
                            dynamicError.setXPathContext(xPathContext);
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException22222) {
                            dynamicError = new DynamicError("(SQL) " + sQLException22222.getMessage());
                            dynamicError.setXPathContext(xPathContext);
                        }
                    }
                    if (!bl3 && dynamicError != null) {
                        throw dynamicError;
                    }
                    throw throwable;
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException3222) {
                        dynamicError = new DynamicError("(SQL) " + sQLException3222.getMessage());
                        dynamicError.setXPathContext(xPathContext);
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException3222) {
                        dynamicError = new DynamicError("(SQL) " + sQLException3222.getMessage());
                        dynamicError.setXPathContext(xPathContext);
                    }
                }
                if (!bl && dynamicError != null) {
                    throw dynamicError;
                }
                break block24;
                {
                    catch (SQLException sQLException4) {
                        dynamicError = new DynamicError("(SQL) " + sQLException4.getMessage());
                        dynamicError.setXPathContext(xPathContext);
                        throw dynamicError;
                    }
                }
            }
        }
    }
}

