/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.Item;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class SQLConnect
extends ExtensionInstruction {
    Expression database;
    Expression driver;
    Expression user;
    Expression password;

    public boolean mayContainSequenceConstructor() {
        return false;
    }

    public void prepareAttributes() throws XPathException {
        String string = this.attributeList.getValue("", "database");
        if (string == null) {
            this.reportAbsence("database");
            string = "";
        }
        this.database = this.makeAttributeValueTemplate(string);
        String string2 = this.attributeList.getValue("", "driver");
        if (string2 == null) {
            if (string.length() > 9 && string.substring(0, 9).equals("jdbc:odbc")) {
                string2 = "sun.jdbc.odbc.JdbcOdbcDriver";
            } else {
                this.reportAbsence("driver");
            }
        }
        this.driver = this.makeAttributeValueTemplate(string2);
        String string3 = this.attributeList.getValue("", "user");
        this.user = string3 == null ? StringValue.EMPTY_STRING : this.makeAttributeValueTemplate(string3);
        String string4 = this.attributeList.getValue("", "password");
        this.password = string4 == null ? StringValue.EMPTY_STRING : this.makeAttributeValueTemplate(string4);
    }

    public void validate() throws XPathException {
        super.validate();
        this.database = this.typeCheck("database", this.database);
        this.driver = this.typeCheck("driver", this.driver);
        this.user = this.typeCheck("user", this.user);
        this.password = this.typeCheck("password", this.password);
    }

    public Expression compile(Executable executable) throws XPathException {
        return new ConnectInstruction(this.database, this.driver, this.user, this.password);
    }

    private static class ConnectInstruction
    extends SimpleExpression {
        public static final int DATABASE = 0;
        public static final int DRIVER = 1;
        public static final int USER = 2;
        public static final int PASSWORD = 3;

        public ConnectInstruction(Expression expression, Expression expression2, Expression expression3, Expression expression4) {
            Expression[] expressionArray = new Expression[]{expression, expression2, expression3, expression4};
            this.setArguments(expressionArray);
        }

        public int getImplementationMethod() {
            return 1;
        }

        public int computeCardinality() {
            return 16384;
        }

        public String getExpressionType() {
            return "sql:connect";
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            Connection connection = null;
            String string = this.arguments[0].evaluateAsString(xPathContext);
            String string2 = this.arguments[1].evaluateAsString(xPathContext);
            String string3 = this.arguments[2].evaluateAsString(xPathContext);
            String string4 = this.arguments[3].evaluateAsString(xPathContext);
            try {
                Class.forName(string2);
                connection = DriverManager.getConnection(string, string3, string4);
            }
            catch (Exception exception) {
                this.dynamicError("JDBC Connection Failure: " + exception.getMessage(), "SXSQL003", xPathContext);
            }
            return new ObjectValue(connection);
        }
    }
}

