/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sql;

import java.sql.Connection;
import java.sql.SQLException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.Item;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;

public class SQLClose
extends ExtensionInstruction {
    Expression connection = null;

    public void prepareAttributes() throws XPathException {
        String string = this.getAttributeList().getValue("", "connection");
        if (string == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(string);
        }
    }

    public void validate() throws XPathException {
        super.validate();
        this.connection = this.typeCheck("connection", this.connection);
    }

    public Expression compile(Executable executable) throws XPathException {
        return new CloseInstruction(this.connection);
    }

    private static class CloseInstruction
    extends SimpleExpression {
        public static final int CONNECTION = 0;

        public CloseInstruction(Expression expression) {
            Expression[] expressionArray = new Expression[]{expression};
            this.setArguments(expressionArray);
        }

        public int getImplementationMethod() {
            return 1;
        }

        public String getExpressionType() {
            return "sql:close";
        }

        public int computeCardinality() {
            return 24576;
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            Item item = this.arguments[0].evaluateItem(xPathContext);
            if (!(item instanceof ObjectValue) || !(((ObjectValue)item).getObject() instanceof Connection)) {
                this.dynamicError("Value of connection expression is not a JDBC Connection", "SXSQL001", xPathContext);
            }
            Connection connection = (Connection)((ObjectValue)item).getObject();
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                this.dynamicError("(SQL) Failed to close connection: " + sQLException.getMessage(), "SXSQL002", xPathContext);
            }
            return null;
        }
    }
}

