/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;

public class IntToIntHashMap
implements Serializable {
    private static final int NBIT = 30;
    private static final int NMAX = 0x40000000;
    private double _factor;
    private int _defaultValue = Integer.MAX_VALUE;
    private int _nmax;
    private int _n;
    private int _nlo;
    private int _nhi;
    private int _shift;
    private int _mask;
    private int[] _key;
    private int[] _value;
    private boolean[] _filled;

    public IntToIntHashMap() {
        this(8, 0.25);
    }

    public IntToIntHashMap(int n2) {
        this(n2, 0.25);
    }

    public IntToIntHashMap(int n2, double d2) {
        this._factor = d2;
        this.setCapacity(n2);
    }

    public void setDefaultValue(int n2) {
        this._defaultValue = n2;
    }

    public void clear() {
        this._n = 0;
        for (int i2 = 0; i2 < this._nmax; ++i2) {
            this._filled[i2] = false;
        }
    }

    public boolean find(int n2) {
        return this._filled[this.indexOf(n2)];
    }

    public int get(int n2) {
        int n3 = this.indexOf(n2);
        return this._filled[n3] ? this._value[n3] : this._defaultValue;
    }

    public int size() {
        return this._n;
    }

    public boolean remove(int n2) {
        int n3 = this.indexOf(n2);
        if (!this._filled[n3]) {
            return false;
        }
        --this._n;
        while (true) {
            int n4;
            this._filled[n3] = false;
            int n5 = n3;
            do {
                if (this._filled[n3 = n3 - 1 & this._mask]) continue;
                return true;
            } while (n3 <= (n4 = this.hash(this._key[n3])) && n4 < n5 || n4 < n5 && n5 < n3 || n5 < n3 && n3 <= n4);
            this._key[n5] = this._key[n3];
            this._value[n5] = this._value[n3];
            this._filled[n5] = this._filled[n3];
        }
    }

    public void put(int n2, int n3) {
        int n4 = this.indexOf(n2);
        if (this._filled[n4]) {
            this._value[n4] = n3;
        } else {
            this._key[n4] = n2;
            this._value[n4] = n3;
            this._filled[n4] = true;
            this.grow();
        }
    }

    private int hash(int n2) {
        return 1327217885 * n2 >> this._shift & this._mask;
    }

    private int indexOf(int n2) {
        int n3 = this.hash(n2);
        while (this._filled[n3]) {
            if (this._key[n3] == n2) {
                return n3;
            }
            n3 = n3 - 1 & this._mask;
        }
        return n3;
    }

    private void grow() {
        ++this._n;
        if (this._n > 0x40000000) {
            throw new RuntimeException("number of keys mapped exceeds 1073741824");
        }
        if (this._nlo < this._n && this._n <= this._nhi) {
            this.setCapacity(this._n);
        }
    }

    private void setCapacity(int n2) {
        int n3;
        if (n2 < this._n) {
            n2 = this._n;
        }
        double d2 = this._factor < 0.01 ? 0.01 : (this._factor > 0.99 ? 0.99 : this._factor);
        int n4 = 1;
        for (n3 = 2; (double)n3 * d2 < (double)n2 && n3 < 0x40000000; n3 *= 2) {
            ++n4;
        }
        int n5 = this._nmax;
        if (n3 == n5) {
            return;
        }
        this._nmax = n3;
        this._nlo = (int)((double)n3 * d2);
        this._nhi = (int)(1.073741824E9 * d2);
        this._shift = 31 - n4;
        this._mask = n3 - 1;
        int[] nArray = this._key;
        int[] nArray2 = this._value;
        boolean[] blArray = this._filled;
        this._n = 0;
        this._key = new int[n3];
        this._value = new int[n3];
        this._filled = new boolean[n3];
        if (nArray != null) {
            for (int i2 = 0; i2 < n5; ++i2) {
                if (!blArray[i2]) continue;
                this.put(nArray[i2], nArray2[i2]);
            }
        }
    }
}

